/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.frontend;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.jooby.funzy.Try;

public interface NodeTask {
    default public void execute(String cmd, String ... args) {
        String cmdline = cmd + Arrays.asList(args).stream().collect(Collectors.joining(" "));
        String runkey = "frontend." + cmdline.replace(" ", ".");
        boolean run = Boolean.parseBoolean(System.getProperty(runkey, "true"));
        if (run) {
            Runnable action = () -> Try.run(() -> {
                System.setProperty(runkey, "false");
                this.executeSync(cmd, args);
            }).onComplete(() -> System.setProperty(runkey, "true"));
            Thread thread = new Thread(action, cmd);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void executeSync(String var1, String ... var2) throws Exception;
}

