/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.invocation.Gradle;
import org.jooby.run.ApiToolTask;
import org.jooby.run.AssetTask;
import org.jooby.run.JoobyProject;
import org.jooby.run.JoobyTask;

public class JoobyPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        this.configureJoobyRun(project);
        this.configureJoobyAssets(project);
        this.configureApiTool(project);
    }

    private void configureJoobyRun(Project project) {
        project.getTasks().withType(JoobyTask.class, joobyRun -> {
            ConventionMapping mapping = joobyRun.getConventionMapping();
            mapping.map("classpath", () -> new JoobyProject(project).classpath());
            mapping.map("src", () -> new JoobyProject(project).sources());
            mapping.map("mainClassName", () -> project.getProperties().get("mainClassName"));
            mapping.map("srcExtensions", () -> Arrays.asList(".java", ".conf", ".properties", ".kt"));
            mapping.map("compiler", () -> {
                File eclipseClasspath = new File(project.getProjectDir(), ".classpath");
                return eclipseClasspath.exists() ? "off" : "on";
            });
            Gradle gradle = project.getGradle();
            mapping.map("block", () -> !gradle.getStartParameter().isContinuous());
            mapping.map("logLevel", () -> gradle.getStartParameter().getLogLevel().name());
        });
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type", JoobyTask.class);
        options.put("dependsOn", "classes");
        options.put("name", "joobyRun");
        options.put("description", "Run, debug and hot reload applications");
        options.put("group", "jooby");
        project.getTasks().create(options);
    }

    private void configureJoobyAssets(Project project) {
        project.getTasks().withType(AssetTask.class, task -> {
            ConventionMapping mapping = task.getConventionMapping();
            mapping.map("env", () -> "dist");
            mapping.map("maxAge", () -> "365d");
            mapping.map("mainClassName", () -> project.getProperties().get("mainClassName"));
            mapping.map("output", () -> new JoobyProject(project).classes());
            mapping.map("assemblyOutput", () -> new File(project.getBuildDir(), "__public_"));
        });
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type", AssetTask.class);
        options.put("dependsOn", "classes");
        options.put("name", "joobyAssets");
        options.put("description", "Process, optimize and compress static files");
        options.put("group", "jooby");
        project.getTasks().create(options);
    }

    private void configureApiTool(Project project) {
        project.getTasks().withType(ApiToolTask.class, task -> {
            ConventionMapping mapping = task.getConventionMapping();
            mapping.map("mainClassName", () -> project.getProperties().get("mainClassName"));
        });
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type", ApiToolTask.class);
        options.put("dependsOn", "classes");
        options.put("name", "joobyApiTool");
        options.put("description", "Export your HTTP API to open standards like Swagger and RAML");
        options.put("group", "jooby");
        project.getTasks().create(options);
    }

    private static String os(String os) {
        if (os.contains("windows")) {
            return "win32";
        }
        if (os.contains("linux")) {
            return "linux";
        }
        if (os.contains("mac")) {
            return "macosx";
        }
        return os;
    }

    private static String osarch(String arch) {
        if (arch.contains("x86_64")) {
            return "x86_64";
        }
        if (arch.contains("x86")) {
            return "x86";
        }
        if (arch.contains("amd64")) {
            return "amd64";
        }
        return arch;
    }

    static {
        String family = JoobyPlugin.os(System.getProperty("os.name", "").toLowerCase());
        String arch = JoobyPlugin.osarch(System.getProperty("os.arch", "").toLowerCase());
        String j2v8 = "j2v8_" + family + "_" + arch;
        System.getProperties().put("j2v8", j2v8);
    }
}

