/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.jooby.funzy.Throwing;

public class JoobyProject {
    private final Project project;

    public JoobyProject(Project project) {
        this.project = project;
    }

    public File classes() {
        SourceSet sourceSet = this.sourceSet(this.project);
        return sourceSet.getRuntimeClasspath().getFiles().stream().filter(f -> f.exists() && f.isDirectory() && f.toString().contains("classes")).findFirst().get();
    }

    public Set<File> classpath() {
        SourceSet sourceSet = this.sourceSet(this.project);
        LinkedHashSet<File> cp = new LinkedHashSet<File>(sourceSet.getResources().getSrcDirs());
        cp.addAll(sourceSet.getRuntimeClasspath().getFiles());
        Configuration provided = (Configuration)this.project.getConfigurations().findByName("provided");
        if (provided != null) {
            cp.addAll(provided.getFiles());
        }
        return cp;
    }

    public Set<File> sources() {
        SourceSet sourceSet = this.sourceSet(this.project);
        LinkedHashSet<File> src = new LinkedHashSet<File>(sourceSet.getResources().getSrcDirs());
        sourceSet.getJava().getSrcDirs().forEach(f -> src.add(f.getParentFile()));
        return src;
    }

    public File javaSrc() {
        SourceSet sourceSet = this.sourceSet(this.project);
        return (File)sourceSet.getJava().getSrcDirs().iterator().next();
    }

    private SourceSet sourceSet(Project project) {
        return (SourceSet)this.getJavaConvention(project).getSourceSets().getByName("main");
    }

    public JavaPluginConvention getJavaConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    public URLClassLoader newClassLoader() {
        return JoobyProject.toClassLoader(this.classpath().stream().map(Throwing.throwingFunction(f -> f.toURI().toURL())).collect(Collectors.toList()), this.getClass().getClassLoader());
    }

    private static URLClassLoader toClassLoader(final List<URL> cp, ClassLoader parent) {
        return new URLClassLoader(cp.toArray(new URL[cp.size()]), parent){

            public String toString() {
                return cp.toString();
            }
        };
    }
}

