/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbm;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Registry;
import org.jooby.Route;
import org.jooby.hbm.UnitOfWork;
import org.jooby.internal.hbm.GuiceBeanManager;
import org.jooby.internal.hbm.OpenSessionInView;
import org.jooby.internal.hbm.ScanEnvImpl;
import org.jooby.internal.hbm.SessionProvider;
import org.jooby.internal.hbm.UnitOfWorkProvider;

public class Hbm
implements Jooby.Module {
    private static final BiConsumer NOOP = (r, c) -> {};
    private final List<BiConsumer<SessionFactoryImplementor, Registry>> listeners = new ArrayList<BiConsumer<SessionFactoryImplementor, Registry>>();
    private final List<Consumer<Binder>> bindings = new ArrayList<Consumer<Binder>>();
    private final List<BiConsumer<MetadataSources, Config>> sources = new ArrayList<BiConsumer<MetadataSources, Config>>();
    private final String name;
    private BiConsumer<BootstrapServiceRegistryBuilder, Config> bsrb = NOOP;
    private BiConsumer<StandardServiceRegistryBuilder, Config> ssrb = NOOP;
    private BiConsumer<MetadataSources, Config> metaSources = NOOP;
    private BiConsumer<SessionFactoryBuilder, Config> sfb = NOOP;
    private BiConsumer<SessionFactory, Config> sf = NOOP;

    public Hbm(String db) {
        this.name = db;
    }

    public Hbm() {
        this("db");
    }

    public Hbm classes(Class ... classes) {
        this.sources.add((m, c) -> Arrays.stream(classes).forEach(arg_0 -> ((MetadataSources)m).addAnnotatedClass(arg_0)));
        return this;
    }

    public Hbm scan(String ... packages) {
        this.sources.add((m, c) -> Arrays.stream(packages).forEach(arg_0 -> ((MetadataSources)m).addPackage(arg_0)));
        return this;
    }

    public Hbm scan() {
        this.sources.add((m, conf) -> Stream.of(conf.getAnyRef("hibernate.packagesToScan")).flatMap(it -> {
            if (it instanceof List) {
                return ((List)it).stream();
            }
            return Stream.of(it);
        }).forEach(it -> m.addPackage(it.toString())));
        return this;
    }

    public static Route.Filter openSessionInView() {
        return new OpenSessionInView();
    }

    public <T> Hbm onEvent(EventType<T> type, Class<? extends T> listenerType) {
        this.bindings.add(b -> b.bind(listenerType).asEagerSingleton());
        this.listeners.add((s, r) -> {
            ServiceRegistryImplementor serviceRegistry = s.getServiceRegistry();
            EventListenerRegistry service = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
            Object listener = r.require(listenerType);
            service.appendListeners(type, new Object[]{listener});
        });
        return this;
    }

    public <T> Hbm doWithBootstrap(BiConsumer<BootstrapServiceRegistryBuilder, Config> configurer) {
        this.bsrb = configurer;
        return this;
    }

    public <T> Hbm doWithBootstrap(Consumer<BootstrapServiceRegistryBuilder> configurer) {
        return this.doWithBootstrap((BootstrapServiceRegistryBuilder builder, Config conf) -> configurer.accept((BootstrapServiceRegistryBuilder)builder));
    }

    public <T> Hbm doWithRegistry(Consumer<StandardServiceRegistryBuilder> configurer) {
        return this.doWithRegistry((StandardServiceRegistryBuilder builder, Config conf) -> configurer.accept((StandardServiceRegistryBuilder)builder));
    }

    public <T> Hbm doWithRegistry(BiConsumer<StandardServiceRegistryBuilder, Config> configurer) {
        this.ssrb = configurer;
        return this;
    }

    public <T> Hbm doWithSources(Consumer<MetadataSources> configurer) {
        return this.doWithSources((MetadataSources builder, Config conf) -> configurer.accept((MetadataSources)builder));
    }

    public <T> Hbm doWithSources(BiConsumer<MetadataSources, Config> configurer) {
        this.metaSources = configurer;
        return this;
    }

    public <T> Hbm doWithSessionFactoryBuilder(Consumer<SessionFactoryBuilder> configurer) {
        return this.doWithSessionFactoryBuilder((SessionFactoryBuilder builder, Config conf) -> configurer.accept((SessionFactoryBuilder)builder));
    }

    public <T> Hbm doWithSessionFactory(BiConsumer<SessionFactory, Config> configurer) {
        this.sf = configurer;
        return this;
    }

    public <T> Hbm doWithSessionFactory(Consumer<SessionFactory> configurer) {
        return this.doWithSessionFactory((SessionFactory builder, Config conf) -> configurer.accept((SessionFactory)builder));
    }

    public <T> Hbm doWithSessionFactoryBuilder(BiConsumer<SessionFactoryBuilder, Config> configurer) {
        this.sfb = configurer;
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        Key dskey = Key.get(DataSource.class, (Annotation)Names.named((String)this.name));
        DataSource ds = (DataSource)env.get(dskey).orElseThrow(() -> new NoSuchElementException("DataSource missing: " + dskey));
        BootstrapServiceRegistryBuilder bsrb = new BootstrapServiceRegistryBuilder();
        this.bsrb.accept(bsrb, conf);
        String ddl_auto = env.name().equals("dev") ? "update" : "none";
        BootstrapServiceRegistry bsr = bsrb.build();
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder(bsr);
        ssrb.applySetting("hibernate.hbm2ddl.auto", (Object)ddl_auto);
        ssrb.applySettings(Hbm.settings(env, conf));
        this.ssrb.accept(ssrb, conf);
        ssrb.applySetting("hibernate.connection.datasource", (Object)ds);
        ssrb.applySetting("hibernate.delay_cdi_access", (Object)true);
        CompletableFuture<Registry> registry = new CompletableFuture<Registry>();
        ssrb.applySetting("javax.persistence.bean.manager", (Object)GuiceBeanManager.beanManager(registry));
        StandardServiceRegistry serviceRegistry = ssrb.build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)serviceRegistry);
        this.sources.forEach(src -> src.accept(sources, conf));
        this.metaSources.accept(sources, conf);
        List<URL> packages = sources.getAnnotatedPackages().stream().map(pkg -> this.getClass().getResource("/" + pkg.replace('.', '/'))).collect(Collectors.toList());
        Metadata metadata = sources.getMetadataBuilder().applyImplicitNamingStrategy(ImplicitNamingStrategyJpaCompliantImpl.INSTANCE).applyScanEnvironment((ScanEnvironment)new ScanEnvImpl(packages)).build();
        SessionFactoryBuilder sfb = metadata.getSessionFactoryBuilder();
        this.sfb.accept(sfb, conf);
        sfb.applyName(this.name);
        SessionFactory sessionFactory = sfb.build();
        this.sf.accept(sessionFactory, conf);
        SessionProvider session = new SessionProvider(sessionFactory);
        Env.ServiceKey serviceKey = env.serviceKey();
        serviceKey.generate(SessionFactory.class, this.name, k -> binder.bind(k).toInstance((Object)sessionFactory));
        serviceKey.generate(EntityManagerFactory.class, this.name, k -> binder.bind(k).toInstance((Object)sessionFactory));
        serviceKey.generate(Session.class, this.name, k -> binder.bind(k).toProvider(session));
        serviceKey.generate(EntityManager.class, this.name, k -> binder.bind(k).toProvider(session));
        UnitOfWorkProvider uow = new UnitOfWorkProvider(sessionFactory);
        serviceKey.generate(UnitOfWork.class, this.name, k -> binder.bind(k).toProvider(uow));
        this.bindings.forEach(it -> it.accept(binder));
        env.onStart(r -> {
            registry.complete((Registry)r);
            this.listeners.forEach(it -> it.accept((SessionFactoryImplementor)sessionFactory, r));
        });
        env.onStop(() -> ((SessionFactory)sessionFactory).close());
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"hbm.conf");
    }

    private static Map<Object, Object> settings(Env env, Config config) {
        HashMap<Object, Object> $ = new HashMap<Object, Object>();
        config.getConfig("hibernate").entrySet().stream().filter(it -> !((String)it.getKey()).equals("packagesToScan")).forEach(e -> $.put("hibernate." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped()));
        return $;
    }
}

