/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbm;

import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jooby.hbm.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnitOfWork
implements UnitOfWork {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Session session;

    public AbstractUnitOfWork(Session session) {
        this.session = Objects.requireNonNull(session, "Session required.");
    }

    protected void active(Session session, Consumer<Transaction> active, Consumer<Transaction> inactive) {
        Transaction trx = session.getTransaction();
        if (trx.isActive()) {
            active.accept(trx);
        } else {
            inactive.accept(trx);
        }
    }

    protected String oid(Object value) {
        return Integer.toHexString(System.identityHashCode(value));
    }
}

