/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbm;

import java.sql.Connection;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.jooby.hbm.UnitOfWork;
import org.jooby.internal.hbm.AbstractUnitOfWork;

public class RootUnitOfWork
extends AbstractUnitOfWork {
    private volatile boolean rollbackOnly;
    private volatile boolean readOnly;

    public RootUnitOfWork(Session session) {
        super(session);
        this.bind(session);
        session.setHibernateFlushMode(FlushMode.AUTO);
    }

    public UnitOfWork begin() {
        if (this.rollbackOnly) {
            return this;
        }
        this.active(this.session, trx -> this.log.debug("joining existing transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(trx)), trx -> {
            this.log.debug("begin transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(trx));
            trx.begin();
        });
        return this;
    }

    public UnitOfWork commit() {
        if (this.rollbackOnly) {
            return this;
        }
        if (!this.readOnly) {
            this.log.debug("flusing session: {}", (Object)this.oid(this.session));
            this.session.flush();
        } else {
            this.log.debug("flusing ignored on read-only session: {}", (Object)this.oid(this.session));
        }
        this.active(this.session, trx -> {
            this.log.debug("commiting transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(trx));
            trx.commit();
        }, trx -> this.log.warn("unable to commit inactive transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(trx)));
        return this;
    }

    public RootUnitOfWork setRollbackOnly() {
        this.rollbackOnly = true;
        return this;
    }

    public RootUnitOfWork setReadOnly() {
        if (this.rollbackOnly) {
            return this;
        }
        this.log.debug("read-only session: {}", (Object)this.oid(this.session));
        this.setConnectionReadOnly(true);
        this.readOnly = true;
        this.session.setHibernateFlushMode(FlushMode.MANUAL);
        this.session.setDefaultReadOnly(true);
        return this;
    }

    public UnitOfWork rollback() {
        this.active(this.session, trx -> {
            this.log.debug("rollback transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(trx));
            trx.rollback();
        }, trx -> this.log.warn("unable to rollback inactive transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(trx)));
        return this;
    }

    @Override
    public <T> T apply(Throwing.Function<Session, T> callback) throws Throwable {
        try {
            Object value;
            this.begin();
            Object object = value = callback.apply((Object)this.session);
            return (T)object;
        }
        catch (Throwable x) {
            this.rollbackOnly = true;
            throw x;
        }
        finally {
            this.end();
        }
    }

    public void end() {
        try {
            if (this.rollbackOnly) {
                this.rollback();
            } else {
                this.commit();
            }
        }
        finally {
            if (this.readOnly) {
                this.setConnectionReadOnly(false);
            }
            String sessionId = this.oid(this.session);
            this.log.debug("closing session: {}", (Object)sessionId);
            Try.run(() -> this.session.close()).onFailure(x -> this.log.error("session.close() resulted in exception: {}", (Object)sessionId, x)).onSuccess(() -> this.log.debug("session closed: {}", (Object)sessionId));
            this.unbind(this.session.getSessionFactory());
        }
    }

    protected void bind(Session session) {
        this.log.debug("session bound: {}", (Object)this.oid(session));
        ManagedSessionContext.bind((Session)session);
    }

    protected void unbind(SessionFactory sessionFactory) {
        Session s = ManagedSessionContext.unbind((SessionFactory)sessionFactory);
        this.log.debug("session unbound: {}", (Object)this.oid(s));
    }

    private void setConnectionReadOnly(boolean readonly) {
        try {
            Connection connection = ((SessionImplementor)this.session).connection();
            connection.setReadOnly(readonly);
        }
        catch (Exception ex) {
            this.log.trace("session connection.setReadOnly({}) failed: {}", new Object[]{readonly, this.oid(this.session), ex});
        }
    }
}

