/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.jooby.internal.ConnectionResetByPeer;
import org.jooby.internal.netty.NettyRequest;
import org.jooby.internal.netty.NettyResponse;
import org.jooby.internal.netty.NettyWebSocket;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHandler
extends SimpleChannelInboundHandler<Object> {
    private static AsciiString STREAM_ID = HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final AttributeKey<String> PATH = AttributeKey.newInstance((String)NettyHandler.class.getName());
    private HttpHandler handler;
    private String tmpdir;
    private int wsMaxMessageSize;
    private int bufferSize;

    public NettyHandler(HttpHandler handler, String tmpdir, int bufferSize, int wsBufferSize) {
        this.handler = handler;
        this.tmpdir = tmpdir;
        this.bufferSize = bufferSize;
        this.wsMaxMessageSize = wsBufferSize;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            ctx.channel().attr(NettyRequest.NEED_FLUSH).set((Object)true);
            HttpRequest req = (HttpRequest)msg;
            ctx.channel().attr(PATH).set((Object)(req.method().name() + " " + req.uri()));
            if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
            try {
                String streamId = req.headers().get((CharSequence)STREAM_ID);
                this.handler.handle((NativeRequest)new NettyRequest(ctx, req, this.tmpdir, this.wsMaxMessageSize), (NativeResponse)new NettyResponse(ctx, this.bufferSize, keepAlive, streamId));
            }
            catch (Throwable ex) {
                this.exceptionCaught(ctx, ex);
            }
        } else if (msg instanceof WebSocketFrame) {
            Attribute ws = ctx.channel().attr(NettyWebSocket.KEY);
            ((NettyWebSocket)ws.get()).handle(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        boolean needFlush;
        Attribute attr = ctx.channel().attr(NettyRequest.NEED_FLUSH);
        boolean bl = needFlush = attr == null || attr.get() == Boolean.TRUE;
        if (needFlush) {
            ctx.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            if (ConnectionResetByPeer.test((Throwable)cause)) {
                this.log.trace("execution of: " + (String)ctx.channel().attr(PATH).get() + " resulted in error", cause);
            } else {
                Attribute ws = ctx.channel().attr(NettyWebSocket.KEY);
                if (ws != null && ws.get() != null) {
                    ((NettyWebSocket)ws.get()).handle(cause);
                } else {
                    this.log.debug("execution of: " + (String)ctx.channel().attr(PATH).get() + " resulted in error", cause);
                }
            }
        }
        finally {
            ctx.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.log.debug("idle timeout: {}", (Object)ctx);
            ctx.close();
        } else if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            FullHttpRequest req = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            req.headers().set((CharSequence)STREAM_ID, (Object)req.headers().get((CharSequence)STREAM_ID, "1"));
            this.channelRead0(ctx, req);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

