/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import com.typesafe.config.Config;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jooby.internal.netty.NettyHandler;
import org.jooby.spi.HttpHandler;

public class NettyPipeline
extends ChannelInitializer<SocketChannel> {
    private EventExecutorGroup executor;
    private HttpHandler handler;
    private Config config;
    private int maxInitialLineLength;
    private int maxHeaderSize;
    private int maxChunkSize;
    int maxContentLength;
    private long idleTimeOut;
    private SslContext sslCtx;
    private boolean supportH2;
    private String tmpdir;
    private int bufferSize;
    private int wsMaxMessageSize;

    public NettyPipeline(EventExecutorGroup executor, HttpHandler handler, Config conf, SslContext sslCtx) {
        this.executor = executor;
        this.handler = handler;
        this.config = conf;
        this.maxInitialLineLength = conf.getBytes("netty.http.MaxInitialLineLength").intValue();
        this.maxHeaderSize = conf.getBytes("netty.http.MaxHeaderSize").intValue();
        this.maxChunkSize = conf.getBytes("netty.http.MaxChunkSize").intValue();
        this.maxContentLength = conf.getBytes("netty.http.MaxContentLength").intValue();
        this.idleTimeOut = conf.getDuration("netty.http.IdleTimeout", TimeUnit.MILLISECONDS);
        this.supportH2 = conf.getBoolean("server.http2.enabled");
        this.tmpdir = this.config.getString("application.tmpdir");
        this.bufferSize = this.config.getBytes("server.http.ResponseBufferSize").intValue();
        this.wsMaxMessageSize = Math.max(this.config.getBytes("server.ws.MaxTextMessageSize").intValue(), this.config.getBytes("server.ws.MaxBinaryMessageSize").intValue());
        this.sslCtx = sslCtx;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
            p.addLast("h1.1/h2", (ChannelHandler)new Http2OrHttpHandler());
        } else if (this.supportH2) {
            p.addLast("h2c", (ChannelHandler)new Http2PrefaceOrHttpHandler());
            this.idle(p);
            this.aggregator(p);
            this.jooby(p);
        } else {
            this.http1(p);
        }
    }

    private void idle(ChannelPipeline p) {
        if (this.idleTimeOut > 0L) {
            p.addLast("timeout", (ChannelHandler)new IdleStateHandler(0L, 0L, this.idleTimeOut, TimeUnit.MILLISECONDS));
        }
    }

    private HttpServerCodec http1Codec() {
        return new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize, false);
    }

    private void http2(ChannelPipeline p) {
        p.addLast("h2", (ChannelHandler)this.newHttp2ConnectionHandler(p));
        this.idle(p);
        this.jooby(p);
    }

    private void http1(ChannelPipeline p) {
        p.addLast("codec", (ChannelHandler)this.http1Codec());
        this.idle(p);
        this.aggregator(p);
        this.jooby(p);
    }

    private void aggregator(ChannelPipeline p) {
        p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
    }

    private void jooby(ChannelPipeline p) {
        p.addLast(this.executor, "jooby", (ChannelHandler)new NettyHandler(this.handler, this.tmpdir, this.bufferSize, this.wsMaxMessageSize));
    }

    private Http2ConnectionHandler newHttp2ConnectionHandler(ChannelPipeline p) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        InboundHttp2ToHttpAdapter listener = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(false).validateHttpHeaders(false).maxContentLength(this.maxContentLength).build();
        HttpToHttp2ConnectionHandler http2handler = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)listener).frameLogger(new Http2FrameLogger(LogLevel.DEBUG)).connection((Http2Connection)connection).build();
        return http2handler;
    }

    class Http2PrefaceOrHttpHandler
    extends ByteToMessageDecoder {
        private static final int PRI = 1347569952;
        private String name;

        Http2PrefaceOrHttpHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            this.name = ctx.name();
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 4) {
                return;
            }
            if (in.getInt(in.readerIndex()) == 1347569952) {
                this.h2c(ctx);
            } else {
                this.h2cOrHttp1(ctx);
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private void h2cOrHttp1(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            HttpServerCodec http1codec = NettyPipeline.this.http1Codec();
            String baseName = this.name;
            baseName = this.addAfter(p, baseName, "codec", (ChannelHandler)http1codec);
            baseName = this.addAfter(p, baseName, "h2upgrade", (ChannelHandler)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)http1codec, protocol -> {
                if (!AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return null;
                }
                return new Http2ServerUpgradeCodec(NettyPipeline.this.newHttp2ConnectionHandler(p));
            }, NettyPipeline.this.maxContentLength));
        }

        private void h2c(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            this.addAfter(p, this.name, "h2", (ChannelHandler)NettyPipeline.this.newHttp2ConnectionHandler(p));
        }

        private String addAfter(ChannelPipeline p, String baseName, String name, ChannelHandler h) {
            p.addAfter(baseName, name, h);
            return p.context(h).name();
        }
    }

    class Http2OrHttpHandler
    extends ApplicationProtocolNegotiationHandler {
        public Http2OrHttpHandler() {
            super("http/1.1");
        }

        public void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
            if (NettyPipeline.this.supportH2 && "h2".equals(protocol)) {
                NettyPipeline.this.http2(ctx.pipeline());
            } else if ("http/1.1".equals(protocol)) {
                NettyPipeline.this.http1(ctx.pipeline());
            } else {
                throw new IllegalStateException("Unknown protocol: " + protocol);
            }
        }
    }
}

