/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.util.AsciiString;
import java.util.Map;
import org.jooby.spi.NativePushPromise;

public class NettyPush
implements NativePushPromise {
    private ChannelHandlerContext ctx;
    private Http2ConnectionEncoder encoder;
    private int streamId;
    private String authority;
    private String scheme;

    public NettyPush(ChannelHandlerContext ctx, int streamId, String authority, String scheme) {
        this.ctx = ctx;
        HttpToHttp2ConnectionHandler handler = (HttpToHttp2ConnectionHandler)ctx.pipeline().get(HttpToHttp2ConnectionHandler.class);
        this.encoder = handler.encoder();
        this.streamId = streamId;
        this.authority = authority;
        this.scheme = scheme;
    }

    public void push(String method, String path, Map<String, Object> headers) {
        this.ctx.channel().eventLoop().execute(() -> {
            AsciiString streamIdHeader = HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text();
            Http2Connection connection = this.encoder.connection();
            int nextStreamId = connection.local().incrementAndGetNextStreamId();
            Http2Headers h2headers = new DefaultHttp2Headers().path((CharSequence)path).method((CharSequence)method).authority((CharSequence)this.authority).scheme((CharSequence)this.scheme);
            headers.forEach((n, v) -> {
                Http2Headers cfr_ignored_0 = (Http2Headers)h2headers.add(n, (Object)v.toString());
            });
            this.encoder.writePushPromise(this.ctx, this.streamId, nextStreamId, h2headers, 0, this.ctx.newPromise());
            DefaultFullHttpRequest pushRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method.toUpperCase()), path, Unpooled.EMPTY_BUFFER, new DefaultHttpHeaders(false).set((CharSequence)streamIdHeader, (Object)nextStreamId), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            this.ctx.pipeline().fireChannelRead((Object)pushRequest);
            this.ctx.pipeline().fireChannelReadComplete();
        });
    }
}

