/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooby.Cookie;
import org.jooby.MediaType;
import org.jooby.Sse;
import org.jooby.internal.netty.NettyPush;
import org.jooby.internal.netty.NettySse;
import org.jooby.internal.netty.NettyUpload;
import org.jooby.internal.netty.NettyWebSocket;
import org.jooby.spi.NativePushPromise;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeUpload;
import org.jooby.spi.NativeWebSocket;

public class NettyRequest
implements NativeRequest {
    public static final AttributeKey<String> PROTOCOL = AttributeKey.newInstance((String)(NettyRequest.class.getName() + ".protol"));
    public static final AttributeKey<Boolean> NEED_FLUSH = AttributeKey.newInstance((String)(NettyRequest.class.getName() + ".needFlush"));
    public static final AttributeKey<Boolean> ASYNC = AttributeKey.newInstance((String)(NettyRequest.class.getName() + ".async"));
    public static final AttributeKey<Boolean> SECURE = AttributeKey.newInstance((String)(NettyRequest.class.getName() + ".secure"));
    private HttpRequest req;
    private QueryStringDecoder query;
    private List<Cookie> cookies;
    private Multimap<String, String> params;
    private Multimap<String, NativeUpload> files;
    private String tmpdir;
    private String path;
    private ChannelHandlerContext ctx;
    private int wsMaxMessageSize;

    public NettyRequest(ChannelHandlerContext ctx, HttpRequest req, String tmpdir, int wsMaxMessageSize) throws IOException {
        this.ctx = ctx;
        this.req = req;
        this.tmpdir = tmpdir;
        this.query = new QueryStringDecoder(req.uri());
        this.path = URLDecoder.decode(this.query.path(), "UTF-8");
        this.wsMaxMessageSize = wsMaxMessageSize;
        Channel channel = ctx.channel();
        channel.attr(ASYNC).set((Object)false);
    }

    public Optional<String> queryString() {
        String uri = this.req.uri();
        int at = uri.indexOf(63) + 1;
        return at > 0 && at < uri.length() ? Optional.of(uri.substring(at)) : Optional.empty();
    }

    public String method() {
        return this.req.method().name();
    }

    public String rawPath() {
        String uri = this.req.uri();
        int at = uri.indexOf(63);
        return at > 0 ? uri.substring(0, at) : uri;
    }

    public String path() {
        return this.path;
    }

    public List<String> paramNames() throws IOException {
        return ImmutableList.copyOf((Collection)this.decodeParams().keySet());
    }

    public List<String> params(String name) throws Exception {
        return (List)this.decodeParams().get((Object)name);
    }

    public List<String> headers(String name) {
        return this.req.headers().getAll(name);
    }

    public Optional<String> header(String name) {
        String value = this.req.headers().get(name);
        return Optional.ofNullable(value);
    }

    public List<String> headerNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.req.headers().names().forEach(it -> builder.add((Object)it.toString()));
        return builder.build();
    }

    public List<Cookie> cookies() {
        if (this.cookies == null) {
            String cookieString = this.req.headers().get((CharSequence)HttpHeaderNames.COOKIE);
            this.cookies = cookieString != null ? ServerCookieDecoder.STRICT.decode(cookieString).stream().map(this::cookie).collect(Collectors.toList()) : Collections.emptyList();
        }
        return this.cookies;
    }

    public List<NativeUpload> files(String name) throws IOException {
        this.decodeParams();
        return ImmutableList.copyOf((Collection)this.files.get((Object)name));
    }

    public InputStream in() throws IOException {
        ByteBuf content = ((HttpContent)this.req).content();
        return new ByteBufInputStream(content);
    }

    public String ip() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.ctx.channel().remoteAddress();
        return remoteAddress.getAddress().getHostAddress();
    }

    public String protocol() {
        return this.ctx.pipeline().get("h2") == null ? this.req.protocolVersion().text() : "HTTP/2.0";
    }

    public boolean secure() {
        return this.ifSecure(Boolean.TRUE, Boolean.FALSE);
    }

    public <T> T upgrade(Class<T> type) throws Exception {
        if (type == NativeWebSocket.class) {
            String protocol = this.ifSecure("wss", "ws");
            String webSocketURL = protocol + "://" + this.req.headers().get((CharSequence)HttpHeaderNames.HOST) + this.path;
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(webSocketURL, null, true, this.wsMaxMessageSize);
            WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.req);
            NettyWebSocket result = new NettyWebSocket(this.ctx, handshaker, ws -> handshaker.handshake(this.ctx.channel(), (FullHttpRequest)this.req).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE).addListener(payload -> ws.connect()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE));
            this.ctx.channel().attr(NettyWebSocket.KEY).set((Object)result);
            return (T)result;
        }
        if (type == Sse.class) {
            NettySse sse = new NettySse(this.ctx);
            return (T)((Object)sse);
        }
        if (type == NativePushPromise.class) {
            return (T)new NettyPush(this.ctx, this.req.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()), this.header("host").orElse(this.ip()), this.ifSecure("https", "http"));
        }
        throw new UnsupportedOperationException("Not Supported: " + type);
    }

    public void startAsync(Executor executor, Runnable runnable) {
        Channel channel = this.ctx.channel();
        channel.attr(NEED_FLUSH).set((Object)false);
        channel.attr(ASYNC).set((Object)true);
        ByteBuf body = ((ByteBufHolder)this.req).content();
        body.retain();
        executor.execute(() -> NettyRequest.lambda$startAsync$3(runnable, (ReferenceCounted)body));
    }

    private Cookie cookie(io.netty.handler.codec.http.cookie.Cookie c) {
        Cookie.Definition cookie = new Cookie.Definition(c.name(), c.value());
        Optional.ofNullable(c.domain()).ifPresent(arg_0 -> ((Cookie.Definition)cookie).domain(arg_0));
        Optional.ofNullable(c.path()).ifPresent(arg_0 -> ((Cookie.Definition)cookie).path(arg_0));
        return cookie.toCookie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Multimap<String, String> decodeParams() throws IOException {
        if (this.params == null) {
            this.params = ArrayListMultimap.create();
            this.files = ArrayListMultimap.create();
            this.query.parameters().forEach((name, values) -> values.forEach(value -> this.params.put(name, value)));
            HttpMethod method = this.req.method();
            boolean hasBody = method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.PATCH);
            boolean formLike = false;
            if (this.req.headers().contains("Content-Type")) {
                String contentType = this.req.headers().get("Content-Type").toLowerCase();
                boolean bl = formLike = contentType.startsWith(MediaType.multipart.name()) || contentType.startsWith(MediaType.form.name());
            }
            if (hasBody && formLike) {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(), this.req);
                try {
                    Function<HttpPostRequestDecoder, Boolean> hasNext = it -> {
                        try {
                            return it.hasNext();
                        }
                        catch (HttpPostRequestDecoder.EndOfDataDecoderException ex) {
                            return false;
                        }
                    };
                    while (hasNext.apply(decoder).booleanValue()) {
                        HttpData field = (HttpData)decoder.next();
                        try {
                            String name2 = field.getName();
                            if (field.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                                this.files.put((Object)name2, (Object)new NettyUpload((FileUpload)field, this.tmpdir));
                                continue;
                            }
                            this.params.put((Object)name2, (Object)field.getString());
                        }
                        finally {
                            field.release();
                        }
                    }
                }
                finally {
                    decoder.destroy();
                }
            }
        }
        return this.params;
    }

    private <T> T ifSecure(T then, T otherwise) {
        return this.ctx.pipeline().get("ssl") != null ? then : otherwise;
    }

    private static /* synthetic */ void lambda$startAsync$3(Runnable runnable, ReferenceCounted body) {
        try {
            runnable.run();
        }
        finally {
            body.release();
        }
    }
}

