/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.Attribute;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jooby.internal.netty.NettyRequest;
import org.jooby.internal.netty.NettyWebSocket;
import org.jooby.spi.NativeResponse;

public class NettyResponse
implements NativeResponse {
    private ChannelHandlerContext ctx;
    private boolean keepAlive;
    private HttpResponseStatus status;
    private HttpHeaders headers;
    private boolean committed;
    private int bufferSize;

    public NettyResponse(ChannelHandlerContext ctx, int bufferSize, boolean keepAlive) {
        this(ctx, bufferSize, keepAlive, null);
    }

    public NettyResponse(ChannelHandlerContext ctx, int bufferSize, boolean keepAlive, String streamId) {
        this.ctx = ctx;
        this.bufferSize = bufferSize;
        this.keepAlive = keepAlive;
        this.headers = new DefaultHttpHeaders();
        if (streamId != null) {
            this.headers.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        this.status = HttpResponseStatus.OK;
    }

    public List<String> headers(String name) {
        List headers = this.headers.getAll(name);
        return headers == null ? Collections.emptyList() : ImmutableList.copyOf((Collection)headers);
    }

    public Optional<String> header(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public void header(String name, String value) {
        this.headers.set(name, (Object)value);
    }

    public void header(String name, Iterable<String> values) {
        this.headers.remove(name).add(name, values);
    }

    public void send(byte[] bytes) throws Exception {
        this.send(Unpooled.wrappedBuffer((byte[])bytes));
    }

    public void send(ByteBuffer buffer) throws Exception {
        this.send(Unpooled.wrappedBuffer((ByteBuffer)buffer));
    }

    public void send(InputStream stream) throws Exception {
        byte[] chunk = new byte[this.bufferSize];
        int count = ByteStreams.read((InputStream)stream, (byte[])chunk, (int)0, (int)this.bufferSize);
        if (count <= 0) {
            return;
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])chunk, (int)0, (int)count);
        if (count < this.bufferSize) {
            this.send(buffer);
        } else {
            ChannelPromise promise;
            boolean keepAlive;
            DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status);
            boolean lenSet = this.headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (!lenSet) {
                this.headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                keepAlive = false;
                promise = this.ctx.newPromise();
            } else if (this.keepAlive) {
                this.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                keepAlive = this.keepAlive;
                promise = this.ctx.voidPromise();
            } else {
                keepAlive = false;
                promise = this.ctx.newPromise();
            }
            rsp.headers().set(this.headers);
            ChannelHandlerContext ctx = this.ctx;
            ctx.channel().attr(NettyRequest.NEED_FLUSH).set((Object)false);
            this.chunkHandler(ctx.pipeline());
            ctx.channel().eventLoop().execute(() -> {
                ctx.write((Object)rsp);
                ctx.write((Object)buffer);
                ctx.write((Object)new ChunkedStream(stream, this.bufferSize));
                ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise);
                if (!keepAlive) {
                    future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            });
        }
        this.committed = true;
    }

    public void send(FileChannel channel) throws Exception {
        this.send(channel, 0L, channel.size());
    }

    public void send(FileChannel channel, long offset, long count) throws Exception {
        boolean ssl;
        DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status);
        this.headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        this.headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)count);
        if (this.keepAlive) {
            this.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        rsp.headers().set(this.headers);
        ChannelHandlerContext ctx = this.ctx;
        ctx.channel().attr(NettyRequest.NEED_FLUSH).set((Object)false);
        ChannelPipeline pipeline = ctx.pipeline();
        boolean bl = ssl = pipeline.get(SslHandler.class) != null;
        if (ssl) {
            this.chunkHandler(pipeline);
            HttpChunkedInput chunkedInput = new HttpChunkedInput((ChunkedInput)new ChunkedNioFile(channel, offset, count, this.bufferSize));
            ctx.channel().eventLoop().execute(() -> {
                ctx.write((Object)rsp, ctx.voidPromise());
                if (this.keepAlive) {
                    ctx.writeAndFlush((Object)chunkedInput, ctx.voidPromise());
                } else {
                    ctx.writeAndFlush((Object)chunkedInput).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            });
        } else {
            ctx.channel().eventLoop().execute(() -> {
                ctx.write((Object)rsp, ctx.voidPromise());
                ctx.write((Object)new DefaultFileRegion(channel, offset, count), ctx.voidPromise());
                if (this.keepAlive) {
                    ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, ctx.voidPromise());
                } else {
                    ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            });
        }
        this.committed = true;
    }

    private void send(ByteBuf buffer) throws Exception {
        ChannelPromise promise;
        DefaultFullHttpResponse rsp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.status, buffer);
        this.headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buffer.readableBytes());
        if (this.keepAlive) {
            promise = this.ctx.voidPromise();
            this.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            promise = this.ctx.newPromise();
        }
        rsp.headers().set(this.headers);
        Attribute async = this.ctx.channel().attr(NettyRequest.ASYNC);
        boolean flush = async != null && async.get() == Boolean.TRUE;
        ChannelFuture future = flush ? this.ctx.writeAndFlush((Object)rsp, promise) : this.ctx.write((Object)rsp, promise);
        if (!this.keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.committed = true;
    }

    public int statusCode() {
        return this.status.code();
    }

    public void statusCode(int code) {
        this.status = HttpResponseStatus.valueOf((int)code);
    }

    public boolean committed() {
        return this.committed;
    }

    public void end() {
        if (this.ctx != null) {
            Attribute ws = this.ctx.channel().attr(NettyWebSocket.KEY);
            if (ws != null && ws.get() != null) {
                this.status = HttpResponseStatus.SWITCHING_PROTOCOLS;
                ((NettyWebSocket)ws.get()).hankshake();
                this.ctx = null;
                this.committed = true;
                return;
            }
            if (!this.committed) {
                DefaultFullHttpResponse rsp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.status);
                this.headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                rsp.headers().set(this.headers);
                if (this.keepAlive) {
                    this.ctx.write((Object)rsp, this.ctx.voidPromise());
                } else {
                    this.ctx.write((Object)rsp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                this.committed = true;
            }
            this.ctx = null;
        }
    }

    public void reset() {
        this.headers.clear();
        this.status = HttpResponseStatus.OK;
    }

    private void chunkHandler(ChannelPipeline pipeline) {
        if (pipeline.get("chunker") == null) {
            pipeline.addAfter("codec", "chunker", (ChannelHandler)new ChunkedWriteHandler());
        }
    }
}

