/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javaslang.API;
import javaslang.Predicates;
import javax.inject.Inject;
import org.jooby.internal.netty.NettyPipeline;
import org.jooby.internal.netty.NettySslContext;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(Server.class);
    private EventLoopGroup bossLoop;
    private EventLoopGroup workerLoop;
    private Channel ch;
    private Config conf;
    private HttpHandler dispatcher;
    private DefaultEventExecutorGroup executor;

    @Inject
    public NettyServer(HttpHandler dispatcher, Config config) {
        this.dispatcher = dispatcher;
        this.conf = config;
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
    }

    public void start() throws Exception {
        int bossThreads = this.conf.getInt("netty.threads.Boss");
        this.bossLoop = this.eventLoop(bossThreads, "boss");
        int workerThreads = this.conf.getInt("netty.threads.Worker");
        this.workerLoop = workerThreads > 0 ? this.eventLoop(workerThreads, "worker") : this.bossLoop;
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(this.conf.getString("netty.threads.Name"));
        this.executor = new DefaultEventExecutorGroup(this.conf.getInt("netty.threads.Max"), (ThreadFactory)threadFactory);
        this.ch = this.bootstrap((EventExecutorGroup)this.executor, null, this.conf.getInt("application.port"));
        boolean securePort = this.conf.hasPath("application.securePort");
        if (securePort) {
            this.bootstrap((EventExecutorGroup)this.executor, NettySslContext.build(this.conf), this.conf.getInt("application.securePort"));
        }
    }

    private Channel bootstrap(EventExecutorGroup executor, SslContext sslCtx, int port) throws InterruptedException {
        ServerBootstrap bootstrap = new ServerBootstrap();
        boolean epoll = this.bossLoop instanceof EpollEventLoopGroup;
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossLoop, this.workerLoop).channel(epoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(Server.class, LogLevel.DEBUG))).childHandler((ChannelHandler)new NettyPipeline(executor, this.dispatcher, this.conf, sslCtx));
        this.configure(this.conf.getConfig("netty.options"), "netty.options", (option, value) -> {
            ServerBootstrap cfr_ignored_0 = (ServerBootstrap)bootstrap.option(option, value);
        });
        this.configure(this.conf.getConfig("netty.worker.options"), "netty.worker.options", (option, value) -> bootstrap.childOption(option, value));
        return bootstrap.bind(this.host(this.conf.getString("application.host")), port).sync().channel();
    }

    private String host(String host) {
        return "localhost".equals(host) ? "0.0.0.0" : host;
    }

    public void stop() throws Exception {
        this.shutdownGracefully((Iterator<EventExecutorGroup>)ImmutableList.of((Object)this.bossLoop, (Object)this.workerLoop, (Object)this.executor).iterator());
    }

    public void join() throws InterruptedException {
        this.ch.closeFuture().sync();
    }

    public Optional<Executor> executor() {
        return Optional.ofNullable(this.executor);
    }

    private void configure(Config config, String path, BiConsumer<ChannelOption<Object>, Object> setter) {
        config.entrySet().forEach(entry -> {
            Map.Entry<ChannelOption, Class<?>> result = this.findOption((String)entry.getKey());
            if (result != null) {
                ChannelOption option = result.getKey();
                String optionName = (String)entry.getKey();
                Class<?> optionType = result.getValue();
                Object value = API.Match(optionType).of(new API.Match.Case[]{API.Case((Predicate)Predicates.is(Boolean.class), () -> config.getBoolean(optionName)), API.Case((Predicate)Predicates.is(Integer.class), () -> config.getInt(optionName)), API.Case((Predicate)Predicates.is(Long.class), () -> config.getLong(optionName))});
                this.log.debug("{}.{}({})", new Object[]{path, option, value});
                setter.accept(option, value);
            } else {
                this.log.error("Unknown option: {}.{}", (Object)path, entry.getKey());
            }
        });
    }

    private Map.Entry<ChannelOption, Class<?>> findOption(String optionName) {
        try {
            Field field = EpollChannelOption.class.getField(optionName);
            ChannelOption option = (ChannelOption)field.get(null);
            Class optionType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            return Maps.immutableEntry((Object)option, (Object)optionType);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            return null;
        }
    }

    private EventLoopGroup eventLoop(int threads, String name) {
        this.log.debug("netty.threads.{}({})", (Object)name, (Object)threads);
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory("epoll-" + name, false));
        }
        return new NioEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory("nio-" + name, false));
    }

    private void shutdownGracefully(Iterator<EventExecutorGroup> iterator) {
        EventExecutorGroup group;
        if (iterator.hasNext() && !(group = iterator.next()).isShuttingDown()) {
            group.shutdownGracefully().addListener(future -> {
                if (!future.isSuccess()) {
                    this.log.debug("shutdown of {} resulted in exception", (Object)group, (Object)future.cause());
                }
                this.shutdownGracefully(iterator);
            });
        }
    }
}

