/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.cert.CertificateException;
import java.util.Arrays;
import org.jooby.internal.netty.NettyServer;

public class NettySslContext {
    static SslContext build(Config conf) throws IOException, CertificateException {
        String tmpdir = conf.getString("application.tmpdir");
        boolean http2 = conf.getBoolean("server.http2.enabled");
        File keyStoreCert = NettySslContext.toFile(conf.getString("ssl.keystore.cert"), tmpdir);
        File keyStoreKey = NettySslContext.toFile(conf.getString("ssl.keystore.key"), tmpdir);
        String keyStorePass = conf.hasPath("ssl.keystore.password") ? conf.getString("ssl.keystore.password") : null;
        SslContextBuilder scb = SslContextBuilder.forServer((File)keyStoreCert, (File)keyStoreKey, (String)keyStorePass);
        if (conf.hasPath("ssl.trust.cert")) {
            scb.trustManager(NettySslContext.toFile(conf.getString("ssl.trust.cert"), tmpdir));
        }
        if (http2) {
            SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
            return scb.sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, Arrays.asList("h2", "http/1.1"))).build();
        }
        return scb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File toFile(String path, String tmpdir) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        file = new File(tmpdir, Paths.get(path, new String[0]).getFileName().toString());
        InputStream in = NettyServer.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new FileNotFoundException(path);
        }
        try {
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            file.deleteOnExit();
            File file2 = file;
            return file2;
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
    }
}

