/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jooby.spi.NativeUpload;

public class NettyUpload
implements NativeUpload {
    private File file;
    private FileUpload data;

    public NettyUpload(FileUpload data, String tmpdir) throws IOException {
        this.data = data;
        String name = "tmp-" + Long.toHexString(System.currentTimeMillis()) + "." + this.name();
        this.file = new File(tmpdir, name);
        data.renameTo(this.file);
    }

    public void close() throws IOException {
        this.file().delete();
        this.data.delete();
    }

    public String name() {
        return this.data.getFilename();
    }

    private Optional<String> header(String name) {
        if (name.equalsIgnoreCase("content-transfer-encoding")) {
            return Optional.of(this.data.getContentTransferEncoding());
        }
        if (name.equalsIgnoreCase("content-disposition")) {
            return Optional.of("form-data; name=\"" + this.data.getName() + "\"; filename=\"" + this.data.getFilename() + "\"");
        }
        if (name.equalsIgnoreCase("content-type")) {
            String cs = Optional.ofNullable(this.data.getCharset()).map(it -> "; charset=" + it.name()).orElse("");
            return Optional.ofNullable(this.data.getContentType()).flatMap(it -> Optional.of(it + cs));
        }
        return Optional.empty();
    }

    public List<String> headers(String name) {
        return this.header(name).map(ImmutableList::of).orElse(Collections.emptyList());
    }

    public File file() throws IOException {
        return this.file;
    }
}

