/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jooby.WebSocket;
import org.jooby.spi.NativeWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements NativeWebSocket {
    public static final AttributeKey<NettyWebSocket> KEY = AttributeKey.newInstance((String)NettyWebSocket.class.getName());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ChannelHandlerContext ctx;
    private Consumer<NettyWebSocket> handshake;
    private Runnable onConnectCallback;
    private WebSocketServerHandshaker handshaker;
    private Consumer<String> onTextCallback;
    private Consumer<ByteBuffer> onBinaryCallback;
    private BiConsumer<Integer, Optional<String>> onCloseCallback;
    private Consumer<Throwable> onErrorCallback;
    private final CountDownLatch ready = new CountDownLatch(1);

    public NettyWebSocket(ChannelHandlerContext ctx, WebSocketServerHandshaker handshaker, Consumer<NettyWebSocket> handshake) {
        this.ctx = ctx;
        this.handshaker = handshaker;
        this.handshake = handshake;
    }

    public void close(int status, String reason) {
        this.handshaker.close(this.ctx.channel(), new CloseWebSocketFrame(status, reason)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        Attribute ws = this.ctx.channel().attr(KEY);
        if (ws != null) {
            ws.set(null);
        }
    }

    public void resume() {
        ChannelConfig config = this.ctx.channel().config();
        if (!config.isAutoRead()) {
            config.setAutoRead(true);
        }
    }

    public void onConnect(Runnable callback) {
        this.onConnectCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    public void onTextMessage(Consumer<String> callback) {
        this.onTextCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    public void onBinaryMessage(Consumer<ByteBuffer> callback) {
        this.onBinaryCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    public void onCloseMessage(BiConsumer<Integer, Optional<String>> callback) {
        this.onCloseCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    public void onErrorMessage(Consumer<Throwable> callback) {
        this.onErrorCallback = Objects.requireNonNull(callback, "A callback is required.");
    }

    public void pause() {
        ChannelConfig config = this.ctx.channel().config();
        if (config.isAutoRead()) {
            config.setAutoRead(false);
        }
    }

    public void terminate() throws IOException {
        this.onCloseCallback.accept(1006, Optional.of("Harsh disconnect"));
        this.ctx.disconnect().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendBytes(ByteBuffer data, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        this.sendBytes(Unpooled.wrappedBuffer((ByteBuffer)data), success, err);
    }

    public void sendBytes(byte[] data, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        this.sendBytes(Unpooled.wrappedBuffer((byte[])data), success, err);
    }

    public void sendText(String data, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        this.ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(data)).addListener(this.listener(success, err));
    }

    public void sendText(ByteBuffer data, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuffer)data);
        this.ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(buffer)).addListener(this.listener(success, err));
    }

    public void sendText(byte[] data, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])data);
        this.ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(buffer)).addListener(this.listener(success, err));
    }

    public boolean isOpen() {
        return this.ctx.channel().isOpen();
    }

    public void connect() {
        this.onConnectCallback.run();
        this.ready.countDown();
    }

    public void hankshake() {
        this.handshake.accept(this);
    }

    public void handle(Object msg) {
        this.ready();
        if (msg instanceof TextWebSocketFrame) {
            this.onTextCallback.accept(((TextWebSocketFrame)msg).text());
        } else if (msg instanceof BinaryWebSocketFrame) {
            this.onBinaryCallback.accept(((BinaryWebSocketFrame)msg).content().nioBuffer());
        } else if (msg instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = ((CloseWebSocketFrame)msg).retain();
            int statusCode = closeFrame.statusCode();
            this.onCloseCallback.accept(statusCode == -1 ? WebSocket.NORMAL.code() : statusCode, Optional.ofNullable(closeFrame.reasonText()));
            this.handshaker.close(this.ctx.channel(), closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (msg instanceof Throwable) {
            this.onErrorCallback.accept((Throwable)msg);
        }
    }

    private void ready() {
        try {
            this.ready.await();
        }
        catch (InterruptedException ex) {
            this.log.error("Connect call was inturrupted", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    private void sendBytes(ByteBuf buffer, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        this.ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(buffer)).addListener(this.listener(success, err));
    }

    private GenericFutureListener<? extends Future<? super Void>> listener(WebSocket.SuccessCallback success, WebSocket.OnError err) {
        return f -> {
            if (f.isSuccess()) {
                success.invoke();
            } else {
                err.onError(f.cause());
            }
        };
    }
}

