/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.servlet;

import com.typesafe.config.Config;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jooby.Jooby;
import org.jooby.servlet.ServletServletRequest;
import org.jooby.servlet.ServletServletResponse;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHandler
extends HttpServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpHandler dispatcher;
    private String tmpdir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext ctx = config.getServletContext();
        Jooby app = (Jooby)ctx.getAttribute(Jooby.class.getName());
        this.dispatcher = (HttpHandler)app.require(HttpHandler.class);
        this.tmpdir = ((Config)app.require(Config.class)).getString("application.tmpdir");
    }

    protected void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        try {
            this.dispatcher.handle((NativeRequest)new ServletServletRequest(req, this.tmpdir), (NativeResponse)new ServletServletResponse(req, rsp));
        }
        catch (IOException | RuntimeException | ServletException ex) {
            this.log.error("execution of: " + req.getRequestURI() + " resulted in error", ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.log.error("execution of: " + req.getRequestURI() + " resulted in error", ex);
            throw new IllegalStateException(ex);
        }
    }
}

