/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.servlet;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.jooby.Cookie;
import org.jooby.MediaType;
import org.jooby.Router;
import org.jooby.servlet.ServletUpgrade;
import org.jooby.servlet.ServletUpload;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeUpload;

public class ServletServletRequest
implements NativeRequest {
    private final HttpServletRequest req;
    private final String tmpdir;
    private final boolean multipart;
    private final String path;
    private ServletUpgrade upgrade = ServletServletRequest.noupgrade();

    public ServletServletRequest(HttpServletRequest req, String tmpdir, boolean multipart) throws IOException {
        this.req = Objects.requireNonNull(req, "HTTP req is required.");
        this.tmpdir = Objects.requireNonNull(tmpdir, "A tmpdir is required.");
        this.multipart = multipart;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        this.path = req.getContextPath() + Router.decode((String)pathInfo);
    }

    public HttpServletRequest servletRequest() {
        return this.req;
    }

    public ServletServletRequest(HttpServletRequest req, String tmpdir) throws IOException {
        this(req, tmpdir, ServletServletRequest.multipart(req));
    }

    public ServletServletRequest with(ServletUpgrade upgrade) {
        this.upgrade = Objects.requireNonNull(upgrade, "An upgrade provider is required.");
        return this;
    }

    public String method() {
        return this.req.getMethod();
    }

    public Optional<String> queryString() {
        return Optional.ofNullable(Strings.emptyToNull((String)this.req.getQueryString()));
    }

    public String path() {
        return this.path;
    }

    public String rawPath() {
        return this.req.getRequestURI();
    }

    public List<String> paramNames() {
        return this.toList(this.req.getParameterNames());
    }

    private <T> List<T> toList(Enumeration<T> enumeration) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result.build();
    }

    public List<String> params(String name) throws Exception {
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(values);
    }

    public Map<String, Object> attributes() {
        Enumeration attributeNames = this.req.getAttributeNames();
        if (!attributeNames.hasMoreElements()) {
            return Collections.emptyMap();
        }
        return Collections.list(attributeNames).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)this.req).getAttribute(arg_0)));
    }

    public List<String> headers(String name) {
        return this.toList(this.req.getHeaders(name));
    }

    public Optional<String> header(String name) {
        return Optional.ofNullable(this.req.getHeader(name));
    }

    public List<String> headerNames() {
        return this.toList(this.req.getHeaderNames());
    }

    public List<Cookie> cookies() {
        javax.servlet.http.Cookie[] cookies = this.req.getCookies();
        if (cookies == null) {
            return ImmutableList.of();
        }
        return Arrays.stream(cookies).map(c -> {
            Cookie.Definition cookie = new Cookie.Definition(c.getName(), c.getValue());
            Optional.ofNullable(c.getComment()).ifPresent(arg_0 -> ((Cookie.Definition)cookie).comment(arg_0));
            Optional.ofNullable(c.getDomain()).ifPresent(arg_0 -> ((Cookie.Definition)cookie).domain(arg_0));
            Optional.ofNullable(c.getPath()).ifPresent(arg_0 -> ((Cookie.Definition)cookie).path(arg_0));
            return cookie.toCookie();
        }).collect(Collectors.toList());
    }

    public List<NativeUpload> files(String name) throws IOException {
        try {
            if (this.multipart) {
                return this.req.getParts().stream().filter(part -> part.getSubmittedFileName() != null && part.getName().equals(name)).map(part -> new ServletUpload((Part)part, this.tmpdir)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (ServletException ex) {
            throw new IOException("File not found: " + name, ex);
        }
    }

    public List<NativeUpload> files() throws IOException {
        try {
            if (this.multipart) {
                return this.req.getParts().stream().map(part -> new ServletUpload((Part)part, this.tmpdir)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (ServletException ex) {
            throw new IOException("Unable to get files", ex);
        }
    }

    public InputStream in() throws IOException {
        return this.req.getInputStream();
    }

    public String ip() {
        return this.req.getRemoteAddr();
    }

    public String protocol() {
        return this.req.getProtocol();
    }

    public boolean secure() {
        return this.req.isSecure();
    }

    public <T> T upgrade(Class<T> type) throws Exception {
        return this.upgrade.upgrade(type);
    }

    public void startAsync(Executor executor, Runnable runnable) {
        this.req.startAsync();
        executor.execute(runnable);
    }

    private static boolean multipart(HttpServletRequest req) {
        String contentType = req.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith(MediaType.multipart.name());
    }

    private static ServletUpgrade noupgrade() {
        return new ServletUpgrade(){

            @Override
            public <T> T upgrade(Class<T> type) throws Exception {
                throw new UnsupportedOperationException("");
            }
        };
    }
}

