/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.servlet;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jooby.funzy.Try;
import org.jooby.spi.NativeResponse;

public class ServletServletResponse
implements NativeResponse {
    protected HttpServletRequest req;
    protected HttpServletResponse rsp;
    private boolean committed;

    public ServletServletResponse(HttpServletRequest req, HttpServletResponse rsp) {
        this.req = Objects.requireNonNull(req, "A request is required.");
        this.rsp = Objects.requireNonNull(rsp, "A response is required.");
    }

    public List<String> headers(String name) {
        Collection headers = this.rsp.getHeaders(name);
        if (headers == null || headers.size() == 0) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Collection)headers);
    }

    public Optional<String> header(String name) {
        String header = this.rsp.getHeader(name);
        return header == null || header.isEmpty() ? Optional.empty() : Optional.of(header);
    }

    public void header(String name, String value) {
        this.rsp.setHeader(name, value);
    }

    public void header(String name, Iterable<String> values) {
        for (String value : values) {
            this.rsp.addHeader(name, value);
        }
    }

    public void send(byte[] bytes) throws Exception {
        this.rsp.setHeader("Transfer-Encoding", null);
        ServletOutputStream output = this.rsp.getOutputStream();
        output.write(bytes);
        output.close();
        this.committed = true;
    }

    public void send(ByteBuffer buffer) throws Exception {
        Try.of((AutoCloseable)Channels.newChannel((OutputStream)this.rsp.getOutputStream())).run(channel -> channel.write(buffer)).onSuccess(() -> {
            this.committed = true;
        });
    }

    public void send(FileChannel file) throws Exception {
        this.send(file, 0L, file.size());
    }

    public void send(FileChannel channel, long position, long count) throws Exception {
        try (FileChannel src = channel;){
            WritableByteChannel dest = Channels.newChannel((OutputStream)this.rsp.getOutputStream());
            src.transferTo(position, count, dest);
            dest.close();
            this.committed = true;
        }
    }

    public void send(InputStream stream) throws Exception {
        ServletOutputStream output = this.rsp.getOutputStream();
        ByteStreams.copy((InputStream)stream, (OutputStream)output);
        output.close();
        stream.close();
        this.committed = true;
    }

    public int statusCode() {
        return this.rsp.getStatus();
    }

    public void statusCode(int statusCode) {
        this.rsp.setStatus(statusCode);
    }

    public boolean committed() {
        if (this.committed) {
            return true;
        }
        return this.rsp.isCommitted();
    }

    public void end() {
        if (!this.committed) {
            if (this.req.isAsyncStarted()) {
                AsyncContext ctx = this.req.getAsyncContext();
                ctx.complete();
            } else {
                this.close();
            }
            this.committed = true;
        }
    }

    protected void close() {
    }

    public void reset() {
        this.rsp.reset();
    }
}

