/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.google.inject.TypeLiteral;
import java.util.Objects;
import javax.json.bind.Jsonb;
import org.jooby.MediaType;
import org.jooby.Parser;

class YassonParser
implements Parser {
    private final MediaType type;
    private final Jsonb jsonb;

    public YassonParser(MediaType type, Jsonb jsonb) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
        this.jsonb = Objects.requireNonNull(jsonb, "Jsonb is required.");
    }

    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
        MediaType ctype = ctx.type();
        if (ctype.isAny()) {
            return ctx.next();
        }
        if (ctype.matches(this.type)) {
            return ctx.ifbody(body -> this.jsonb.fromJson(body.text(), type.getType())).ifparam(values -> this.jsonb.fromJson((String)values.first(), type.getType()));
        }
        return ctx.next();
    }

    public String toString() {
        return "yasson";
    }
}

