/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import java.util.ArrayList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSetContainer;
import org.jooq.codegen.gradle.CodegenPluginExtension;
import org.jooq.codegen.gradle.CodegenTask;
import org.jooq.codegen.gradle.NamedConfiguration;
import org.jooq.tools.StringUtils;

public class CodegenPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        CodegenPluginExtension jooq = (CodegenPluginExtension)project.getExtensions().create("jooq", CodegenPluginExtension.class, new Object[0]);
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        Configuration codegenClasspath = (Configuration)project.getConfigurations().create("jooqCodegen");
        SourceSetContainer source = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        project.afterEvaluate(p -> {
            boolean unnamed = true;
            ArrayList<CodegenTask> tasks = new ArrayList<CodegenTask>();
            for (NamedConfiguration configuration : ((CodegenPluginExtension)p.getExtensions().getByType(CodegenPluginExtension.class)).configurations()) {
                unnamed &= configuration.unnamed;
                CodegenTask task2 = (CodegenTask)p.getTasks().create("jooqCodegen" + (configuration.unnamed ? "" : StringUtils.toUC((String)configuration.name)), CodegenTask.class, new Object[]{configuration, runtimeClasspath, codegenClasspath});
                task2.setDescription("jOOQ code generation" + (String)(configuration.unnamed ? "" : " for " + configuration.name + " execution"));
                task2.setGroup("jOOQ");
                Task compileJava = (Task)p.getTasks().findByName("compileJava");
                if (compileJava != null) {
                    compileJava.dependsOn(new Object[]{task2});
                }
                source.configureEach(sourceSet -> {
                    if (configuration.unnamed && sourceSet.getName().equals("main") || sourceSet.getName().equals(configuration.name)) {
                        sourceSet.getJava().srcDir((Object)task2.getOutputDirectory());
                    }
                });
                tasks.add(task2);
            }
            if (!unnamed) {
                p.getTasks().create("jooqCodegen", task -> {
                    task.setDescription("jOOQ code generation for all executions");
                    task.setGroup("jOOQ");
                    task.setDependsOn((Iterable)tasks);
                });
            }
        });
    }
}

