/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.InputChanges;
import org.jooq.codegen.GenerationTool;
import org.jooq.codegen.gradle.NamedConfiguration;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Target;

@CacheableTask
public class CodegenTask
extends DefaultTask {
    private final NamedConfiguration configuration;
    private final ProviderFactory providers;
    private final List<File> classpath;
    private final Directory outputDirectory;

    @Inject
    public CodegenTask(NamedConfiguration configuration, FileCollection runtimeClasspath, FileCollection codegenClasspath, ProviderFactory providers, ProjectLayout layout) {
        this.configuration = configuration;
        this.providers = providers;
        this.classpath = new ArrayList<File>();
        this.classpath.addAll(codegenClasspath.getFiles());
        Target target = configuration.configuration.getGenerator().getTarget();
        if (configuration.configuration.getBasedir() == null) {
            configuration.configuration.setBasedir(layout.getProjectDirectory().getAsFile().getAbsolutePath());
        }
        if (target.getDirectory() == null || "target/generated-sources/jooq".equals(target.getDirectory())) {
            target.setDirectory("build/generated-sources/jooq");
        }
        this.outputDirectory = layout.getProjectDirectory().dir(target.getDirectory());
        this.getOutputs().upToDateWhen(task -> false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void execute(InputChanges changes) throws Exception {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader pluginClassLoader = this.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            GenerationTool.generate((Configuration)this.configuration.configuration);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    @Input
    public Provider<String> getInput() {
        return this.providers.provider(() -> this.configuration.configuration.toString());
    }

    @Classpath
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    @OutputDirectory
    public Directory getOutputDirectory() {
        return this.outputDirectory;
    }

    private URLClassLoader getClassLoader() {
        try {
            URL[] urls = new URL[this.classpath.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = this.classpath.get(i).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new GradleException("Couldn't create a classloader.", (Throwable)e);
        }
    }
}

