/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.jooq.codegen.gradle.CodegenPluginExtension;
import org.jooq.codegen.gradle.MetaExtensions;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Target;
import org.jooq.util.jaxb.tools.MiniJAXB;
import org.jooq.util.jaxb.tools.XMLAppendable;

public class NamedConfiguration {
    final ObjectFactory objects;
    final Project project;
    final ProjectLayout layout;
    final String name;
    boolean unnamed;
    Configuration configuration;
    Property<Directory> outputDirectory;

    @Inject
    public NamedConfiguration(ObjectFactory objects, Project project, ProjectLayout layout, String name) {
        this.objects = objects;
        this.project = project;
        this.layout = layout;
        this.name = name;
        this.unnamed = false;
        this.configuration = NamedConfiguration.newConfiguration();
        this.outputDirectory = objects.directoryProperty();
    }

    static final Configuration newConfiguration() {
        return new Configuration().withGenerator(new Generator().withTarget(new Target()));
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    void configuration0(Configuration configuration) {
        if (!this.unnamed) {
            MiniJAXB.append((Object)this.configuration, (Object)NamedConfiguration.copy(((CodegenPluginExtension)this.project.getExtensions().getByType(CodegenPluginExtension.class)).defaultConfiguration().configuration));
        }
        MiniJAXB.append((Object)this.configuration, (Object)configuration);
    }

    static Configuration copy(Configuration configuration) {
        return (Configuration)MiniJAXB.unmarshal((String)MiniJAXB.marshal((XMLAppendable)configuration), Configuration.class);
    }

    public void configuration(Action<MetaExtensions.ConfigurationExtension> action) {
        MetaExtensions.ConfigurationExtension c = (MetaExtensions.ConfigurationExtension)((Object)this.objects.newInstance(MetaExtensions.ConfigurationExtension.class, new Object[]{this.objects}));
        action.execute((Object)c);
        this.configuration0(c);
        if (this.configuration.getBasedir() == null) {
            this.configuration.setBasedir(this.layout.getProjectDirectory().getAsFile().getAbsolutePath());
        }
        Target target = this.configuration.getGenerator().getTarget();
        if (this.defaultTarget()) {
            this.configuration.getGenerator().getTarget().setDirectory("build/generated-sources/jooq");
        }
        this.outputDirectory.value((Object)this.layout.getProjectDirectory().dir(target.getDirectory()));
    }

    boolean defaultTarget() {
        Target target = this.configuration.getGenerator().getTarget();
        return target.getDirectory() == null || "target/generated-sources/jooq".equals(target.getDirectory());
    }

    public String toString() {
        return "NamedConfiguration [" + this.name + ", " + String.valueOf(this.configuration) + "]";
    }
}

