/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.InputChanges;
import org.jooq.codegen.GenerationTool;
import org.jooq.codegen.gradle.NamedConfiguration;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.tools.StringUtils;

@CacheableTask
public class CodegenTask
extends DefaultTask {
    final NamedConfiguration configuration;
    final FileCollection codegenClasspath;
    final ProviderFactory providers;
    final List<NamedConfiguration> named;

    @Inject
    public CodegenTask(NamedConfiguration configuration, FileCollection codegenClasspath, ProviderFactory providers) {
        this.configuration = configuration;
        this.providers = providers;
        this.codegenClasspath = codegenClasspath;
        this.named = new ArrayList<NamedConfiguration>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void execute(InputChanges changes) throws Exception {
        if (this.named.isEmpty()) {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            URLClassLoader pluginClassLoader = this.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassLoader);
                GenerationTool.generate((Configuration)this.configuration.configuration);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    @Input
    public Provider<String> getInput() {
        return this.providers.provider(() -> this.configuration.configuration.toString());
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.codegenClasspath;
    }

    @OutputDirectories
    public List<DirectoryProperty> getOutputDirectory() {
        if (this.named.isEmpty() && this.configuration.outputDirectorySet) {
            return Arrays.asList(this.configuration.outputDirectory);
        }
        return Arrays.asList(new DirectoryProperty[0]);
    }

    private URLClassLoader getClassLoader() {
        ArrayList classpath = new ArrayList(this.getClasspath().getFiles());
        try {
            URL[] urls = new URL[classpath.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = ((File)classpath.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new GradleException("Couldn't create a classloader.", (Throwable)e);
        }
    }

    static String taskName(NamedConfiguration configuration) {
        return "jooqCodegen" + (configuration.unnamed ? "" : StringUtils.toUC((String)configuration.name));
    }
}

