/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSetContainer;
import org.jooq.codegen.gradle.CodegenPluginExtension;
import org.jooq.codegen.gradle.CodegenTask;
import org.jooq.codegen.gradle.NamedConfiguration;

public class CodegenPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        CodegenPluginExtension jooq = (CodegenPluginExtension)project.getExtensions().create("jooq", CodegenPluginExtension.class, new Object[0]);
        Configuration codegenClasspath = (Configuration)project.getConfigurations().create("jooqCodegen");
        codegenClasspath.setDescription("The classpath used for code generation, including JDBC drivers, code generation extensions, etc.");
        jooq.getExecutions().create("", configuration -> {
            configuration.unnamed = true;
        });
        ArrayList named = new ArrayList();
        jooq.getExecutions().configureEach(configuration -> {
            if (!configuration.unnamed) {
                named.add(configuration);
            }
            project.getTasks().register(CodegenTask.taskName(configuration), CodegenTask.class, new Object[]{configuration, codegenClasspath}).configure(CodegenPlugin.configureTask(project, named, configuration));
        });
    }

    private static Action<CodegenTask> configureTask(Project project, List<NamedConfiguration> named, NamedConfiguration configuration) {
        return task -> {
            if (configuration.unnamed) {
                task.named.addAll(named);
                for (NamedConfiguration other : named) {
                    task.dependsOn(new Object[]{CodegenTask.taskName(other)});
                }
            }
            task.setDescription("jOOQ code generation" + (String)(configuration.unnamed ? " for all executions" : " for the " + configuration.name + " execution"));
            task.setGroup("jOOQ");
            task.doFirst(t -> {
                SourceSetContainer source = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
                if (source != null) {
                    source.configureEach(sourceSet -> {
                        if (sourceSet.getName().equals("main")) {
                            sourceSet.getJava().srcDir(task.getOutputDirectory());
                        }
                    });
                }
            });
        };
    }
}

