/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jooq.SQLDialect;
import org.jooq.impl.JooqLogger;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultMasterDataTableDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.Relations;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;

public abstract class AbstractDatabase
implements Database {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractDatabase.class);
    private Connection connection;
    private String schema;
    private String[] excludes;
    private String[] includes;
    private String[] masterDataTableNames;
    private Properties properties;
    private List<SequenceDefinition> sequences;
    private List<TableDefinition> tables;
    private List<MasterDataTableDefinition> masterDataTables;
    private List<EnumDefinition> enums;
    private List<UDTDefinition> udts;
    private List<ArrayDefinition> arrays;
    private List<ProcedureDefinition> procedures;
    private List<FunctionDefinition> functions;
    private List<PackageDefinition> packages;
    private Relations relations;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    @Override
    public final SQLDialect getDialect() {
        return this.create().getDialect();
    }

    @Override
    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final void setSchemaName(String schema) {
        this.schema = schema;
    }

    @Override
    public final String getSchemaName() {
        return this.schema;
    }

    @Override
    public final SchemaDefinition getSchema() {
        return new SchemaDefinition(this, this.getSchemaName(), null);
    }

    @Override
    public final void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public final String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public final void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public final String[] getIncludes() {
        return this.includes;
    }

    @Override
    public final void setMasterDataTableNames(String[] masterDataTableNames) {
        this.masterDataTableNames = masterDataTableNames;
    }

    @Override
    public final String[] getMasterDataTableNames() {
        return this.masterDataTableNames;
    }

    @Override
    public List<SequenceDefinition> getSequences() {
        if (this.sequences == null) {
            this.sequences = new ArrayList<SequenceDefinition>();
            try {
                this.sequences = this.filterExcludeInclude(this.getSequences0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching sequences", (Throwable)e);
            }
        }
        return this.sequences;
    }

    @Override
    public final List<TableDefinition> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<TableDefinition>();
            try {
                this.tables = this.filterMasterDataTables(this.filterExcludeInclude(this.getTables0()), false);
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching tables", (Throwable)e);
            }
        }
        return this.tables;
    }

    @Override
    public final TableDefinition getTable(String name) {
        for (TableDefinition tableDefinition : this.getTables()) {
            if (!tableDefinition.getName().equals(name)) continue;
            return tableDefinition;
        }
        for (MasterDataTableDefinition masterDataTableDefinition : this.getMasterDataTables()) {
            if (!masterDataTableDefinition.getName().equals(name)) continue;
            return masterDataTableDefinition;
        }
        return null;
    }

    @Override
    public final List<MasterDataTableDefinition> getMasterDataTables() {
        if (this.masterDataTables == null) {
            this.masterDataTables = new ArrayList<MasterDataTableDefinition>();
            try {
                this.masterDataTables = this.filterMasterDataTables(this.filterExcludeInclude(this.getTables0()), true);
            }
            catch (Exception e) {
                log.error((Object)"Exception while fetching master data tables", (Throwable)e);
            }
        }
        return this.masterDataTables;
    }

    @Override
    public final MasterDataTableDefinition getMasterDataTable(String name) {
        for (MasterDataTableDefinition table : this.getMasterDataTables()) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    @Override
    public final List<EnumDefinition> getEnums() {
        if (this.enums == null) {
            this.enums = new ArrayList<EnumDefinition>();
            try {
                this.enums = this.filterExcludeInclude(this.getEnums0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching enums", (Throwable)e);
            }
        }
        return this.enums;
    }

    @Override
    public final EnumDefinition getEnum(String name) {
        for (EnumDefinition e : this.getEnums()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public final List<ArrayDefinition> getArrays() {
        if (this.arrays == null) {
            this.arrays = new ArrayList<ArrayDefinition>();
            try {
                this.arrays = this.filterExcludeInclude(this.getArrays0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching ARRAYS", (Throwable)e);
            }
        }
        return this.arrays;
    }

    @Override
    public final ArrayDefinition getArray(String name) {
        for (ArrayDefinition e : this.getArrays()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public final List<UDTDefinition> getUDTs() {
        if (this.udts == null) {
            this.udts = new ArrayList<UDTDefinition>();
            try {
                this.udts = this.filterExcludeInclude(this.getUDTs0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching udts", (Throwable)e);
            }
        }
        return this.udts;
    }

    @Override
    public final UDTDefinition getUDT(String name) {
        for (UDTDefinition e : this.getUDTs()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public Relations getRelations() {
        if (this.relations == null) {
            try {
                this.relations = this.getRelations0();
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching relations", (Throwable)e);
                this.relations = new DefaultRelations(this);
            }
        }
        return this.relations;
    }

    @Override
    public final List<ProcedureDefinition> getProcedures() {
        if (this.procedures == null) {
            this.procedures = new ArrayList<ProcedureDefinition>();
            try {
                this.procedures = this.filterExcludeInclude(this.getProcedures0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching procedures", (Throwable)e);
            }
        }
        return this.procedures;
    }

    @Override
    public final List<FunctionDefinition> getFunctions() {
        if (this.functions == null) {
            this.functions = new ArrayList<FunctionDefinition>();
            try {
                this.functions = this.filterExcludeInclude(this.getFunctions0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching functions", (Throwable)e);
            }
        }
        return this.functions;
    }

    @Override
    public final List<PackageDefinition> getPackages() {
        if (this.packages == null) {
            this.packages = new ArrayList<PackageDefinition>();
            try {
                this.packages = this.filterExcludeInclude(this.getPackages0());
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching packages", (Throwable)e);
            }
        }
        return this.packages;
    }

    private final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        block0: for (Definition definition : definitions) {
            for (String exclude : this.excludes) {
                if (exclude != null && definition.getName().matches(exclude.trim())) continue block0;
            }
            for (String include : this.includes) {
                if (include == null || !definition.getName().matches(include.trim())) continue;
                result.add(definition);
                continue block0;
            }
        }
        return result;
    }

    private final <T extends TableDefinition> List<T> filterMasterDataTables(List<TableDefinition> list, boolean include) {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        block0: for (TableDefinition definition : list) {
            for (String table : this.masterDataTableNames) {
                if (!definition.getName().matches(table)) continue;
                if (!include) continue block0;
                result.add(new DefaultMasterDataTableDefinition(definition));
                continue block0;
            }
            if (include) continue;
            result.add(definition);
        }
        return result;
    }

    protected final Relations getRelations0() throws SQLException {
        DefaultRelations result = new DefaultRelations(this);
        this.loadPrimaryKeys(result);
        this.loadUniqueKeys(result);
        this.loadForeignKeys(result);
        return result;
    }

    @Override
    public final boolean isArrayType(String dataType) {
        switch (this.getDialect()) {
            case POSTGRES: 
            case H2: {
                return "ARRAY".equals(dataType);
            }
            case HSQLDB: {
                return dataType.endsWith("ARRAY");
            }
        }
        return false;
    }

    protected abstract void loadPrimaryKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadUniqueKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadForeignKeys(DefaultRelations var1) throws SQLException;

    protected abstract List<SequenceDefinition> getSequences0() throws SQLException;

    protected abstract List<TableDefinition> getTables0() throws SQLException;

    protected abstract List<ProcedureDefinition> getProcedures0() throws SQLException;

    protected abstract List<FunctionDefinition> getFunctions0() throws SQLException;

    protected abstract List<PackageDefinition> getPackages0() throws SQLException;

    protected abstract List<EnumDefinition> getEnums0() throws SQLException;

    protected abstract List<UDTDefinition> getUDTs0() throws SQLException;

    protected abstract List<ArrayDefinition> getArrays0() throws SQLException;
}

