/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.hsqldb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.hsqldb.HSQLDBFunctionDefinition;
import org.jooq.util.hsqldb.HSQLDBProcedureDefinition;
import org.jooq.util.hsqldb.HSQLDBTableDefinition;
import org.jooq.util.hsqldb.information_schema.InformationSchemaFactory;
import org.jooq.util.hsqldb.information_schema.tables.KeyColumnUsage;
import org.jooq.util.hsqldb.information_schema.tables.ReferentialConstraints;
import org.jooq.util.hsqldb.information_schema.tables.Routines;
import org.jooq.util.hsqldb.information_schema.tables.Sequences;
import org.jooq.util.hsqldb.information_schema.tables.TableConstraints;
import org.jooq.util.hsqldb.information_schema.tables.Tables;

public class HSQLDBDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String key = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String key = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{KeyColumnUsage.CONSTRAINT_NAME, KeyColumnUsage.TABLE_NAME, KeyColumnUsage.COLUMN_NAME}).from(new TableLike[]{TableConstraints.TABLE_CONSTRAINTS}).join((TableLike)KeyColumnUsage.KEY_COLUMN_USAGE).on(new Condition[]{TableConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)}).where(new Condition[]{TableConstraints.CONSTRAINT_TYPE.equal((Object)constraintType).and(TableConstraints.TABLE_SCHEMA.equal((Object)this.getSchemaName()))}).orderBy(new SortField[]{KeyColumnUsage.TABLE_SCHEMA.ascending(), KeyColumnUsage.TABLE_NAME.ascending(), KeyColumnUsage.ORDINAL_POSITION.ascending()}).fetch().getRecords();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Result result = this.create().select(new Field[]{ReferentialConstraints.CONSTRAINT_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, KeyColumnUsage.TABLE_NAME, KeyColumnUsage.COLUMN_NAME}).from(new TableLike[]{ReferentialConstraints.REFERENTIAL_CONSTRAINTS}).join((TableLike)KeyColumnUsage.KEY_COLUMN_USAGE).on(new Condition[]{ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)}).where(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new SortField[]{KeyColumnUsage.TABLE_SCHEMA.ascending(), KeyColumnUsage.TABLE_NAME.ascending(), KeyColumnUsage.ORDINAL_POSITION.ascending()}).fetch();
        for (Record record : result) {
            String foreignKey = (String)record.getValue(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyTable = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String uniqueKey = (String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKey, uniqueKey, referencingColumn);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(new Field[]{Sequences.SEQUENCE_NAME}).from(new TableLike[]{Sequences.SEQUENCES}).where(new Condition[]{Sequences.SEQUENCE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Sequences.SEQUENCE_NAME}).fetch(Sequences.SEQUENCE_NAME)) {
            result.add(new DefaultSequenceDefinition(this, name));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (String name : this.create().select(new Field[]{Tables.TABLE_NAME}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Tables.TABLE_NAME}).fetch(Tables.TABLE_NAME)) {
            String comment = "";
            HSQLDBTableDefinition table = new HSQLDBTableDefinition(this, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        for (Record record : this.create().select(new Field[]{Routines.ROUTINE_NAME, Routines.SPECIFIC_NAME}).from(new TableLike[]{Routines.ROUTINES}).where(new Condition[]{Routines.ROUTINE_SCHEMA.equal((Object)this.getSchemaName())}).and(Routines.ROUTINE_TYPE.equal((Object)"PROCEDURE")).orderBy(new Field[]{Routines.ROUTINE_NAME}).fetch()) {
            String name = (String)record.getValue(Routines.ROUTINE_NAME);
            String specificName = (String)record.getValue(Routines.SPECIFIC_NAME);
            HSQLDBProcedureDefinition procedure = new HSQLDBProcedureDefinition((Database)this, null, name, specificName);
            result.add(procedure);
        }
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        for (Record record : this.create().select(new Field[]{Routines.ROUTINE_NAME, Routines.SPECIFIC_NAME, Routines.DATA_TYPE}).from(new TableLike[]{Routines.ROUTINES}).where(new Condition[]{Routines.ROUTINE_SCHEMA.equal((Object)this.getSchemaName())}).and(Routines.ROUTINE_TYPE.equal((Object)"FUNCTION")).orderBy(new Field[]{Routines.ROUTINE_NAME}).fetch()) {
            String name = (String)record.getValue(Routines.ROUTINE_NAME);
            String specificName = (String)record.getValue(Routines.SPECIFIC_NAME);
            String dataType = (String)record.getValue(Routines.DATA_TYPE);
            HSQLDBFunctionDefinition function = new HSQLDBFunctionDefinition(this, name, specificName, dataType);
            result.add(function);
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new InformationSchemaFactory(this.getConnection());
    }
}

