/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.oracle;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultArrayDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.oracle.OracleFunctionDefinition;
import org.jooq.util.oracle.OraclePackageDefinition;
import org.jooq.util.oracle.OracleProcedureDefinition;
import org.jooq.util.oracle.OracleTableDefinition;
import org.jooq.util.oracle.OracleUDTDefinition;
import org.jooq.util.oracle.sys.SysFactory;
import org.jooq.util.oracle.sys.tables.AllArguments;
import org.jooq.util.oracle.sys.tables.AllCollTypes;
import org.jooq.util.oracle.sys.tables.AllConsColumns;
import org.jooq.util.oracle.sys.tables.AllConstraints;
import org.jooq.util.oracle.sys.tables.AllObjects;
import org.jooq.util.oracle.sys.tables.AllSequences;
import org.jooq.util.oracle.sys.tables.AllTabComments;
import org.jooq.util.oracle.sys.tables.AllTypes;

public class OracleDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            String key = (String)record.getValue(AllConsColumns.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(AllConsColumns.TABLE_NAME);
            String columnName = (String)record.getValue(AllConsColumns.COLUMN_NAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            String key = (String)record.getValue(AllConsColumns.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(AllConsColumns.TABLE_NAME);
            String columnName = (String)record.getValue(AllConsColumns.COLUMN_NAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{AllConsColumns.CONSTRAINT_NAME, AllConsColumns.TABLE_NAME, AllConsColumns.COLUMN_NAME}).from(new TableLike[]{AllConsColumns.ALL_CONS_COLUMNS}).join((TableLike)AllConstraints.ALL_CONSTRAINTS).on(new Condition[]{AllConsColumns.CONSTRAINT_NAME.equal(AllConstraints.CONSTRAINT_NAME)}).where(new Condition[]{AllConstraints.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(AllConstraints.CONSTRAINT_NAME.notLike((Object)"BIN$%")).and(AllConsColumns.OWNER.equal((Object)this.getSchemaName())).orderBy(new Field[]{AllConstraints.CONSTRAINT_NAME, AllConsColumns.POSITION}).fetch().getRecords();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Table cc1 = AllConsColumns.ALL_CONS_COLUMNS.as("cc1");
        Table cc2 = AllConsColumns.ALL_CONS_COLUMNS.as("cc2");
        Field foreignKey = cc1.getField(AllConsColumns.CONSTRAINT_NAME).as("fk_name");
        Field foreignKeyTable = cc1.getField(AllConsColumns.TABLE_NAME).as("fk_table");
        Field foreignKeyColumn = cc1.getField(AllConsColumns.COLUMN_NAME).as("fk_column");
        Field uniqueKey = cc2.getField(AllConsColumns.CONSTRAINT_NAME).as("uk_name");
        Field uniqueKeyTable = cc2.getField(AllConsColumns.TABLE_NAME).as("uk_table");
        SelectQuery inner = this.create().selectQuery();
        inner.addFrom(new TableLike[]{AllConsColumns.ALL_CONS_COLUMNS});
        inner.addJoin((TableLike)AllConstraints.ALL_CONSTRAINTS, new Condition[]{AllConsColumns.CONSTRAINT_NAME.equal(AllConstraints.CONSTRAINT_NAME)});
        inner.addSelect(new Field[]{AllConstraints.CONSTRAINT_NAME});
        inner.addConditions(new Condition[]{AllConstraints.CONSTRAINT_TYPE.equal((Object)"R"), AllConsColumns.OWNER.equal((Object)this.getSchemaName()), AllConsColumns.TABLE_NAME.equal(cc1.getField(AllConsColumns.TABLE_NAME)), AllConsColumns.COLUMN_NAME.equal(cc1.getField(AllConsColumns.COLUMN_NAME))});
        SelectQuery query = this.create().selectQuery();
        query.addFrom(new TableLike[]{AllConstraints.ALL_CONSTRAINTS});
        query.addSelect(new Field[]{foreignKey, uniqueKey, foreignKeyTable, uniqueKeyTable, foreignKeyColumn});
        query.addJoin((TableLike)cc1, new Condition[]{cc1.getField(AllConsColumns.CONSTRAINT_NAME).equal(AllConstraints.CONSTRAINT_NAME)});
        query.addJoin((TableLike)cc2, new Condition[]{cc2.getField(AllConsColumns.CONSTRAINT_NAME).equal(AllConstraints.R_CONSTRAINT_NAME), cc2.getField(AllConsColumns.POSITION).equal(cc1.getField(AllConsColumns.POSITION))});
        query.addConditions(new Condition[]{AllConstraints.OWNER.equal((Object)this.getSchemaName()), cc1.getField(AllConsColumns.OWNER).equal((Object)this.getSchemaName()), cc2.getField(AllConsColumns.OWNER).equal((Object)this.getSchemaName()), cc1.getField(AllConsColumns.CONSTRAINT_NAME).equal((Select)inner)});
        query.addOrderBy(new Field[]{foreignKey});
        query.addOrderBy(new Field[]{cc2.getField(AllConsColumns.POSITION)});
        query.execute();
        for (Record record : query.getResult()) {
            String foreignKeyName = (String)record.getValue(foreignKey);
            String foreignKeyTableName = (String)record.getValue(foreignKeyTable);
            String foreignKeyColumnName = (String)record.getValue(foreignKeyColumn);
            String uniqueKeyName = (String)record.getValue(uniqueKey);
            TableDefinition referencingTable = this.getTable(foreignKeyTableName);
            if (referencingTable == null) continue;
            ColumnDefinition column = referencingTable.getColumn(foreignKeyColumnName);
            relations.addForeignKey(foreignKeyName, uniqueKeyName, column);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(new Field[]{AllSequences.SEQUENCE_NAME}).from(new TableLike[]{AllSequences.ALL_SEQUENCES}).where(new Condition[]{AllSequences.SEQUENCE_OWNER.equal((Object)this.getSchemaName())}).orderBy(new Field[]{AllSequences.SEQUENCE_NAME}).fetch(AllSequences.SEQUENCE_NAME)) {
            result.add(new DefaultSequenceDefinition(this, name));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{AllTabComments.TABLE_NAME, AllTabComments.COMMENTS}).from(new TableLike[]{AllTabComments.ALL_TAB_COMMENTS}).where(new Condition[]{AllTabComments.OWNER.equal((Object)this.getSchemaName())}).and(AllTabComments.TABLE_NAME.notLike((Object)"%$%")).orderBy(new Field[]{AllTabComments.TABLE_NAME}).fetch()) {
            String name = (String)record.getValue(AllTabComments.TABLE_NAME);
            String comment = (String)record.getValue(AllTabComments.COMMENTS);
            OracleTableDefinition table = new OracleTableDefinition(this, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (String name : this.create().selectDistinct(new Field[]{AllTypes.TYPE_NAME}).from(new TableLike[]{AllTypes.ALL_TYPES}).where(new Condition[]{AllTypes.OWNER.equal((Object)this.getSchemaName())}).and(AllTypes.TYPECODE.equal((Object)"OBJECT")).orderBy(new Field[]{AllTypes.TYPE_NAME}).fetch(AllTypes.TYPE_NAME)) {
            result.add(new OracleUDTDefinition(this, name, null));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> arrays = new ArrayList<ArrayDefinition>();
        for (Record record : this.create().select(new Field[]{AllCollTypes.TYPE_NAME, AllCollTypes.ELEM_TYPE_NAME, AllCollTypes.PRECISION, AllCollTypes.SCALE}).from(new TableLike[]{AllCollTypes.ALL_COLL_TYPES}).where(new Condition[]{AllCollTypes.OWNER.equal((Object)this.getSchemaName())}).and(AllCollTypes.COLL_TYPE.equal((Object)"VARYING ARRAY")).orderBy(new Field[]{AllCollTypes.TYPE_NAME}).fetch()) {
            String name = (String)record.getValue(AllCollTypes.TYPE_NAME);
            String dataType = (String)record.getValue(AllCollTypes.ELEM_TYPE_NAME);
            int precision = ((BigDecimal)record.getValue(AllCollTypes.PRECISION, (Object)BigDecimal.ZERO)).intValue();
            int scale = ((BigDecimal)record.getValue(AllCollTypes.SCALE, (Object)BigDecimal.ZERO)).intValue();
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, dataType, precision, scale);
            DefaultArrayDefinition array = new DefaultArrayDefinition((Database)this, name, type);
            arrays.add(array);
        }
        return arrays;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        for (Record record : this.create().select(new Field[]{AllObjects.OBJECT_NAME, AllObjects.OBJECT_ID}).from(new TableLike[]{AllObjects.ALL_OBJECTS}).where(new Condition[]{AllObjects.OWNER.equal((Object)this.getSchemaName()).and(AllObjects.OBJECT_TYPE.equal((Object)"PROCEDURE"))}).or(AllObjects.OBJECT_TYPE.equal((Object)"FUNCTION").andExists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{AllArguments.ALL_ARGUMENTS}).where(new Condition[]{AllArguments.OWNER.equal((Object)this.getSchemaName())}).and(AllArguments.OBJECT_NAME.equal(AllObjects.OBJECT_NAME)).and(AllArguments.OBJECT_ID.equal(AllObjects.OBJECT_ID)).and(AllArguments.IN_OUT.in((Object[])new String[]{"OUT", "IN/OUT"})).and(AllArguments.ARGUMENT_NAME.isNotNull()).and(AllArguments.POSITION.notEqual((Object)BigDecimal.ZERO)))).orderBy(new Field[]{AllObjects.OBJECT_NAME, AllObjects.OBJECT_ID}).fetch()) {
            String objectName = (String)record.getValue(AllObjects.OBJECT_NAME);
            BigDecimal objectId = (BigDecimal)record.getValue(AllObjects.OBJECT_ID);
            result.add(new OracleProcedureDefinition(this, null, objectName, "", objectId, null));
        }
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        for (Record record : this.create().select(new Field[]{AllObjects.OBJECT_NAME, AllObjects.OBJECT_ID}).from(new TableLike[]{AllObjects.ALL_OBJECTS}).where(new Condition[]{AllObjects.OWNER.equal((Object)this.getSchemaName()).and(AllObjects.OBJECT_TYPE.equal((Object)"FUNCTION"))}).andNotExists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{AllArguments.ALL_ARGUMENTS}).where(new Condition[]{AllArguments.OWNER.equal((Object)this.getSchemaName())}).and(AllArguments.OBJECT_NAME.equal(AllObjects.OBJECT_NAME)).and(AllArguments.OBJECT_ID.equal(AllObjects.OBJECT_ID)).and(AllArguments.IN_OUT.in((Object[])new String[]{"OUT", "IN/OUT"})).and(AllArguments.ARGUMENT_NAME.isNotNull()).and(AllArguments.POSITION.notEqual((Object)BigDecimal.ZERO))).orderBy(new Field[]{AllObjects.OBJECT_NAME, AllObjects.OBJECT_ID}).fetch()) {
            String objectName = (String)record.getValue(AllObjects.OBJECT_NAME);
            BigDecimal objectId = (BigDecimal)record.getValue(AllObjects.OBJECT_ID);
            result.add(new OracleFunctionDefinition(this, null, objectName, "", objectId, null));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        for (Record record : this.create().select(new Field[]{AllObjects.OBJECT_NAME, AllObjects.OBJECT_ID}).from(new TableLike[]{AllObjects.ALL_OBJECTS}).where(new Condition[]{AllObjects.OWNER.equal((Object)this.getSchemaName()).and(AllObjects.OBJECT_TYPE.equal((Object)"PACKAGE"))}).orderBy(new Field[]{AllObjects.OBJECT_NAME, AllObjects.OBJECT_ID}).fetch()) {
            String name = (String)record.getValue(AllObjects.OBJECT_NAME);
            result.add(new OraclePackageDefinition(this, name, ""));
        }
        return result;
    }

    @Override
    public Factory create() {
        return new SysFactory(this.getConnection());
    }
}

