/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.oracle;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.util.AbstractPackageDefinition;
import org.jooq.util.Database;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.oracle.OracleFunctionDefinition;
import org.jooq.util.oracle.OracleProcedureDefinition;
import org.jooq.util.oracle.sys.tables.AllArguments;
import org.jooq.util.oracle.sys.tables.records.AllArgumentsRecord;

public class OraclePackageDefinition
extends AbstractPackageDefinition {
    private Table<AllArgumentsRecord> o = AllArguments.ALL_ARGUMENTS.as("outer");
    private Table<AllArgumentsRecord> i = AllArguments.ALL_ARGUMENTS.as("inner");
    private Field<String> o_objectName = this.o.getField(AllArguments.OBJECT_NAME);
    private Field<String> i_objectName = this.i.getField(AllArguments.OBJECT_NAME);
    private Field<BigDecimal> o_objectID = this.o.getField(AllArguments.OBJECT_ID);
    private Field<BigDecimal> i_objectID = this.i.getField(AllArguments.OBJECT_ID);
    private Field<String> o_overload = this.o.getField(AllArguments.OVERLOAD);

    public OraclePackageDefinition(Database database, String packageName, String comment) {
        super(database, packageName, comment);
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        for (Record record : this.getProcedures(true)) {
            String name = (String)record.getValue(this.o_objectName);
            BigDecimal objectId = (BigDecimal)record.getValue(this.o_objectID);
            String overload = (String)record.getValue(this.o_overload);
            result.add(new OracleProcedureDefinition(this.getDatabase(), this, name, "", objectId, overload));
        }
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        for (Record record : this.getProcedures(false)) {
            String name = (String)record.getValue(this.o_objectName);
            BigDecimal objectId = (BigDecimal)record.getValue(this.o_objectID);
            String overload = (String)record.getValue(this.o_overload);
            result.add(new OracleFunctionDefinition(this.getDatabase(), this, name, "", objectId, overload));
        }
        return result;
    }

    private Result<Record> getProcedures(boolean procedures) throws SQLException {
        Condition existsReturnValue = this.create().exists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{this.i}).where(new Condition[]{this.i.getField(AllArguments.OWNER).equal((Object)this.getSchemaName())}).and(this.i.getField(AllArguments.PACKAGE_NAME).equal((Object)this.getName())).and(this.i_objectID.equal(this.o_objectID)).and(this.i_objectName.equal(this.o_objectName)).and(this.i.getField(AllArguments.POSITION).equal((Object)BigDecimal.ZERO)));
        Condition notExistsOUTParameters = this.create().notExists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{this.i}).where(new Condition[]{this.i.getField(AllArguments.OWNER).equal((Object)this.getSchemaName())}).and(this.i.getField(AllArguments.PACKAGE_NAME).equal((Object)this.getName())).and(this.i_objectID.equal(this.o_objectID)).and(this.i_objectName.equal(this.o_objectName)).and(this.i.getField(AllArguments.POSITION).notEqual((Object)BigDecimal.ZERO)).and(this.i.getField(AllArguments.IN_OUT).in((Object[])new String[]{"OUT", "IN/OUT"})));
        Condition combine = existsReturnValue.and(notExistsOUTParameters);
        if (procedures) {
            combine = combine.not();
        }
        return this.create().selectDistinct(new Field[]{this.o_objectName, this.o_objectID, this.o_overload}).from(new TableLike[]{this.o}).where(new Condition[]{this.o.getField(AllArguments.OWNER).equal((Object)this.getSchemaName())}).and(this.o.getField(AllArguments.PACKAGE_NAME).equal((Object)this.getName())).and(combine).fetch();
    }
}

