/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jooq.Record;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractGeneratorStrategy;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Definition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;

class GeneratorStrategyWrapper
extends AbstractGeneratorStrategy {
    private static final JooqLogger log = JooqLogger.getLogger(GeneratorStrategyWrapper.class);
    private final Map<Class<?>, Set<String>> reservedColumns = new HashMap();
    final Generator generator;
    final GeneratorStrategy delegate;

    GeneratorStrategyWrapper(Generator generator, GeneratorStrategy delegate) {
        this.generator = generator;
        this.delegate = delegate;
    }

    @Override
    public String getTargetDirectory() {
        return this.delegate.getTargetDirectory();
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.delegate.setTargetDirectory(directory);
    }

    @Override
    public String getTargetPackage() {
        return this.delegate.getTargetPackage();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.delegate.setTargetPackage(packageName);
    }

    @Override
    public void setInstanceFields(boolean instanceFields) {
        this.delegate.setInstanceFields(instanceFields);
    }

    @Override
    public boolean getInstanceFields() {
        return this.delegate.getInstanceFields();
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        TypedElementDefinition e;
        String identifier = GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaIdentifier(definition));
        if ((definition instanceof ColumnDefinition || definition instanceof AttributeDefinition) && identifier.equals(this.getJavaIdentifier((e = (TypedElementDefinition)definition).getContainer()))) {
            return identifier + "_";
        }
        return identifier;
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.disambiguateMethod(definition, GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaSetterName(definition, mode)));
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.disambiguateMethod(definition, GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaGetterName(definition, mode)));
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.disambiguateMethod(definition, GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaMethodName(definition, mode)));
    }

    private String disambiguateMethod(Definition definition, String method) {
        Set<String> reserved = null;
        if (definition instanceof AttributeDefinition) {
            reserved = this.reservedColumns(UDTRecordImpl.class);
        } else if (definition instanceof ColumnDefinition) {
            reserved = ((TableDefinition)((ColumnDefinition)definition).getContainer()).getMainUniqueKey() != null ? this.reservedColumns(UpdatableRecordImpl.class) : this.reservedColumns(TableRecordImpl.class);
        }
        if (reserved != null) {
            if (reserved.contains(method)) {
                return method + "_";
            }
            if (method.startsWith("set")) {
                String base = method.substring(3);
                if (reserved.contains("get" + base) || reserved.contains("is" + base)) {
                    return method + "_";
                }
            }
        }
        return method;
    }

    private Set<String> reservedColumns(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Set<String> result = this.reservedColumns.get(clazz);
        if (result == null) {
            result = new HashSet<String>();
            this.reservedColumns.put(clazz, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass()));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                String name = ((Method)genericDeclaration).getName();
                if (!name.startsWith("get") || ((Method)genericDeclaration).getParameterTypes().length != 0) continue;
                result.add(name);
            }
        }
        return result;
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String alternative;
        if (!this.generator.generateRecords() && mode == GeneratorStrategy.Mode.RECORD && definition instanceof TableDefinition) {
            return Record.class.getSimpleName();
        }
        String className = GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaClassName(definition, mode));
        if (mode == GeneratorStrategy.Mode.FACTORY && className.equalsIgnoreCase(alternative = GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaClassName(definition, GeneratorStrategy.Mode.DEFAULT)))) {
            log.warn((Object)"Configuration problem", (Object)"Factory has the same name as Schema, forcing Factory suffix. Consider correcting your strategy");
            className = className + "Factory";
        }
        return className;
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        if (!this.generator.generateRecords() && mode == GeneratorStrategy.Mode.RECORD && definition instanceof TableDefinition) {
            return Record.class.getPackage().getName();
        }
        Object[] split = this.delegate.getJavaPackageName(definition, mode).split("\\.");
        for (int i = 0; i < split.length; ++i) {
            split[i] = GenerationUtil.convertToJavaIdentifier((String)split[i]);
        }
        return StringUtils.join((Object[])split, (String)".");
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        return GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaMemberName(definition, mode));
    }
}

