/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.SQLDialect;
import org.jooq.codegen.AbstractGeneratorStrategy;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.tools.StringUtils;

public class DefaultGeneratorStrategy
extends AbstractGeneratorStrategy {
    private String targetDirectory;
    private String targetPackage;
    private boolean instanceFields = true;
    private boolean javaBeansGettersAndSetters = false;

    @Override
    public void setInstanceFields(boolean instanceFields) {
        this.instanceFields = instanceFields;
    }

    @Override
    public boolean getInstanceFields() {
        return this.instanceFields;
    }

    @Override
    public void setJavaBeansGettersAndSetters(boolean javaBeansGettersAndSetters) {
        this.javaBeansGettersAndSetters = javaBeansGettersAndSetters;
    }

    @Override
    public boolean getJavaBeansGettersAndSetters() {
        return this.javaBeansGettersAndSetters;
    }

    @Override
    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public String getFileHeader(Definition definition, GeneratorStrategy.Mode mode) {
        return "This file is generated by jOOQ.";
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        String identifier = this.getFixedJavaIdentifier(definition);
        if (identifier != null) {
            return identifier;
        }
        if (definition instanceof IndexDefinition && Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains(definition.getDatabase().getDialect().family())) {
            return ((IndexDefinition)definition).getTable().getOutputName().toUpperCase() + "_" + definition.getOutputName().toUpperCase();
        }
        return definition.getOutputName().toUpperCase();
    }

    private String getterSetterSuffix(Definition definition) {
        if (this.javaBeansGettersAndSetters) {
            String name = this.getJavaMemberName(definition);
            if (Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return this.getJavaClassName0(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "set" + this.getterSetterSuffix(definition);
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "get" + this.getterSetterSuffix(definition);
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        if (definition instanceof ForeignKeyDefinition) {
            ForeignKeyDefinition fk = (ForeignKeyDefinition)definition;
            TableDefinition referenced = fk.getReferencedTable();
            if (fk.getKeyTable().getForeignKeys(referenced).size() == 1) {
                return this.getJavaMethodName((Definition)referenced, mode);
            }
        }
        return this.getJavaClassName0LC(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        return null;
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        return new ArrayList<String>();
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String name = this.getFixedJavaClassName(definition);
        if (name != null) {
            return name;
        }
        return this.getJavaClassName0(definition, mode);
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (definition.getDatabase().getCatalogs().size() > 1) {
            sb.append(".");
            sb.append(this.getJavaIdentifier((Definition)definition.getCatalog()).toLowerCase());
        }
        if (!(definition instanceof CatalogDefinition)) {
            if (definition.getDatabase().getSchemata().size() > 1) {
                sb.append(".");
                sb.append(this.getJavaIdentifier((Definition)definition.getSchema()).toLowerCase());
            }
            if (!(definition instanceof SchemaDefinition)) {
                if (!StringUtils.isBlank((String)this.getSubPackage(definition))) {
                    sb.append(".");
                    sb.append(this.getSubPackage(definition));
                }
                if (mode == GeneratorStrategy.Mode.RECORD) {
                    sb.append(".records");
                } else if (mode == GeneratorStrategy.Mode.POJO) {
                    sb.append(".pojos");
                } else if (mode == GeneratorStrategy.Mode.DAO) {
                    sb.append(".daos");
                } else if (mode == GeneratorStrategy.Mode.INTERFACE) {
                    sb.append(".interfaces");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName0LC(definition, mode);
    }

    private String getJavaClassName0LC(Definition definition, GeneratorStrategy.Mode mode) {
        String result = this.getJavaClassName0(definition, mode);
        return result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    private String getJavaClassName0(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.toCamelCase((String)definition.getOutputName().replace(' ', '_').replace('-', '_').replace('.', '_')));
        if (mode == GeneratorStrategy.Mode.RECORD) {
            result.append("Record");
        } else if (mode == GeneratorStrategy.Mode.DAO) {
            result.append("Dao");
        } else if (mode == GeneratorStrategy.Mode.INTERFACE) {
            result.insert(0, "I");
        }
        return result.toString();
    }

    private String getSubPackage(Definition definition) {
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof EmbeddableDefinition) {
            return "embeddables";
        }
        if (definition instanceof UDTDefinition) {
            UDTDefinition udt = (UDTDefinition)definition;
            if (udt.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)udt.getPackage()).toLowerCase() + ".udt";
            }
            return "udt";
        }
        if (definition instanceof PackageDefinition) {
            return "packages";
        }
        if (definition instanceof RoutineDefinition) {
            RoutineDefinition routine = (RoutineDefinition)definition;
            if (routine.getPackage() instanceof UDTDefinition) {
                return "udt." + this.getJavaIdentifier((Definition)routine.getPackage()).toLowerCase();
            }
            if (routine.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)routine.getPackage()).toLowerCase();
            }
            return "routines";
        }
        if (definition instanceof EnumDefinition) {
            return "enums";
        }
        if (definition instanceof DomainDefinition) {
            return "domains";
        }
        if (definition instanceof ArrayDefinition) {
            ArrayDefinition array = (ArrayDefinition)definition;
            if (array.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)array.getPackage()).toLowerCase() + ".udt";
            }
            return "udt";
        }
        return "";
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return overloadIndex;
    }
}

