/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.Patterns;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.jaxb.MatcherRule;
import org.jooq.meta.jaxb.MatcherTransformType;
import org.jooq.meta.jaxb.Matchers;
import org.jooq.meta.jaxb.MatchersCatalogType;
import org.jooq.meta.jaxb.MatchersEmbeddableType;
import org.jooq.meta.jaxb.MatchersEnumType;
import org.jooq.meta.jaxb.MatchersFieldType;
import org.jooq.meta.jaxb.MatchersRoutineType;
import org.jooq.meta.jaxb.MatchersSchemaType;
import org.jooq.meta.jaxb.MatchersSequenceType;
import org.jooq.meta.jaxb.MatchersTableType;
import org.jooq.tools.StringUtils;

public class MatcherStrategy
extends DefaultGeneratorStrategy {
    private final Matchers matchers;
    private final Patterns patterns;

    public MatcherStrategy(Matchers matchers) {
        this(matchers, new Patterns());
    }

    public MatcherStrategy(Matchers matchers, Patterns patterns) {
        this.matchers = matchers;
        this.patterns = patterns;
    }

    public Matchers getMatchers() {
        return this.matchers;
    }

    public Patterns getPatterns() {
        return this.patterns;
    }

    private final String match(Definition definition, String expression, MatcherRule rule) {
        if (rule != null) {
            return this.match(definition, expression, rule.getExpression(), rule.getTransform());
        }
        return null;
    }

    private final String match(Definition definition, String expression, String ruleExpression) {
        return this.match(definition, expression, ruleExpression, null);
    }

    private final String match(Definition definition, String expression, String ruleExpression, MatcherTransformType ruleTransformType) {
        if (ruleTransformType != null && ruleExpression == null) {
            ruleExpression = "$0";
        }
        if (ruleExpression != null) {
            Pattern p = this.patterns.pattern(StringUtils.defaultIfEmpty((String)expression, (String)"^.*$").trim());
            Matcher m = p.matcher(definition.getName());
            if (m.matches()) {
                return this.transform(m.replaceAll(ruleExpression), ruleTransformType);
            }
            m = p.matcher(definition.getQualifiedName());
            if (m.matches()) {
                return this.transform(m.replaceAll(ruleExpression), ruleTransformType);
            }
        }
        return null;
    }

    private final String transform(String string, MatcherTransformType transform) {
        if (transform == null) {
            return string;
        }
        switch (transform) {
            case AS_IS: {
                return string;
            }
            case LOWER: {
                return string.toLowerCase(this.getTargetLocale());
            }
            case LOWER_FIRST_LETTER: {
                return StringUtils.toLC((String)string);
            }
            case UPPER: {
                return string.toUpperCase(this.getTargetLocale());
            }
            case UPPER_FIRST_LETTER: {
                return StringUtils.toUC((String)string);
            }
            case CAMEL: {
                return StringUtils.toCamelCaseLC((String)string);
            }
            case PASCAL: {
                return StringUtils.toCamelCase((String)string);
            }
        }
        throw new UnsupportedOperationException("Transform Type not supported : " + transform);
    }

    private final List<MatchersCatalogType> catalogs(Definition definition) {
        if (definition instanceof CatalogDefinition) {
            return this.matchers.getCatalogs();
        }
        return Collections.emptyList();
    }

    private final List<MatchersSchemaType> schemas(Definition definition) {
        if (definition instanceof SchemaDefinition) {
            return this.matchers.getSchemas();
        }
        return Collections.emptyList();
    }

    private final List<MatchersTableType> tables(Definition definition) {
        if (definition instanceof TableDefinition) {
            return this.matchers.getTables();
        }
        return Collections.emptyList();
    }

    private final List<MatchersFieldType> fields(Definition definition) {
        if (definition instanceof ColumnDefinition) {
            return this.matchers.getFields();
        }
        return Collections.emptyList();
    }

    private final List<MatchersRoutineType> routines(Definition definition) {
        if (definition instanceof RoutineDefinition) {
            return this.matchers.getRoutines();
        }
        return Collections.emptyList();
    }

    private final List<MatchersSequenceType> sequences(Definition definition) {
        if (definition instanceof SequenceDefinition) {
            return this.matchers.getSequences();
        }
        return Collections.emptyList();
    }

    private final List<MatchersEnumType> enums(Definition definition) {
        if (definition instanceof EnumDefinition) {
            return this.matchers.getEnums();
        }
        return Collections.emptyList();
    }

    private final List<MatchersEmbeddableType> embeddables(Definition definition) {
        if (definition instanceof EmbeddableDefinition) {
            return this.matchers.getEmbeddables();
        }
        return Collections.emptyList();
    }

    private final List<String> split(String result) {
        String[] split = result.split(",");
        ArrayList<String> list = new ArrayList<String>(split.length);
        for (String string : split) {
            list.add(string.trim());
        }
        return list;
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = this.match(definition, tables.getExpression(), tables.getTableIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersFieldType fields : this.fields(definition)) {
            result = this.match(definition, fields.getExpression(), fields.getFieldIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersSequenceType sequences : this.sequences(definition)) {
            result = this.match(definition, sequences.getExpression(), sequences.getSequenceIdentifier());
            if (result == null) continue;
            return result;
        }
        return super.getJavaIdentifier(definition);
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        for (MatchersFieldType fields : this.fields(definition)) {
            String result = this.match(definition, fields.getExpression(), fields.getFieldSetter());
            if (result == null) continue;
            return result;
        }
        return super.getJavaSetterName(definition, mode);
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        for (MatchersFieldType fields : this.fields(definition)) {
            String result = this.match(definition, fields.getExpression(), fields.getFieldGetter());
            if (result == null) continue;
            return result;
        }
        return super.getJavaGetterName(definition, mode);
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        for (MatchersRoutineType routines : this.routines(definition)) {
            String result = this.match(definition, routines.getExpression(), routines.getRoutineMethod());
            if (result == null) continue;
            return result;
        }
        return super.getJavaMethodName(definition, mode);
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersTableType tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoExtends());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersEmbeddableType embeddables : this.embeddables(definition)) {
            result = null;
            switch (mode) {
                case POJO: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getPojoExtends());
                }
            }
            if (result == null) continue;
            return result;
        }
        return super.getJavaClassExtends(definition, mode);
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableImplements());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoImplements());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, tables.getExpression(), tables.getInterfaceImplements());
                    break;
                }
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoImplements());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordImplements());
                }
            }
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersEmbeddableType embeddables : this.embeddables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordImplements());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getInterfaceImplements());
                    break;
                }
                case POJO: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getPojoImplements());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordImplements());
                }
            }
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersRoutineType routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersEnumType enums : this.enums(definition)) {
            result = this.match(definition, enums.getExpression(), enums.getEnumImplements());
            if (result == null) continue;
            return this.split(result);
        }
        return super.getJavaClassImplements(definition, mode);
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogClass());
            if (result == null) continue;
            return result;
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaClass());
            if (result == null) continue;
            return result;
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableClass());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoClass());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, tables.getExpression(), tables.getInterfaceClass());
                    break;
                }
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoClass());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordClass());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersEmbeddableType embeddables : this.embeddables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordClass());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getInterfaceClass());
                    break;
                }
                case POJO: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getPojoClass());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordClass());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersRoutineType routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineClass());
            if (result == null) continue;
            return result;
        }
        for (MatchersEnumType enums : this.enums(definition)) {
            result = this.match(definition, enums.getExpression(), enums.getEnumClass());
            if (result == null) continue;
            return result;
        }
        return super.getJavaClassName(definition, mode);
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        return super.getJavaPackageName(definition, mode);
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        for (MatchersFieldType fields : this.fields(definition)) {
            String result = this.match(definition, fields.getExpression(), fields.getFieldMember());
            if (result == null) continue;
            return result;
        }
        return super.getJavaMemberName(definition, mode);
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return super.getOverloadSuffix(definition, mode, overloadIndex);
    }
}

