/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.tools.StringUtils;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultGeneratorStrategy;
import org.jooq.util.Definition;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.jaxb.MatcherRule;
import org.jooq.util.jaxb.MatcherTransformType;
import org.jooq.util.jaxb.Matchers;

public class MatcherStrategy
extends DefaultGeneratorStrategy {
    private final Matchers matchers;

    public MatcherStrategy(Matchers matchers) {
        this.matchers = matchers;
    }

    private final String match(Definition definition, String expression, MatcherRule rule) {
        if (rule != null) {
            return this.match(definition, expression, rule.getExpression(), rule.getTransform());
        }
        return null;
    }

    private final String match(Definition definition, String expression, String ruleExpression) {
        return this.match(definition, expression, ruleExpression, null);
    }

    private final String match(Definition definition, String expression, String ruleExpression, MatcherTransformType ruleTransformType) {
        if (ruleExpression != null) {
            Pattern p = Pattern.compile(StringUtils.defaultIfEmpty((String)expression, (String)"^.*$").trim());
            Matcher m = p.matcher(definition.getName());
            if (m.matches()) {
                return this.transform(m.replaceAll(ruleExpression), ruleTransformType);
            }
            m = p.matcher(definition.getQualifiedName());
            if (m.matches()) {
                return this.transform(m.replaceAll(ruleExpression), ruleTransformType);
            }
        }
        return null;
    }

    private final String transform(String string, MatcherTransformType transform) {
        if (transform == null) {
            return string;
        }
        switch (transform) {
            case AS_IS: {
                return string;
            }
            case LOWER: {
                return string.toLowerCase();
            }
            case UPPER: {
                return string.toUpperCase();
            }
            case CAMEL: {
                return StringUtils.toCamelCaseLC((String)string);
            }
            case PASCAL: {
                return StringUtils.toCamelCase((String)string);
            }
        }
        throw new UnsupportedOperationException("Transform Type not supported : " + transform);
    }

    private final List<Matchers.Schemas> schemas(Definition definition) {
        if (definition instanceof SchemaDefinition) {
            return this.matchers.getSchemas();
        }
        return Collections.emptyList();
    }

    private final List<Matchers.Tables> tables(Definition definition) {
        if (definition instanceof TableDefinition) {
            return this.matchers.getTables();
        }
        return Collections.emptyList();
    }

    private final List<Matchers.Fields> fields(Definition definition) {
        if (definition instanceof ColumnDefinition) {
            return this.matchers.getFields();
        }
        return Collections.emptyList();
    }

    private final List<Matchers.Routines> routines(Definition definition) {
        if (definition instanceof RoutineDefinition) {
            return this.matchers.getRoutines();
        }
        return Collections.emptyList();
    }

    private final List<Matchers.Sequences> sequences(Definition definition) {
        if (definition instanceof SequenceDefinition) {
            return this.matchers.getSequences();
        }
        return Collections.emptyList();
    }

    private final List<String> split(String result) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : result.split(",")) {
            list.add(string.trim());
        }
        return list;
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        String result;
        for (Matchers.Schemas schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaIdentifier());
            if (result == null) continue;
            return result;
        }
        for (Matchers.Tables tables : this.tables(definition)) {
            result = this.match(definition, tables.getExpression(), tables.getTableIdentifier());
            if (result == null) continue;
            return result;
        }
        for (Matchers.Fields fields : this.fields(definition)) {
            result = this.match(definition, fields.getExpression(), fields.getFieldIdentifier());
            if (result == null) continue;
            return result;
        }
        for (Matchers.Sequences sequences : this.sequences(definition)) {
            result = this.match(definition, sequences.getExpression(), sequences.getSequenceIdentifier());
            if (result == null) continue;
            return result;
        }
        return super.getJavaIdentifier(definition);
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        for (Matchers.Fields fields : this.fields(definition)) {
            String result = this.match(definition, fields.getExpression(), fields.getFieldSetter());
            if (result == null) continue;
            return result;
        }
        return super.getJavaSetterName(definition, mode);
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        for (Matchers.Fields fields : this.fields(definition)) {
            String result = this.match(definition, fields.getExpression(), fields.getFieldGetter());
            if (result == null) continue;
            return result;
        }
        return super.getJavaGetterName(definition, mode);
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        for (Matchers.Routines routines : this.routines(definition)) {
            String result = this.match(definition, routines.getExpression(), routines.getRoutineMethod());
            if (result == null) continue;
            return result;
        }
        return super.getJavaMethodName(definition, mode);
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        for (Matchers.Tables tables : this.tables(definition)) {
            String result = null;
            switch (mode) {
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoExtends());
                }
            }
            if (result == null) continue;
            return result;
        }
        return super.getJavaClassExtends(definition, mode);
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (Matchers.Schemas schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (Matchers.Tables tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableImplements());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoImplements());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, tables.getExpression(), tables.getInterfaceImplements());
                    break;
                }
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoImplements());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordImplements());
                }
            }
            if (result == null) continue;
            return this.split(result);
        }
        for (Matchers.Routines routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineImplements());
            if (result == null) continue;
            return this.split(result);
        }
        return super.getJavaClassImplements(definition, mode);
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (Matchers.Schemas schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaClass());
            if (result == null) continue;
            return result;
        }
        for (Matchers.Tables tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableClass());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoClass());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, tables.getExpression(), tables.getInterfaceClass());
                    break;
                }
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoClass());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordClass());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (Matchers.Routines routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineClass());
            if (result == null) continue;
            return result;
        }
        return super.getJavaClassName(definition, mode);
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        return super.getJavaPackageName(definition, mode);
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        for (Matchers.Fields fields : this.fields(definition)) {
            String result = this.match(definition, fields.getExpression(), fields.getFieldMember());
            if (result == null) continue;
            return result;
        }
        return super.getJavaMemberName(definition, mode);
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return super.getOverloadSuffix(definition, mode, overloadIndex);
    }
}

