/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jooq.SQLDialect;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.util.AbstractGenerator;
import org.jooq.util.h2.H2DataType;

class GenerationUtil {
    private static Set<String> JAVA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "interface", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));
    private static Set<String> SCALA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield")));

    GenerationUtil() {
    }

    public static String convertToIdentifier(String literal, AbstractGenerator.Language language) {
        if (language == AbstractGenerator.Language.JAVA && JAVA_KEYWORDS.contains(literal)) {
            return literal + "_";
        }
        if (language == AbstractGenerator.Language.SCALA && SCALA_KEYWORDS.contains(literal)) {
            return "`" + literal + "`";
        }
        StringBuilder sb = new StringBuilder();
        if ("".equals(literal)) {
            return "_";
        }
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append(GenerationUtil.escape(c));
                continue;
            }
            if (i == 0 && !Character.isJavaIdentifierStart(literal.charAt(0))) {
                sb.append("_");
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Deprecated
    public static String convertToJavaIdentifier(String literal) {
        return GenerationUtil.convertToIdentifier(literal, AbstractGenerator.Language.JAVA);
    }

    private static String escape(char c) {
        if (c == ' ' || c == '-' || c == '.') {
            return "_";
        }
        return "_" + Integer.toHexString(c);
    }

    static String getSimpleJavaType(String qualifiedJavaType) {
        if (qualifiedJavaType == null) {
            return null;
        }
        return qualifiedJavaType.replaceAll(".*\\.", "");
    }

    static String getArrayBaseType(SQLDialect dialect, String t, String u) {
        switch (dialect.family()) {
            case POSTGRES: {
                if (u != null && u.startsWith("_")) {
                    return u.substring(1);
                }
                return u;
            }
            case H2: {
                return H2DataType.OTHER.getTypeName();
            }
            case HSQLDB: {
                if ("ARRAY".equalsIgnoreCase(t)) {
                    return "OTHER";
                }
                return t.replace(" ARRAY", "");
            }
        }
        throw new SQLDialectNotSupportedException("getArrayBaseType() is not supported for dialect " + dialect);
    }

    public static Integer[] range(Integer from, Integer to) {
        Integer[] result = new Integer[to - from + 1];
        for (int i = from.intValue(); i <= to; ++i) {
            result[i - from.intValue()] = i;
        }
        return result;
    }
}

