/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.TypeVariable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jooq.AggregateFunction;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.jooq.util.AbstractGenerator;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorException;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.GeneratorWriter;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.JavaWriter;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.postgres.PostgresDatabase;

public class JavaGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(JavaGenerator.class);
    private static final String NO_FURTHER_INSTANCES_ALLOWED = "No further instances allowed";
    private static final int INITIALISER_SIZE = 500;
    private final StopWatch watch = new StopWatch();
    private Database database;
    private String isoDate;
    private Map<SchemaDefinition, String> schemaVersions;
    private Map<CatalogDefinition, String> catalogVersions;
    private Set<File> files = new LinkedHashSet<File>();
    private final boolean scala;
    private final String tokenVoid;

    public JavaGenerator() {
        this(AbstractGenerator.Language.JAVA);
    }

    JavaGenerator(AbstractGenerator.Language language) {
        super(language);
        this.scala = language == AbstractGenerator.Language.SCALA;
        this.tokenVoid = this.scala ? "Unit" : "void";
    }

    @Override
    public final void generate(Database db) {
        this.isoDate = DatatypeConverter.printDateTime((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.schemaVersions = new LinkedHashMap<SchemaDefinition, String>();
        this.catalogVersions = new LinkedHashMap<CatalogDefinition, String>();
        this.database = db;
        this.database.addFilter((Database.Filter)new AvoidAmbiguousClassesFilter());
        this.database.setIncludeRelations(this.generateRelations());
        this.database.setTableValuedFunctions(this.generateTableValuedFunctions());
        String url = "";
        try {
            Connection connection = this.database.getConnection();
            if (connection != null) {
                url = connection.getMetaData().getURL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        log.info((Object)"License parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  Thank you for using jOOQ and jOOQ's code generator");
        log.info((Object)"");
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)this.database.getDialect());
        log.info((Object)"  URL", (Object)url);
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"  includes", Arrays.asList(this.database.getIncludes()));
        log.info((Object)"  excludes", Arrays.asList(this.database.getExcludes()));
        log.info((Object)"  includeExcludeColumns", (Object)this.database.getIncludeExcludeColumns());
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"");
        log.info((Object)"DefaultGenerator parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  strategy", this.strategy.delegate.getClass());
        log.info((Object)"  deprecated", (Object)this.generateDeprecated());
        log.info((Object)"  generated annotation", (Object)(this.generateGeneratedAnnotation() + (!this.generateGeneratedAnnotation && (this.useSchemaVersionProvider || this.useCatalogVersionProvider) ? " (forced to true because of <schemaVersionProvider/> or <catalogVersionProvider/>)" : "")));
        log.info((Object)"  JPA annotations", (Object)this.generateJPAAnnotations());
        log.info((Object)"  validation annotations", (Object)this.generateValidationAnnotations());
        log.info((Object)"  instance fields", (Object)this.generateInstanceFields());
        log.info((Object)"  records", (Object)(this.generateRecords() + (!this.generateRecords && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  pojos", (Object)(this.generatePojos() + (!this.generatePojos && this.generateDaos ? " (forced to true because of <daos/>)" : (!this.generatePojos && this.generateImmutablePojos ? " (forced to true because of <immutablePojos/>)" : ""))));
        log.info((Object)"  immutable pojos", (Object)this.generateImmutablePojos());
        log.info((Object)"  interfaces", (Object)this.generateInterfaces());
        log.info((Object)"  daos", (Object)this.generateDaos());
        log.info((Object)"  relations", (Object)(this.generateRelations() + (!this.generateRelations && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  table-valued functions", (Object)this.generateTableValuedFunctions());
        log.info((Object)"  global references", (Object)this.generateGlobalObjectReferences());
        log.info((Object)"----------------------------------------------------------");
        if (!this.generateInstanceFields()) {
            log.warn((Object)"");
            log.warn((Object)"Deprecation warnings");
            log.warn((Object)"----------------------------------------------------------");
            log.warn((Object)"  <generateInstanceFields/> = false is deprecated! Please adapt your configuration.");
        }
        log.info((Object)"");
        log.info((Object)"Generation remarks");
        log.info((Object)"----------------------------------------------------------");
        if (this.generateImmutablePojos && this.generateInterfaces) {
            log.info((Object)"  immutable pojos", (Object)"Immutable POJOs do not have any setters. Hence, setters are also missing from interfaces");
        } else {
            log.info((Object)"  none");
        }
        log.info((Object)"");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"Generating catalogs", (Object)("Total: " + this.database.getCatalogs().size()));
        for (CatalogDefinition catalog : this.database.getCatalogs()) {
            try {
                this.generate(catalog);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for catalog " + catalog, e);
            }
        }
    }

    private final void generate(CatalogDefinition catalog) {
        String newVersion = catalog.getDatabase().getCatalogVersionProvider().version(catalog);
        if (StringUtils.isBlank((String)newVersion)) {
            log.info((Object)("No schema version is applied for catalog " + catalog.getInputName() + ". Regenerating."));
        } else {
            this.catalogVersions.put(catalog, newVersion);
            String oldVersion = this.readVersion(this.getStrategy().getFile((Definition)catalog), "catalog");
            if (StringUtils.isBlank((String)oldVersion)) {
                log.info((Object)("No previous version available for catalog " + catalog.getInputName() + ". Regenerating."));
            } else if (!oldVersion.equals(newVersion)) {
                log.info((Object)("Existing version " + oldVersion + " is not up to date with " + newVersion + " for catalog " + catalog.getInputName() + ". Regenerating."));
            } else {
                log.info((Object)("Existing version " + oldVersion + " is up to date with " + newVersion + " for catalog " + catalog.getInputName() + ". Ignoring catalog."));
                return;
            }
        }
        this.generateCatalog(catalog);
        log.info((Object)"Generating schemata", (Object)("Total: " + catalog.getSchemata().size()));
        for (SchemaDefinition schema : catalog.getSchemata()) {
            try {
                this.generate(schema);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for schema " + schema, e);
            }
        }
    }

    private final void generate(SchemaDefinition schema) {
        String newVersion = schema.getDatabase().getSchemaVersionProvider().version(schema);
        if (StringUtils.isBlank((String)newVersion)) {
            log.info((Object)("No schema version is applied for schema " + schema.getInputName() + ". Regenerating."));
        } else {
            this.schemaVersions.put(schema, newVersion);
            String oldVersion = this.readVersion(this.getStrategy().getFile((Definition)schema), "schema");
            if (StringUtils.isBlank((String)oldVersion)) {
                log.info((Object)("No previous version available for schema " + schema.getInputName() + ". Regenerating."));
            } else if (!oldVersion.equals(newVersion)) {
                log.info((Object)("Existing version " + oldVersion + " is not up to date with " + newVersion + " for schema " + schema.getInputName() + ". Regenerating."));
            } else {
                log.info((Object)("Existing version " + oldVersion + " is up to date with " + newVersion + " for schema " + schema.getInputName() + ". Ignoring schema."));
                return;
            }
        }
        this.generateSchema(schema);
        if (this.generateGlobalObjectReferences() && this.generateGlobalSequenceReferences() && this.database.getSequences(schema).size() > 0) {
            this.generateSequences(schema);
        }
        if (this.database.getTables(schema).size() > 0) {
            this.generateTables(schema);
        }
        if (this.generatePojos() && this.database.getTables(schema).size() > 0) {
            this.generatePojos(schema);
        }
        if (this.generateDaos() && this.database.getTables(schema).size() > 0) {
            this.generateDaos(schema);
        }
        if (this.generateGlobalObjectReferences() && this.generateGlobalTableReferences() && this.database.getTables(schema).size() > 0) {
            this.generateTableReferences(schema);
        }
        if (this.generateRelations() && this.database.getTables(schema).size() > 0) {
            this.generateRelations(schema);
        }
        if (this.generateRecords() && this.database.getTables(schema).size() > 0) {
            this.generateRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getTables(schema).size() > 0) {
            this.generateInterfaces(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTs(schema);
        }
        if (this.generatePojos() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTPojos(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTInterfaces(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRoutines(schema);
        }
        if (this.generateGlobalObjectReferences() && this.generateGlobalUDTReferences() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTReferences(schema);
        }
        if (this.database.getArrays(schema).size() > 0) {
            this.generateArrays(schema);
        }
        if (this.database.getEnums(schema).size() > 0) {
            this.generateEnums(schema);
        }
        if (this.database.getDomains(schema).size() > 0) {
            this.generateDomains(schema);
        }
        if (this.generateGlobalObjectReferences() && this.generateGlobalRoutineReferences() && this.database.getRoutines(schema).size() > 0 || this.hasTableValuedFunctions(schema)) {
            this.generateRoutines(schema);
        }
        log.info((Object)"Removing excess files");
        this.empty(this.getStrategy().getFile((Definition)schema).getParentFile(), this.scala ? ".scala" : ".java", this.files);
        this.files.clear();
        this.watch.splitInfo("Generation finished: " + schema.getQualifiedName());
        log.info((Object)"");
    }

    private boolean hasTableValuedFunctions(SchemaDefinition schema) {
        for (TableDefinition table : this.database.getTables(schema)) {
            if (!table.isTableValuedFunction()) continue;
            return true;
        }
        return false;
    }

    protected void generateRelations(SchemaDefinition schema) {
        String keyType;
        log.info((Object)"Generating Keys");
        JavaWriter out = this.newJavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Keys.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "A class modelling foreign key relationships between tables of the <code>" + schema.getOutputName() + "</code> schema");
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Keys {");
        } else {
            out.println("public class Keys {");
        }
        ((JavaWriter)out.tab(1)).header("IDENTITY definitions", new Object[0]);
        out.println();
        ArrayList<IdentityDefinition> allIdentities = new ArrayList<IdentityDefinition>();
        ArrayList<UniqueKeyDefinition> allUniqueKeys = new ArrayList<UniqueKeyDefinition>();
        ArrayList<ForeignKeyDefinition> allForeignKeys = new ArrayList<ForeignKeyDefinition>();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                IdentityDefinition identity = table.getIdentity();
                if (identity == null) continue;
                String identityType = out.ref(this.getStrategy().getFullJavaClassName(identity.getColumn().getContainer(), GeneratorStrategy.Mode.RECORD));
                String columnType = out.ref(this.getJavaType(identity.getColumn().getType()));
                String identityId = this.getStrategy().getJavaIdentifier(identity.getColumn().getContainer());
                int block = allIdentities.size() / 500;
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("val IDENTITY_%s = Identities%s.IDENTITY_%s", identityId, block, identityId);
                } else {
                    ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> IDENTITY_%s = Identities%s.IDENTITY_%s;", Identity.class, identityType, columnType, identityId, block, identityId);
                }
                allIdentities.add(identity);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).header("UNIQUE and PRIMARY KEY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List uniqueKeys = table.getUniqueKeys();
                for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                    keyType = out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD));
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)uniqueKey);
                    int block = allUniqueKeys.size() / 500;
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = UniqueKeys%s.%s", keyId, block, keyId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = UniqueKeys%s.%s;", UniqueKey.class, keyType, keyId, block, keyId);
                    }
                    allUniqueKeys.add(uniqueKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).header("FOREIGN KEY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List foreignKeys = table.getForeignKeys();
                for (ForeignKeyDefinition foreignKey : foreignKeys) {
                    keyType = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD));
                    String referencedType = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD));
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)foreignKey);
                    int block = allForeignKeys.size() / 500;
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = ForeignKeys%s.%s", keyId, block, keyId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> %s = ForeignKeys%s.%s;", ForeignKey.class, keyType, referencedType, keyId, block, keyId);
                    }
                    allForeignKeys.add(foreignKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating reference " + table), (Throwable)e);
            }
        }
        int identityCounter = 0;
        int uniqueKeyCounter = 0;
        int foreignKeyCounter = 0;
        ((JavaWriter)out.tab(1)).header("[#1459] distribute members to avoid static initialisers > 64kb", new Object[0]);
        for (IdentityDefinition identity : allIdentities) {
            this.printIdentity(out, identityCounter, identity);
            ++identityCounter;
        }
        if (identityCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (UniqueKeyDefinition uniqueKey : allUniqueKeys) {
            this.printUniqueKey(out, uniqueKeyCounter, uniqueKey);
            ++uniqueKeyCounter;
        }
        if (uniqueKeyCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (ForeignKeyDefinition foreignKey : allForeignKeys) {
            this.printForeignKey(out, foreignKeyCounter, foreignKey);
            ++foreignKeyCounter;
        }
        if (foreignKeyCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Keys generated");
    }

    protected void printIdentity(JavaWriter out, int identityCounter, IdentityDefinition identity) {
        int block = identityCounter / 500;
        if (identityCounter % 500 == 0) {
            if (identityCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object Identities%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class Identities%s extends %s {", block, AbstractKeys.class);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s[%s, %s] = %s.createIdentity(%s, %s)", this.getStrategy().getJavaIdentifier((Definition)identity), Identity.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)identity.getTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getJavaType(identity.getColumn().getType())), AbstractKeys.class, out.ref(this.getStrategy().getFullJavaIdentifier(identity.getColumn().getContainer()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)identity.getColumn()), this.colRefSegments((TypedElementDefinition<?>)identity.getColumn())));
        } else {
            ((JavaWriter)out.tab(2)).println("public static %s<%s, %s> %s = createIdentity(%s, %s);", Identity.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)identity.getTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getJavaType(identity.getColumn().getType())), this.getStrategy().getJavaIdentifier((Definition)identity), out.ref(this.getStrategy().getFullJavaIdentifier(identity.getColumn().getContainer()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)identity.getColumn()), this.colRefSegments((TypedElementDefinition<?>)identity.getColumn())));
        }
    }

    protected void printUniqueKey(JavaWriter out, int uniqueKeyCounter, UniqueKeyDefinition uniqueKey) {
        int block = uniqueKeyCounter / 500;
        if (uniqueKeyCounter % 500 == 0) {
            if (uniqueKeyCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object UniqueKeys%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class UniqueKeys%s extends %s {", block, AbstractKeys.class);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s[%s] = %s.createUniqueKey(%s, \"%s\", [[%s]])", this.getStrategy().getJavaIdentifier((Definition)uniqueKey), UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)), AbstractKeys.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), this.escapeString(uniqueKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)));
        } else {
            ((JavaWriter)out.tab(2)).println("public static final %s<%s> %s = createUniqueKey(%s, \"%s\", [[%s]]);", UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaIdentifier((Definition)uniqueKey), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), this.escapeString(uniqueKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)));
        }
    }

    protected void printForeignKey(JavaWriter out, int foreignKeyCounter, ForeignKeyDefinition foreignKey) {
        int block = foreignKeyCounter / 500;
        if (foreignKeyCounter % 500 == 0) {
            if (foreignKeyCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object ForeignKeys%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class ForeignKeys%s extends %s {", block, AbstractKeys.class);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s[%s, %s] = %s.createForeignKey(%s, %s, \"%s\", [[%s]])", this.getStrategy().getJavaIdentifier((Definition)foreignKey), ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)), AbstractKeys.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), this.escapeString(foreignKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)));
        } else {
            ((JavaWriter)out.tab(2)).println("public static final %s<%s, %s> %s = createForeignKey(%s, %s, \"%s\", [[%s]]);", ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaIdentifier((Definition)foreignKey), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), this.escapeString(foreignKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)));
        }
    }

    protected void generateRecords(SchemaDefinition schema) {
        log.info((Object)"Generating table records");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateRecord(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateRecord(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating record", (Object)out.file().getName());
        this.generateRecord(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTRecord(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)udt, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating record", (Object)out.file().getName());
        this.generateRecord((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateRecord(TableDefinition table, JavaWriter out) {
        this.generateRecord((Definition)table, out);
    }

    protected void generateUDTRecord(UDTDefinition udt, JavaWriter out) {
        this.generateRecord((Definition)udt, out);
    }

    private void generateRecord(Definition tableOrUdt, JavaWriter out) {
        int keyDegree;
        TypedElementDefinition<? extends Definition> column;
        UniqueKeyDefinition key = tableOrUdt instanceof TableDefinition ? ((TableDefinition)tableOrUdt).getPrimaryKey() : null;
        String className = this.getStrategy().getJavaClassName(tableOrUdt, GeneratorStrategy.Mode.RECORD);
        String tableIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier(tableOrUdt), 2);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableOrUdt, GeneratorStrategy.Mode.RECORD));
        List<? extends TypedElementDefinition<? extends Definition>> columns = this.getTypedElements(tableOrUdt);
        this.printPackage(out, tableOrUdt, GeneratorStrategy.Mode.RECORD);
        if (tableOrUdt instanceof TableDefinition) {
            this.generateRecordClassJavadoc((TableDefinition)tableOrUdt, out);
        } else {
            this.generateUDTRecordClassJavadoc((UDTDefinition)tableOrUdt, out);
        }
        this.printClassAnnotations(out, tableOrUdt.getSchema());
        if (tableOrUdt instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableOrUdt);
        }
        Class baseClass = tableOrUdt instanceof UDTDefinition ? UDTRecordImpl.class : (this.generateRelations() && key != null ? UpdatableRecordImpl.class : TableRecordImpl.class);
        int degree = columns.size();
        String rowType = null;
        String rowTypeRecord = null;
        if (degree > 0 && degree <= 22) {
            rowType = this.refRowType(out, columns);
            rowTypeRecord = this.scala ? out.ref(Record.class.getName() + degree) + "[" + rowType + "]" : out.ref(Record.class.getName() + degree) + "<" + rowType + ">";
            interfaces.add(rowTypeRecord);
        }
        if (this.generateInterfaces()) {
            interfaces.add(out.ref(this.getStrategy().getFullJavaClassName(tableOrUdt, GeneratorStrategy.Mode.INTERFACE)));
        }
        if (this.scala) {
            out.println("class %s extends %s[%s](%s)[[before= with ][separator= with ][%s]] {", className, baseClass, className, tableIdentifier, interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, baseClass, className, interfaces);
        }
        out.printSerial();
        for (int i = 0; i < degree; ++i) {
            boolean isUDTArray;
            column = columns.get(i);
            String comment = StringUtils.defaultString((String)column.getComment());
            String setterReturnType = this.fluentSetters() ? className : this.tokenVoid;
            String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
            String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
            String type = out.ref(this.getJavaType(column.getType()));
            String name = column.getQualifiedOutputName();
            boolean isUDT = column.getType().isUDT();
            boolean isArray = column.getType().isArray();
            boolean bl = isUDTArray = column.getType().isArray() && this.database.getArray(column.getType().getSchema(), column.getType().getUserType()).getElementType().isUDT();
            if (!this.generateInterfaces() || !isArray) {
                ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("def %s(value : %s) : %s = {", setter, type, setterReturnType);
                    ((JavaWriter)out.tab(2)).println("set(%s, value)", i);
                    if (this.fluentSetters()) {
                        ((JavaWriter)out.tab(2)).println("this");
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces() && !this.generateImmutablePojos() && !isUDT);
                    ((JavaWriter)out.tab(1)).println("public %s %s(%s value) {", setterReturnType, setter, type);
                    ((JavaWriter)out.tab(2)).println("set(%s, value);", i);
                    if (this.fluentSetters()) {
                        ((JavaWriter)out.tab(2)).println("return this;");
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if (this.generateInterfaces() && !this.generateImmutablePojos() && (isUDT || isArray)) {
                String columnType = out.ref(this.getJavaType(column.getType(), GeneratorStrategy.Mode.RECORD));
                String columnTypeInterface = out.ref(this.getJavaType(column.getType(), GeneratorStrategy.Mode.INTERFACE));
                ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
                ((JavaWriter)out.tab(1)).override();
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("def %s(value : %s) : %s = {", setter, columnTypeInterface, setterReturnType);
                    ((JavaWriter)out.tab(2)).println("if (value == null)");
                    ((JavaWriter)out.tab(3)).println("set(%s, null)", i);
                    ((JavaWriter)out.tab(2)).println("else");
                    ((JavaWriter)out.tab(3)).println("set(%s, value.into(new %s()))", i, type);
                    if (this.fluentSetters()) {
                        ((JavaWriter)out.tab(2)).println("this");
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).println("public %s %s(%s value) {", setterReturnType, setter, columnTypeInterface);
                    ((JavaWriter)out.tab(2)).println("if (value == null)");
                    ((JavaWriter)out.tab(3)).println("set(%s, null);", i);
                    if (isUDT) {
                        ((JavaWriter)out.tab(2)).println("else");
                        ((JavaWriter)out.tab(3)).println("set(%s, value.into(new %s()));", i, type);
                    } else if (isArray) {
                        ArrayDefinition array = this.database.getArray(column.getType().getSchema(), column.getType().getUserType());
                        String componentType = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.RECORD));
                        String componentTypeInterface = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.INTERFACE));
                        ((JavaWriter)out.tab(2)).println("else {");
                        ((JavaWriter)out.tab(3)).println("%s a = new %s();", columnType, columnType);
                        out.println();
                        ((JavaWriter)out.tab(3)).println("for (%s i : value)", componentTypeInterface);
                        if (isUDTArray) {
                            ((JavaWriter)out.tab(4)).println("a.add(i.into(new %s()));", componentType);
                        } else {
                            ((JavaWriter)out.tab(4)).println("a.add(i);", componentType);
                        }
                        out.println();
                        ((JavaWriter)out.tab(3)).println("set(1, a);");
                        ((JavaWriter)out.tab(2)).println("}");
                    }
                    if (this.fluentSetters()) {
                        ((JavaWriter)out.tab(2)).println("return this;");
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            if (tableOrUdt instanceof TableDefinition) {
                this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
            }
            this.printValidationAnnotation(out, column);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s : %s = {", getter, type);
                ((JavaWriter)out.tab(2)).println("val r = get(%s)", i);
                ((JavaWriter)out.tab(2)).println("if (r == null) null else r.asInstanceOf[%s]", type);
                ((JavaWriter)out.tab(1)).println("}");
                continue;
            }
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
            ((JavaWriter)out.tab(1)).println("public %s %s() {", type, getter);
            ((JavaWriter)out.tab(2)).println("return (%s) get(%s);", type, i);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateRelations() && key != null && (keyDegree = key.getKeyColumns().size()) <= 22) {
            String keyType = this.refRowType(out, key.getKeyColumns());
            ((JavaWriter)out.tab(1)).header("Primary key information", new Object[0]);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("override def key() : %s[%s] = {", out.ref(Record.class.getName() + keyDegree), keyType);
                ((JavaWriter)out.tab(2)).println("return super.key.asInstanceOf[ %s[%s] ]", out.ref(Record.class.getName() + keyDegree), keyType);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> key() {", out.ref(Record.class.getName() + keyDegree), keyType);
                ((JavaWriter)out.tab(2)).println("return (%s) super.key();", out.ref(Record.class.getName() + keyDegree));
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (tableOrUdt instanceof UDTDefinition) {
            for (RoutineDefinition routine : ((UDTDefinition)tableOrUdt).getRoutines()) {
                boolean instance = routine.getInParameters().size() > 0 && ((ParameterDefinition)routine.getInParameters().get(0)).getInputName().toUpperCase().equals("SELF");
                try {
                    if (!routine.isSQLUsable()) {
                        this.printConvenienceMethodProcedure(out, routine, instance);
                        continue;
                    }
                    if (routine.isAggregate()) continue;
                    this.printConvenienceMethodFunction(out, routine, instance);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                }
            }
        }
        if (degree > 0 && degree <= 22) {
            String colType;
            int i;
            ((JavaWriter)out.tab(1)).header("Record%s type implementation", degree);
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def fieldsRow : %s[%s] = {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("super.fieldsRow.asInstanceOf[ %s[%s] ]", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> fieldsRow() {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("return (%s) super.fieldsRow();", out.ref(Row.class.getName() + degree));
                ((JavaWriter)out.tab(1)).println("}");
            }
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def valuesRow : %s[%s] = {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("super.valuesRow.asInstanceOf[ %s[%s] ]", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> valuesRow() {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("return (%s) super.valuesRow();", out.ref(Row.class.getName() + degree));
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                colType = out.ref(this.getJavaType(column.getType()));
                String colIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments(column));
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("override def field%s : %s[%s] = %s", i, Field.class, colType, colIdentifier);
                    continue;
                }
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> field%s() {", Field.class, colType, i);
                ((JavaWriter)out.tab(2)).println("return %s;", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                colType = out.ref(this.getJavaType(column.getType()));
                String colGetter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("override def value%s : %s = %s", i, colType, colGetter);
                    continue;
                }
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s value%s() {", colType, i);
                ((JavaWriter)out.tab(2)).println("return %s();", colGetter);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                colType = out.ref(this.getJavaType(column.getType()));
                String colSetter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def value%s(value : %s) : %s = {", i, colType, className);
                    ((JavaWriter)out.tab(2)).println("%s(value)", colSetter);
                    ((JavaWriter)out.tab(2)).println("this");
                    ((JavaWriter)out.tab(1)).println("}");
                    continue;
                }
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s value%s(%s value) {", className, i, colType);
                ((JavaWriter)out.tab(2)).println("%s(value);", colSetter);
                ((JavaWriter)out.tab(2)).println("return this;");
                ((JavaWriter)out.tab(1)).println("}");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            ArrayList<String> calls = new ArrayList<String>();
            for (int i2 = 1; i2 <= degree; ++i2) {
                TypedElementDefinition<? extends Definition> column2 = columns.get(i2 - 1);
                String colType2 = out.ref(this.getJavaType(column2.getType()));
                if (this.scala) {
                    arguments.add("value" + i2 + " : " + colType2);
                    calls.add("this.value" + i2 + "(value" + i2 + ")");
                    continue;
                }
                arguments.add(colType2 + " value" + i2);
                calls.add("value" + i2 + "(value" + i2 + ");");
            }
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def values([[%s]]) : %s = {", arguments, className);
                for (String call : calls) {
                    ((JavaWriter)out.tab(2)).println(call);
                }
                ((JavaWriter)out.tab(2)).println("this");
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s values([[%s]]) {", className, arguments);
                for (String call : calls) {
                    ((JavaWriter)out.tab(2)).println(call);
                }
                ((JavaWriter)out.tab(2)).println("return this;");
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (this.generateInterfaces() && !this.generateImmutablePojos()) {
            this.printFromAndInto(out, tableOrUdt);
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).header("Constructors", new Object[0]);
            ((JavaWriter)out.tab(1)).javadoc("Create a detached %s", className);
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(%s);", tableIdentifier);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (degree > 0 && degree < 256) {
            String columnMember;
            TypedElementDefinition<? extends Definition> column3;
            int i;
            ArrayList<String> arguments = new ArrayList<String>();
            for (i = 0; i < degree; ++i) {
                column3 = columns.get(i);
                columnMember = this.getStrategy().getJavaMemberName((Definition)column3, GeneratorStrategy.Mode.DEFAULT);
                String type = out.ref(this.getJavaType(column3.getType()));
                if (this.scala) {
                    arguments.add(columnMember + " : " + type);
                    continue;
                }
                arguments.add(type + " " + columnMember);
            }
            ((JavaWriter)out.tab(1)).javadoc("Create a detached, initialised %s", className);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def this([[%s]]) = {", arguments);
                ((JavaWriter)out.tab(2)).println("this()", tableIdentifier);
            } else {
                ((JavaWriter)out.tab(1)).println("public %s([[%s]]) {", className, arguments);
                ((JavaWriter)out.tab(2)).println("super(%s);", tableIdentifier);
            }
            out.println();
            for (i = 0; i < degree; ++i) {
                column3 = columns.get(i);
                columnMember = this.getStrategy().getJavaMemberName((Definition)column3, GeneratorStrategy.Mode.DEFAULT);
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("set(%s, %s)", i, columnMember);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("set(%s, %s);", i, columnMember);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (tableOrUdt instanceof TableDefinition) {
            this.generateRecordClassFooter((TableDefinition)tableOrUdt, out);
        } else {
            this.generateUDTRecordClassFooter((UDTDefinition)tableOrUdt, out);
        }
        out.println("}");
    }

    private int colRefSegments(TypedElementDefinition<?> column) {
        if (column != null && column.getContainer() instanceof UDTDefinition) {
            return 2;
        }
        if (!this.getStrategy().getInstanceFields()) {
            return 2;
        }
        return 3;
    }

    protected void generateRecordClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateRecordClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    private final String refRowType(JavaWriter out, Collection<? extends TypedElementDefinition<?>> columns) {
        StringBuilder result = new StringBuilder();
        String separator = "";
        for (TypedElementDefinition<?> column : columns) {
            result.append(separator);
            result.append(out.ref(this.getJavaType(column.getType())));
            separator = ", ";
        }
        return result.toString();
    }

    protected void generateInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating table interfaces");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateInterface(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table interface " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table interfaces generated");
    }

    protected void generateInterface(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTInterface(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)udt, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateInterface(TableDefinition table, JavaWriter out) {
        this.generateInterface((Definition)table, out);
    }

    protected void generateUDTInterface(UDTDefinition udt, JavaWriter out) {
        this.generateInterface((Definition)udt, out);
    }

    private void generateInterface(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
        this.printPackage(out, tableOrUDT, GeneratorStrategy.Mode.INTERFACE);
        if (tableOrUDT instanceof TableDefinition) {
            this.generateInterfaceClassJavadoc((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTInterfaceClassJavadoc((UDTDefinition)tableOrUDT, out);
        }
        this.printClassAnnotations(out, tableOrUDT.getSchema());
        if (tableOrUDT instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableOrUDT);
        }
        if (this.scala) {
            out.println("trait %s [[before=extends ][%s]] {", className, interfaces);
        } else {
            out.println("public interface %s [[before=extends ][%s]] {", className, interfaces);
        }
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            String comment = StringUtils.defaultString((String)typedElementDefinition.getComment());
            String setterReturnType = this.fluentSetters() ? className : "void";
            String setter = this.getStrategy().getJavaSetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            String getter = this.getStrategy().getJavaGetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            String type = out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.INTERFACE));
            String name = typedElementDefinition.getQualifiedOutputName();
            if (!this.generateImmutablePojos()) {
                ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("def %s(value : %s) : %s", setter, type, setterReturnType);
                } else {
                    ((JavaWriter)out.tab(1)).println("public %s %s(%s value);", setterReturnType, setter, type);
                }
            }
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            if (typedElementDefinition instanceof ColumnDefinition) {
                this.printColumnJPAAnnotation(out, (ColumnDefinition)typedElementDefinition);
            }
            this.printValidationAnnotation(out, typedElementDefinition);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s : %s", getter, type);
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public %s %s();", type, getter);
        }
        if (!this.generateImmutablePojos()) {
            String local = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE);
            String string = out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
            ((JavaWriter)out.tab(1)).header("FROM and INTO", new Object[0]);
            ((JavaWriter)out.tab(1)).javadoc("Load data from another generated Record/POJO implementing the common interface %s", local);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def from(from : %s)", string);
            } else {
                ((JavaWriter)out.tab(1)).println("public void from(%s from);", string);
            }
            ((JavaWriter)out.tab(1)).javadoc("Copy data into another generated Record/POJO implementing the common interface %s", local);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def into [E <: %s](into : E) : E", string);
            } else {
                ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into);", string);
            }
        }
        if (tableOrUDT instanceof TableDefinition) {
            this.generateInterfaceClassFooter((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTInterfaceClassFooter((UDTDefinition)tableOrUDT, out);
        }
        out.println("}");
    }

    protected void generateInterfaceClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateInterfaceClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generateUDTs(SchemaDefinition schema) {
        log.info((Object)"Generating UDTs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDT(schema, udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating udt " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDTs generated");
    }

    protected void generateUDT(SchemaDefinition schema, UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)udt));
        log.info((Object)"Generating UDT ", (Object)out.file().getName());
        this.generateUDT(udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDT(UDTDefinition udt, JavaWriter out) {
        SchemaDefinition schema = udt.getSchema();
        String className = this.getStrategy().getJavaClassName((Definition)udt);
        String recordType = out.ref(this.getStrategy().getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)udt, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        String udtId = out.ref(this.getStrategy().getJavaIdentifier((Definition)udt), 2);
        this.printPackage(out, (Definition)udt);
        if (this.scala) {
            out.println("object %s {", className);
            this.printSingletonInstance(out, (Definition)udt);
            for (AttributeDefinition attribute : udt.getAttributes()) {
                String attrId = out.ref(this.getStrategy().getJavaIdentifier((Definition)attribute), 2);
                String attrComment = StringUtils.defaultString((String)attribute.getComment());
                ((JavaWriter)out.tab(1)).javadoc("The attribute <code>%s</code>.%s", attribute.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + attrComment), (String)""));
                ((JavaWriter)out.tab(1)).println("val %s = %s.%s", attrId, udtId, attrId);
            }
            out.println("}");
            out.println();
        }
        this.generateUDTClassJavadoc(udt, out);
        this.printClassAnnotations(out, schema);
        if (udt.getRoutines().size() > 0) {
            interfaces.add(out.ref(Package.class));
        }
        if (this.scala) {
            out.println("class %s extends %s[%s](\"%s\", null)[[before= with ][separator= with ][%s]] {", className, UDTImpl.class, recordType, udt.getOutputName(), interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, UDTImpl.class, recordType, interfaces);
            out.printSerial();
            this.printSingletonInstance(out, (Definition)udt);
        }
        this.printRecordTypeMethod(out, (Definition)udt);
        for (AttributeDefinition attribute : udt.getAttributes()) {
            String attrType = out.ref(this.getJavaType(attribute.getType()));
            String attrTypeRef = this.getJavaTypeReference(attribute.getDatabase(), attribute.getType());
            String attrId = out.ref(this.getStrategy().getJavaIdentifier((Definition)attribute), 2);
            String attrName = attribute.getName();
            String attrComment = StringUtils.defaultString((String)attribute.getComment());
            List<String> converters = out.ref(JavaGenerator.list(attribute.getType().getConverter(), attribute.getType().getBinding()));
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private val %s : %s[%s, %s] = %s.createField(\"%s\", %s, this, \"%s\"[[before=, ][new %s]])", attrId, UDTField.class, recordType, attrType, UDTImpl.class, attrName, attrTypeRef, this.escapeString(""), converters);
                continue;
            }
            ((JavaWriter)out.tab(1)).javadoc("The attribute <code>%s</code>.%s", attribute.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + attrComment), (String)""));
            ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> %s = createField(\"%s\", %s, %s, \"%s\"[[before=, ][new %s()]]);", UDTField.class, recordType, attrType, attrId, attrName, attrTypeRef, udtId, this.escapeString(""), converters);
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, false);
                    continue;
                }
                if (!routine.isAggregate()) {
                    this.printConvenienceMethodFunction(out, routine, false);
                }
                this.printConvenienceMethodFunctionAsField(out, routine, false);
                this.printConvenienceMethodFunctionAsField(out, routine, true);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\", null);", udt.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override def getSchema : %s = %s", Schema.class, schemaId);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
            ((JavaWriter)out.tab(2)).println("return %s;", schemaId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.generateUDTClassFooter(udt, out);
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generateUDTClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTPojos(SchemaDefinition schema) {
        log.info((Object)"Generating UDT POJOs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTPojo(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT POJO " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT POJOs generated");
    }

    protected void generateUDTPojoClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTPojoClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating UDT interfaces");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTInterface(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT interface " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT interfaces generated");
    }

    protected void generateUDTInterfaceClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTInterfaceClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTRecords(SchemaDefinition schema) {
        log.info((Object)"Generating UDT records");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTRecord(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT records generated");
    }

    protected void generateUDTRecordClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTRecordClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTRoutines(SchemaDefinition schema) {
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            if (udt.getRoutines().size() <= 0) continue;
            try {
                log.info((Object)"Generating member routines");
                for (RoutineDefinition routine : udt.getRoutines()) {
                    try {
                        this.generateRoutine(schema, routine);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
            }
            this.watch.splitInfo("Member procedures routines");
        }
    }

    protected void generateUDTReferences(SchemaDefinition schema) {
        log.info((Object)"Generating UDT references");
        JavaWriter out = this.newJavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "UDTs.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all UDTs in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object UDTs {");
        } else {
            out.println("public class UDTs {");
        }
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)udt));
            String id = this.getStrategy().getJavaIdentifier((Definition)udt);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)udt);
            ((JavaWriter)out.tab(1)).javadoc("The type <code>%s</code>", udt.getQualifiedOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("val %s = %s", id, fullId);
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public static %s %s = %s;", className, id, fullId);
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("UDT references generated");
    }

    protected void generateArrays(SchemaDefinition schema) {
        log.info((Object)"Generating ARRAYs");
        for (ArrayDefinition array : this.database.getArrays(schema)) {
            try {
                this.generateArray(schema, array);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
            }
        }
        this.watch.splitInfo("ARRAYs generated");
    }

    protected void generateArray(SchemaDefinition schema, ArrayDefinition array) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)array, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating ARRAY", (Object)out.file().getName());
        this.generateArray(array, out);
        this.closeJavaWriter(out);
    }

    protected void generateArray(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateArrayClassFooter(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateArrayClassJavadoc(ArrayDefinition array, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)array);
    }

    protected void generateEnums(SchemaDefinition schema) {
        log.info((Object)"Generating ENUMs");
        for (EnumDefinition e : this.database.getEnums(schema)) {
            try {
                this.generateEnum(e);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating enum " + e), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Enums generated");
    }

    protected void generateDomains(SchemaDefinition schema) {
        log.info((Object)"Generating DOMAINs");
        for (DomainDefinition d : this.database.getDomains(schema)) {
            try {
                this.generateDomain(d);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating domain " + d), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Domains generated");
    }

    protected void generateEnum(EnumDefinition e) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)e, GeneratorStrategy.Mode.ENUM));
        log.info((Object)"Generating ENUM", (Object)out.file().getName());
        this.generateEnum(e, out);
        this.closeJavaWriter(out);
    }

    protected void generateEnum(EnumDefinition e, JavaWriter out) {
        int i;
        String className = this.getStrategy().getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)e, GeneratorStrategy.Mode.ENUM));
        List literals = e.getLiterals();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (i = 0; i < literals.size(); ++i) {
            String identifier = GenerationUtil.convertToIdentifier((String)literals.get(i), this.language);
            if (identifier.equals(this.getStrategy().getJavaPackageName((Definition)e).replaceAll("\\..*", ""))) {
                identifier = identifier + "_";
            }
            identifiers.add(identifier);
        }
        this.printPackage(out, (Definition)e);
        this.generateEnumClassJavadoc(e, out);
        this.printClassAnnotations(out, e.getSchema());
        if (this.scala) {
            out.println("object %s {", className);
            out.println();
            for (i = 0; i < identifiers.size(); ++i) {
                ((JavaWriter)out.tab(1)).println("val %s : %s = %s.%s", identifiers.get(i), className, this.getStrategy().getJavaPackageName((Definition)e), identifiers.get(i));
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("def values() : %s[%s] = %s(", out.ref("scala.Array"), className, out.ref("scala.Array"));
            for (i = 0; i < identifiers.size(); ++i) {
                ((JavaWriter)out.tab(2)).print(i > 0 ? ", " : "  ");
                out.println((String)identifiers.get(i));
            }
            ((JavaWriter)out.tab(1)).println(")");
            out.println();
            ((JavaWriter)out.tab(1)).println("def valueOf(s : %s) : %s = s match {", String.class, className);
            for (i = 0; i < identifiers.size(); ++i) {
                ((JavaWriter)out.tab(2)).println("case \"%s\" => %s", literals.get(i), identifiers.get(i));
            }
            ((JavaWriter)out.tab(2)).println("case _ => throw new %s()", IllegalArgumentException.class);
            ((JavaWriter)out.tab(1)).println("}");
            out.println("}");
            out.println();
            out.println("sealed trait %s extends %s[[before= with ][%s]] {", className, EnumType.class, interfaces);
            ((JavaWriter)out.tab(1)).println("override def getSchema : %s = %s", Schema.class, e.isSynthetic() || !(e.getDatabase() instanceof PostgresDatabase) ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            ((JavaWriter)out.tab(1)).println("override def getName : %s = %s", String.class, e.isSynthetic() ? "null" : "\"" + e.getName().replace("\"", "\\\"") + "\"");
            this.generateEnumClassFooter(e, out);
            out.println("}");
            for (i = 0; i < literals.size(); ++i) {
                out.println();
                out.println("case object %s extends %s {", identifiers.get(i), className);
                ((JavaWriter)out.tab(1)).println("override def getLiteral : %s = \"%s\"", String.class, literals.get(i));
                out.println("}");
            }
        } else {
            interfaces.add(out.ref(EnumType.class));
            out.println("public enum %s[[before= implements ][%s]] {", className, interfaces);
            for (i = 0; i < literals.size(); ++i) {
                out.println();
                ((JavaWriter)out.tab(1)).println("%s(\"%s\")%s", identifiers.get(i), literals.get(i), i == literals.size() - 1 ? ";" : ",");
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("private final %s literal;", String.class);
            out.println();
            ((JavaWriter)out.tab(1)).println("private %s(%s literal) {", className, String.class);
            ((JavaWriter)out.tab(2)).println("this.literal = literal;");
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
            ((JavaWriter)out.tab(2)).println("return %s;", e.isSynthetic() || !(e.getDatabase() instanceof PostgresDatabase) ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getName() {", String.class);
            ((JavaWriter)out.tab(2)).println("return %s;", e.isSynthetic() ? "null" : "\"" + e.getName().replace("\"", "\\\"") + "\"");
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getLiteral() {", String.class);
            ((JavaWriter)out.tab(2)).println("return literal;");
            ((JavaWriter)out.tab(1)).println("}");
            this.generateEnumClassFooter(e, out);
            out.println("}");
        }
    }

    protected void generateEnumClassFooter(EnumDefinition e, JavaWriter out) {
    }

    protected void generateEnumClassJavadoc(EnumDefinition e, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)e);
    }

    protected void generateDomain(DomainDefinition d) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)d, GeneratorStrategy.Mode.DOMAIN));
        log.info((Object)"Generating DOMAIN", (Object)out.file().getName());
        this.generateDomain(d, out);
        this.closeJavaWriter(out);
    }

    protected void generateDomain(DomainDefinition d, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName((Definition)d, GeneratorStrategy.Mode.DOMAIN);
        String superName = out.ref(this.getStrategy().getJavaClassExtends((Definition)d, GeneratorStrategy.Mode.DOMAIN));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)d, GeneratorStrategy.Mode.DOMAIN));
        List<String> superTypes = JavaGenerator.list(superName, interfaces);
        this.printPackage(out, (Definition)d);
        this.generateDomainClassJavadoc(d, out);
        this.printClassAnnotations(out, d.getSchema());
        for (String clause : d.getCheckClauses()) {
            out.println("// " + clause);
        }
        if (this.scala) {
            out.println("class %s[[before= extends ][%s]][[before= with ][separator= with ][%s]] {", className, JavaGenerator.first(superTypes), JavaGenerator.remaining(superTypes));
        } else {
            out.println("public class %s[[before= extends ][%s]][[before= implements ][%s]] {", className, JavaGenerator.list(superName), interfaces);
        }
        this.generateDomainClassFooter(d, out);
        out.println("}");
    }

    protected void generateDomainClassFooter(DomainDefinition d, JavaWriter out) {
    }

    protected void generateDomainClassJavadoc(DomainDefinition e, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)e);
    }

    protected void generateRoutines(SchemaDefinition schema) {
        log.info((Object)"Generating routines and table-valued functions");
        JavaWriter out = this.newJavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Routines.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Routines {");
        } else {
            out.println("public class Routines {");
        }
        for (RoutineDefinition routine : this.database.getRoutines(schema)) {
            this.printRoutine(out, routine);
            try {
                this.generateRoutine(schema, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        for (TableDefinition table : this.database.getTables(schema)) {
            if (!table.isTableValuedFunction()) continue;
            this.printTableValuedFunction(out, table, this.getStrategy().getJavaMethodName((Definition)table, GeneratorStrategy.Mode.DEFAULT));
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Routines generated");
    }

    protected void printConstant(JavaWriter out, AttributeDefinition constant) {
    }

    protected void printRoutine(JavaWriter out, RoutineDefinition routine) {
        if (!routine.isSQLUsable()) {
            this.printConvenienceMethodProcedure(out, routine, false);
        } else {
            if (!routine.isAggregate()) {
                this.printConvenienceMethodFunction(out, routine, false);
            }
            this.printConvenienceMethodFunctionAsField(out, routine, false);
            this.printConvenienceMethodFunctionAsField(out, routine, true);
        }
    }

    protected void printTableValuedFunction(JavaWriter out, TableDefinition table, String javaMethodName) {
        this.printConvenienceMethodTableValuedFunction(out, table, javaMethodName);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, false, javaMethodName);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, true, javaMethodName);
    }

    protected void generatePackages(SchemaDefinition schema) {
    }

    protected void generatePackage(SchemaDefinition schema, PackageDefinition pkg) {
    }

    protected void generatePackageClassFooter(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generatePackageClassJavadoc(PackageDefinition pkg, JavaWriter out) {
        this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + pkg.getName());
    }

    protected void generateTableReferences(SchemaDefinition schema) {
        log.info((Object)"Generating table references");
        JavaWriter out = this.newJavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Tables.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all tables in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Tables {");
        } else {
            out.println("public class Tables {");
        }
        for (TableDefinition table : this.database.getTables(schema)) {
            String comment;
            String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)table));
            String id = this.getStrategy().getJavaIdentifier((Definition)table);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)table);
            String string = comment = !StringUtils.isBlank((String)table.getComment()) ? table.getComment() : "The table <code>" + table.getQualifiedOutputName() + "</code>.";
            if (!(this.scala && table.isTableValuedFunction() && table.getParameters().isEmpty())) {
                ((JavaWriter)out.tab(1)).javadoc(comment, new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("val %s = %s", id, fullId);
                } else {
                    ((JavaWriter)out.tab(1)).println("public static final %s %s = %s;", className, id, fullId);
                }
            }
            if (!table.isTableValuedFunction()) continue;
            this.printTableValuedFunction(out, table, this.getStrategy().getJavaIdentifier((Definition)table));
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Table refs generated");
    }

    protected void generateDaos(SchemaDefinition schema) {
        log.info((Object)"Generating DAOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateDao(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table DAO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table DAOs generated");
    }

    protected void generateDao(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.DAO));
        log.info((Object)"Generating DAO", (Object)out.file().getName());
        this.generateDao(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateDao(TableDefinition table, JavaWriter out) {
        String separator;
        UniqueKeyDefinition key = table.getPrimaryKey();
        if (key == null) {
            log.info((Object)"Skipping DAO generation", (Object)out.file().getName());
            return;
        }
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DAO));
        String tableRecord = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        String daoImpl = out.ref(DAOImpl.class);
        String tableIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2);
        String tType = this.scala ? "Unit" : "Void";
        String pType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        List keyColumns = key.getKeyColumns();
        if (keyColumns.size() == 1) {
            tType = this.getJavaType(((ColumnDefinition)keyColumns.get(0)).getType());
        } else if (keyColumns.size() <= 22) {
            String generics = "";
            separator = "";
            for (ColumnDefinition column : keyColumns) {
                generics = generics + separator + out.ref(this.getJavaType(column.getType()));
                separator = ", ";
            }
            tType = this.scala ? Record.class.getName() + keyColumns.size() + "[" + generics + "]" : Record.class.getName() + keyColumns.size() + "<" + generics + ">";
        } else {
            tType = Record.class.getName();
        }
        tType = out.ref(tType);
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        this.generateDaoClassJavadoc(table, out);
        this.printClassAnnotations(out, table.getSchema());
        if (this.generateSpringAnnotations()) {
            out.println("@%s", out.ref("org.springframework.stereotype.Repository"));
        }
        if (this.scala) {
            out.println("class %s(configuration : %s) extends %s[%s, %s, %s](%s, classOf[%s], configuration)[[before= with ][separator= with ][%s]] {", className, Configuration.class, daoImpl, tableRecord, pType, tType, tableIdentifier, pType, interfaces);
        } else {
            out.println("public class %s extends %s<%s, %s, %s>[[before= implements ][%s]] {", className, daoImpl, tableRecord, pType, tType, interfaces);
        }
        ((JavaWriter)out.tab(1)).javadoc("Create a new %s without any configuration", className);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def this() = {");
            ((JavaWriter)out.tab(2)).println("this(null)");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(%s, %s.class);", tableIdentifier, pType);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Create a new %s with an attached configuration", className);
            if (this.generateSpringAnnotations()) {
                ((JavaWriter)out.tab(1)).println("@%s", out.ref("org.springframework.beans.factory.annotation.Autowired"));
            }
            ((JavaWriter)out.tab(1)).println("public %s(%s configuration) {", className, Configuration.class);
            ((JavaWriter)out.tab(2)).println("super(%s, %s.class, configuration);", tableIdentifier, pType);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override protected def getId(o : %s) : %s = {", pType, tType);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("protected %s getId(%s object) {", tType, pType);
        }
        if (keyColumns.size() == 1) {
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("o.%s", this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            } else {
                ((JavaWriter)out.tab(2)).println("return object.%s();", this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            }
        } else {
            String params = "";
            separator = "";
            for (ColumnDefinition column : keyColumns) {
                params = this.scala ? params + separator + "o." + this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO) : params + separator + "object." + this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO) + "()";
                separator = ", ";
            }
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("compositeKeyRecord(%s)", params);
            } else {
                ((JavaWriter)out.tab(2)).println("return compositeKeyRecord(%s);", params);
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
        block2: for (ColumnDefinition column : table.getColumns()) {
            String colName = column.getOutputName();
            String colClass = this.getStrategy().getJavaClassName((Definition)column);
            String colType = out.ref(this.getJavaType(column.getType()));
            String colIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            ((JavaWriter)out.tab(1)).javadoc("Fetch records that have <code>%s IN (values)</code>", colName);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def fetchBy%s(values : %s*) : %s[%s] = {", colClass, colType, List.class, pType);
                ((JavaWriter)out.tab(2)).println("fetch(%s, values:_*)", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).println("public %s<%s> fetchBy%s(%s... values) {", List.class, pType, colClass, colType);
                ((JavaWriter)out.tab(2)).println("return fetch(%s, values);", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (UniqueKeyDefinition uk : column.getUniqueKeys()) {
                if (uk.getKeyColumns().size() != 1 || !((ColumnDefinition)uk.getKeyColumns().get(0)).equals(column)) continue;
                ((JavaWriter)out.tab(1)).javadoc("Fetch a unique record that has <code>%s = value</code>", colName);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("def fetchOneBy%s(value : %s) : %s = {", colClass, colType, pType);
                    ((JavaWriter)out.tab(2)).println("fetchOne(%s, value)", colIdentifier);
                    ((JavaWriter)out.tab(1)).println("}");
                    continue block2;
                }
                ((JavaWriter)out.tab(1)).println("public %s fetchOneBy%s(%s value) {", pType, colClass, colType);
                ((JavaWriter)out.tab(2)).println("return fetchOne(%s, value);", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
                continue block2;
            }
        }
        this.generateDaoClassFooter(table, out);
        out.println("}");
    }

    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateDaoClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generatePojos(SchemaDefinition schema) {
        log.info((Object)"Generating table POJOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generatePojo(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table POJO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table POJOs generated");
    }

    protected void generatePojo(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTPojo(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)udt, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generatePojo(TableDefinition table, JavaWriter out) {
        this.generatePojo((Definition)table, out);
    }

    protected void generateUDTPojo(UDTDefinition udt, JavaWriter out) {
        this.generatePojo((Definition)udt, out);
    }

    private void generatePojo(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        String superName = out.ref(this.getStrategy().getJavaClassExtends(tableOrUDT, GeneratorStrategy.Mode.POJO));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableOrUDT, GeneratorStrategy.Mode.POJO));
        List<String> superTypes = JavaGenerator.list(superName, interfaces);
        if (this.generateInterfaces()) {
            interfaces.add(out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE)));
        }
        this.printPackage(out, tableOrUDT, GeneratorStrategy.Mode.POJO);
        if (tableOrUDT instanceof TableDefinition) {
            this.generatePojoClassJavadoc((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTPojoClassJavadoc((UDTDefinition)tableOrUDT, out);
        }
        this.printClassAnnotations(out, tableOrUDT.getSchema());
        if (tableOrUDT instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableOrUDT);
        }
        int maxLength = 0;
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            maxLength = Math.max(maxLength, out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)).length());
        }
        if (this.scala) {
            out.println("%sclass %s(", this.generateImmutablePojos() ? "case " : "", className);
            Object separator = "  ";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(1)).println("%s%s%s : %s", separator, this.generateImmutablePojos() ? "" : "private var ", this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)), (int)maxLength));
                separator = ", ";
            }
            out.println(")[[before= extends ][%s]][[before= with ][separator= with ][%s]] {", JavaGenerator.first(superTypes), JavaGenerator.remaining(superTypes));
        } else {
            out.println("public class %s[[before= extends ][%s]][[before= implements ][%s]] {", className, JavaGenerator.list(superName), interfaces);
            out.printSerial();
            out.println();
            for (TypedElementDefinition typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(1)).println("private %s%s %s;", this.generateImmutablePojos() ? "final " : "", StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
            }
        }
        if (!this.generateImmutablePojos()) {
            out.println();
            if (this.scala) {
                int size = this.getTypedElements(tableOrUDT).size();
                if (size > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                        if (size == 1) {
                            arrayList.add("null : " + out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)));
                            continue;
                        }
                        arrayList.add("null");
                    }
                    ((JavaWriter)out.tab(1)).println("def this() = {", className);
                    ((JavaWriter)out.tab(2)).println("this([[%s]])", arrayList);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            } else {
                ((JavaWriter)out.tab(1)).println("public %s() {}", className);
            }
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def this (value : %s) = {", className, className);
            ((JavaWriter)out.tab(2)).println("this(");
            Object separator = "  ";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(3)).println("%svalue.%s", separator, this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
                separator = ", ";
            }
            ((JavaWriter)out.tab(2)).println(")");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("public %s(%s value) {", className, className);
            for (TypedElementDefinition typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(2)).println("this.%s = value.%s;", this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (!this.scala && this.getTypedElements(tableOrUDT).size() > 0 && this.getTypedElements(tableOrUDT).size() < 256) {
            out.println();
            ((JavaWriter)out.tab(1)).print("public %s(", className);
            String separator1 = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                out.println(separator1);
                ((JavaWriter)out.tab(2)).print("%s %s", StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
                separator1 = ",";
            }
            out.println();
            ((JavaWriter)out.tab(1)).println(") {");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String string = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(2)).println("this.%s = %s;", string, string);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            String string = out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO));
            String string2 = this.fluentSetters() ? className : (this.scala ? "Unit" : "void");
            String columnSetter = this.getStrategy().getJavaSetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
            String columnGetter = this.getStrategy().getJavaGetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
            String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
            boolean isUDT = typedElementDefinition.getType().isUDT();
            boolean isUDTArray = typedElementDefinition.getType().isArray() && this.database.getArray(typedElementDefinition.getType().getSchema(), typedElementDefinition.getType().getUserType()).getElementType().isUDT();
            out.println();
            if (typedElementDefinition instanceof ColumnDefinition) {
                this.printColumnJPAAnnotation(out, (ColumnDefinition)typedElementDefinition);
            }
            this.printValidationAnnotation(out, typedElementDefinition);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s : %s = {", columnGetter, string);
                ((JavaWriter)out.tab(2)).println("this.%s", columnMember);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
                ((JavaWriter)out.tab(1)).println("public %s %s() {", string, columnGetter);
                ((JavaWriter)out.tab(2)).println("return this.%s;", columnMember);
                ((JavaWriter)out.tab(1)).println("}");
            }
            if (this.generateImmutablePojos()) continue;
            if (!this.generateInterfaces() || !isUDTArray) {
                out.println();
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("def %s(%s : %s) : %s = {", columnSetter, columnMember, string, string2);
                    ((JavaWriter)out.tab(2)).println("this.%s = %s", columnMember, columnMember);
                    if (this.fluentSetters()) {
                        ((JavaWriter)out.tab(2)).println("this");
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces() && !isUDT);
                    ((JavaWriter)out.tab(1)).println("public %s %s(%s %s) {", string2, columnSetter, string, columnMember);
                    ((JavaWriter)out.tab(2)).println("this.%s = %s;", columnMember, columnMember);
                    if (this.fluentSetters()) {
                        ((JavaWriter)out.tab(2)).println("return this;");
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if (!this.generateInterfaces() || !isUDT && !isUDTArray) continue;
            String columnTypeInterface = out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.INTERFACE));
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(%s : %s) : %s = {", columnSetter, columnMember, columnTypeInterface, string2);
                ((JavaWriter)out.tab(2)).println("if (%s == null)", columnMember);
                ((JavaWriter)out.tab(3)).println("this.%s = null", columnMember);
                ((JavaWriter)out.tab(2)).println("else");
                ((JavaWriter)out.tab(3)).println("this.%s = %s.into(new %s)", columnMember, columnMember, string);
                if (this.fluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
                continue;
            }
            ((JavaWriter)out.tab(1)).override();
            ((JavaWriter)out.tab(1)).println("public %s %s(%s %s) {", string2, columnSetter, columnTypeInterface, columnMember);
            ((JavaWriter)out.tab(2)).println("if (%s == null)", columnMember);
            ((JavaWriter)out.tab(3)).println("this.%s = null;", columnMember);
            if (isUDT) {
                ((JavaWriter)out.tab(2)).println("else");
                ((JavaWriter)out.tab(3)).println("this.%s = %s.into(new %s());", columnMember, columnMember, string);
            } else if (isUDTArray) {
                ArrayDefinition array = this.database.getArray(typedElementDefinition.getType().getSchema(), typedElementDefinition.getType().getUserType());
                String componentType = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.POJO));
                String componentTypeInterface = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.INTERFACE));
                ((JavaWriter)out.tab(2)).println("else {");
                ((JavaWriter)out.tab(3)).println("this.%s = new %s();", columnMember, ArrayList.class);
                out.println();
                ((JavaWriter)out.tab(3)).println("for (%s i : %s)", componentTypeInterface, columnMember);
                ((JavaWriter)out.tab(4)).println("this.%s.add(i.into(new %s()));", columnMember, componentType);
                ((JavaWriter)out.tab(2)).println("}");
            }
            if (this.fluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generatePojosEqualsAndHashCode()) {
            this.generatePojoEqualsAndHashCode(tableOrUDT, out);
        }
        if (this.generatePojosToString()) {
            this.generatePojoToString(tableOrUDT, out);
        }
        if (this.generateInterfaces() && !this.generateImmutablePojos()) {
            this.printFromAndInto(out, tableOrUDT);
        }
        if (tableOrUDT instanceof TableDefinition) {
            this.generatePojoClassFooter((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTPojoClassFooter((UDTDefinition)tableOrUDT, out);
        }
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generatePojoEqualsAndHashCode(Definition tableOrUDT, JavaWriter out) {
        String columnMember;
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def equals(obj : Any) : scala.Boolean = {");
            ((JavaWriter)out.tab(2)).println("if (this == obj)");
            ((JavaWriter)out.tab(3)).println("return true");
            ((JavaWriter)out.tab(2)).println("if (obj == null)");
            ((JavaWriter)out.tab(3)).println("return false");
            ((JavaWriter)out.tab(2)).println("if (getClass() != obj.getClass())");
            ((JavaWriter)out.tab(3)).println("return false");
            ((JavaWriter)out.tab(2)).println("val other = obj.asInstanceOf[%s]", className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(2)).println("if (%s == null) {", columnMember);
                ((JavaWriter)out.tab(3)).println("if (other.%s != null)", columnMember);
                ((JavaWriter)out.tab(4)).println("return false");
                ((JavaWriter)out.tab(2)).println("}");
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(%s, other.%s))", Arrays.class, columnMember, columnMember);
                } else {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(other.%s))", columnMember, columnMember);
                }
                ((JavaWriter)out.tab(3)).println("return false");
            }
            ((JavaWriter)out.tab(2)).println("return true");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("@Override");
            ((JavaWriter)out.tab(1)).println("public boolean equals(%s obj) {", Object.class);
            ((JavaWriter)out.tab(2)).println("if (this == obj)");
            ((JavaWriter)out.tab(3)).println("return true;");
            ((JavaWriter)out.tab(2)).println("if (obj == null)");
            ((JavaWriter)out.tab(3)).println("return false;");
            ((JavaWriter)out.tab(2)).println("if (getClass() != obj.getClass())");
            ((JavaWriter)out.tab(3)).println("return false;");
            ((JavaWriter)out.tab(2)).println("final %s other = (%s) obj;", className, className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(2)).println("if (%s == null) {", columnMember);
                ((JavaWriter)out.tab(3)).println("if (other.%s != null)", columnMember);
                ((JavaWriter)out.tab(4)).println("return false;");
                ((JavaWriter)out.tab(2)).println("}");
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(%s, other.%s))", Arrays.class, columnMember, columnMember);
                } else {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(other.%s))", columnMember, columnMember);
                }
                ((JavaWriter)out.tab(3)).println("return false;");
            }
            ((JavaWriter)out.tab(2)).println("return true;");
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def hashCode : Int = {");
            ((JavaWriter)out.tab(2)).println("val prime = 31");
            ((JavaWriter)out.tab(2)).println("var result = 1");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("result = prime * result + (if (%s == null) 0 else %s.hashCode(%s))", columnMember, Arrays.class, columnMember);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("result = prime * result + (if (%s == null) 0 else %s.hashCode())", columnMember, columnMember);
            }
            ((JavaWriter)out.tab(2)).println("return result");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("@Override");
            ((JavaWriter)out.tab(1)).println("public int hashCode() {");
            ((JavaWriter)out.tab(2)).println("final int prime = 31;");
            ((JavaWriter)out.tab(2)).println("int result = 1;");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("result = prime * result + ((%s == null) ? 0 : %s.hashCode(%s));", columnMember, Arrays.class, columnMember);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("result = prime * result + ((%s == null) ? 0 : %s.hashCode());", columnMember, columnMember);
            }
            ((JavaWriter)out.tab(2)).println("return result;");
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    protected void generatePojoToString(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def toString : String = {");
            ((JavaWriter)out.tab(2)).println("val sb = new %s(\"%s (\")", StringBuilder.class, className);
            ((JavaWriter)out.tab(2)).println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType());
                if (columnType.equals("scala.Array[scala.Byte]")) {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(\"[binary...]\")", separator);
                } else {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(%s)", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            ((JavaWriter)out.tab(2)).println();
            ((JavaWriter)out.tab(2)).println("sb.append(\")\");");
            ((JavaWriter)out.tab(2)).println("return sb.toString");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("@Override");
            ((JavaWriter)out.tab(1)).println("public String toString() {");
            ((JavaWriter)out.tab(2)).println("%s sb = new %s(\"%s (\");", StringBuilder.class, StringBuilder.class, className);
            ((JavaWriter)out.tab(2)).println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType());
                boolean array = columnType.endsWith("[]");
                if (array && columnType.equals("byte[]")) {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(\"[binary...]\");", separator);
                } else if (array) {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(%s.toString(%s));", separator, Arrays.class, columnMember);
                } else {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(%s);", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            ((JavaWriter)out.tab(2)).println();
            ((JavaWriter)out.tab(2)).println("sb.append(\")\");");
            ((JavaWriter)out.tab(2)).println("return sb.toString();");
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    private List<? extends TypedElementDefinition<? extends Definition>> getTypedElements(Definition definition) {
        if (definition instanceof TableDefinition) {
            return ((TableDefinition)definition).getColumns();
        }
        if (definition instanceof UDTDefinition) {
            return ((UDTDefinition)definition).getAttributes();
        }
        if (definition instanceof RoutineDefinition) {
            return ((RoutineDefinition)definition).getAllParameters();
        }
        throw new IllegalArgumentException("Unsupported type : " + definition);
    }

    protected void generatePojoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generatePojoClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generateTables(SchemaDefinition schema) {
        log.info((Object)"Generating tables");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateTable(schema, table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Tables generated");
    }

    protected void generateTable(SchemaDefinition schema, TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)table));
        this.generateTable(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateTable(TableDefinition table, JavaWriter out) {
        SchemaDefinition schema = table.getSchema();
        UniqueKeyDefinition primaryKey = table.getPrimaryKey();
        boolean updatable = this.generateRelations() && primaryKey != null;
        String className = this.getStrategy().getJavaClassName((Definition)table);
        String tableId = this.scala ? out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2) : this.getStrategy().getJavaIdentifier((Definition)table);
        String recordType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        String comment = StringUtils.defaultString((String)table.getComment());
        log.info((Object)"Generating table", (Object)(out.file().getName() + " [input=" + table.getInputName() + ", output=" + table.getOutputName() + ", pk=" + (primaryKey != null ? primaryKey.getName() : "N/A") + "]"));
        this.printPackage(out, (Definition)table);
        if (this.scala) {
            out.println("object %s {", className);
            this.printSingletonInstance(out, (Definition)table);
            out.println("}");
            out.println();
        }
        this.generateTableClassJavadoc(table, out);
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("class %s(alias : String, aliased : %s[%s], parameters : %s[ %s[_] ]) extends %s[%s](alias, %s, aliased, parameters, \"%s\")[[before= with ][separator= with ][%s]] {", className, Table.class, recordType, out.ref("scala.Array"), Field.class, TableImpl.class, recordType, schemaId, this.escapeString(comment), interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, TableImpl.class, recordType, interfaces);
            out.printSerial();
            this.printSingletonInstance(out, (Definition)table);
        }
        this.printRecordTypeMethod(out, (Definition)table);
        for (ColumnDefinition column : table.getColumns()) {
            String columnType = out.ref(this.getJavaType(column.getType()));
            String columnTypeRef = this.getJavaTypeReference(column.getDatabase(), column.getType());
            String columnId = out.ref(this.getStrategy().getJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            String columnName = column.getName();
            String columnComment = StringUtils.defaultString((String)column.getComment());
            List<String> converters = out.ref(JavaGenerator.list(column.getType().getConverter(), column.getType().getBinding()));
            ((JavaWriter)out.tab(1)).javadoc("The column <code>%s</code>.%s", column.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + columnComment), (String)""));
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("val %s : %s[%s, %s] = createField(\"%s\", %s, \"%s\"[[before=, ][new %s()]])", columnId, TableField.class, recordType, columnType, columnName, columnTypeRef, this.escapeString(columnComment), converters);
                continue;
            }
            String isStatic = this.generateInstanceFields() ? "" : "static ";
            String tableRef = this.generateInstanceFields() ? "this" : out.ref(this.getStrategy().getJavaIdentifier((Definition)table), 2);
            ((JavaWriter)out.tab(1)).println("public %sfinal %s<%s, %s> %s = createField(\"%s\", %s, %s, \"%s\"[[before=, ][new %s()]]);", isStatic, TableField.class, recordType, columnType, columnId, columnName, columnTypeRef, tableRef, this.escapeString(columnComment), converters);
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("def this() = {");
            ((JavaWriter)out.tab(2)).println("this(\"%s\", null, null)", table.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            if (this.generateInstanceFields()) {
                ((JavaWriter)out.tab(1)).javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
                ((JavaWriter)out.tab(1)).println("public %s() {", className);
            } else {
                ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
                ((JavaWriter)out.tab(1)).println("private %s() {", className);
            }
            ((JavaWriter)out.tab(2)).println("this(\"%s\", null);", table.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("def this(alias : %s) = {", String.class);
            ((JavaWriter)out.tab(2)).println("this(alias, %s, null)", tableId);
            ((JavaWriter)out.tab(1)).println("}");
        } else if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public %s(%s alias) {", className, String.class);
            ((JavaWriter)out.tab(2)).println("this(alias, %s);", tableId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("private def this(alias : %s, aliased : %s[%s]) = {", String.class, Table.class, recordType);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, new %s[ %s[_] ](%s))", out.ref("scala.Array"), Field.class, table.getParameters().size());
            } else {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, null)");
            }
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("private %s(%s alias, %s<%s> aliased) {", className, String.class, Table.class, recordType);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, new %s[%s]);", Field.class, table.getParameters().size());
            } else {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, null);");
            }
            ((JavaWriter)out.tab(1)).println("}");
            out.println();
            ((JavaWriter)out.tab(1)).println("private %s(%s alias, %s<%s> aliased, %s<?>[] parameters) {", className, String.class, Table.class, recordType, Field.class);
            ((JavaWriter)out.tab(2)).println("super(alias, null, aliased, parameters, \"%s\");", this.escapeString(comment));
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override def getSchema : %s = %s", Schema.class, schemaId);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
            ((JavaWriter)out.tab(2)).println("return %s;", schemaId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateRelations()) {
            List foreignKeys;
            List uniqueKeys;
            IdentityDefinition identityDefinition = table.getIdentity();
            if (identityDefinition != null) {
                String identityType = out.ref(this.getJavaType(identityDefinition.getColumn().getType()));
                String identityFullId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)identityDefinition), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getIdentity : %s[%s, %s] = {", Identity.class, recordType, identityType);
                    ((JavaWriter)out.tab(2)).println("%s", identityFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getIdentity() {", Identity.class, recordType, identityType);
                    ((JavaWriter)out.tab(2)).println("return %s;", identityFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if (primaryKey != null) {
                String keyFullId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)primaryKey), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getPrimaryKey : %s[%s] = {", UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("%s", keyFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s> getPrimaryKey() {", UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s;", keyFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                List<String> keyFullIds = out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKeys), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getKeys : %s[ %s[%s] ] = {", List.class, UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.asList[ %s[%s] ]([[%s]])", Arrays.class, UniqueKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s<%s>> getKeys() {", List.class, UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.<%s<%s>>asList([[%s]]);", Arrays.class, UniqueKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                List<String> keyFullIds = out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKeys), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getReferences : %s[ %s[%s, _] ] = {", List.class, ForeignKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.asList[ %s[%s, _] ]([[%s]])", Arrays.class, ForeignKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s<%s, ?>> getReferences() {", List.class, ForeignKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.<%s<%s, ?>>asList([[%s]]);", Arrays.class, ForeignKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
        }
        if (updatable) {
            String columnId;
            String columnType;
            Pattern p;
            block1: for (String pattern : this.database.getRecordVersionFields()) {
                p = Pattern.compile(pattern, 4);
                for (ColumnDefinition column : table.getColumns()) {
                    if (!p.matcher(column.getName()).matches() && !p.matcher(column.getQualifiedName()).matches()) continue;
                    columnType = out.ref(this.getJavaType(column.getType()));
                    columnId = this.getStrategy().getJavaIdentifier((Definition)column);
                    if (this.scala) {
                        out.println();
                        ((JavaWriter)out.tab(1)).println("override def getRecordVersion : %s[%s, %s] = {", TableField.class, recordType, columnType);
                        ((JavaWriter)out.tab(2)).println("%s", columnId);
                        ((JavaWriter)out.tab(1)).println("}");
                        break block1;
                    }
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getRecordVersion() {", TableField.class, recordType, columnType);
                    ((JavaWriter)out.tab(2)).println("return %s;", columnId);
                    ((JavaWriter)out.tab(1)).println("}");
                    break block1;
                }
            }
            block3: for (String pattern : this.database.getRecordTimestampFields()) {
                p = Pattern.compile(pattern, 4);
                for (ColumnDefinition column : table.getColumns()) {
                    if (!p.matcher(column.getName()).matches() && !p.matcher(column.getQualifiedName()).matches()) continue;
                    columnType = out.ref(this.getJavaType(column.getType()));
                    columnId = this.getStrategy().getJavaIdentifier((Definition)column);
                    if (this.scala) {
                        out.println();
                        ((JavaWriter)out.tab(1)).println("override def getRecordTimestamp : %s[%s, %s] = {", TableField.class, recordType, columnType);
                        ((JavaWriter)out.tab(2)).println("%s", columnId);
                        ((JavaWriter)out.tab(1)).println("}");
                        break block3;
                    }
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getRecordTimestamp() {", TableField.class, recordType, columnType);
                    ((JavaWriter)out.tab(2)).println("return %s;", columnId);
                    ((JavaWriter)out.tab(1)).println("}");
                    break block3;
                }
            }
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override def as(alias : %s) : %s = {", String.class, className);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("new %s(alias, this, parameters)", className);
            } else {
                ((JavaWriter)out.tab(2)).println("new %s(alias, this)", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        } else if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s as(%s alias) {", className, String.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(alias, this, parameters);", className);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(alias, this);", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).println("def rename(name : %s) : %s = {", String.class, className);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("new %s(name, null, parameters)", className);
            } else {
                ((JavaWriter)out.tab(2)).println("new %s(name, null)", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        } else if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).println("public %s rename(%s name) {", className, String.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(name, null, parameters);", className);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(name, null);", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (table.isTableValuedFunction()) {
            boolean parametersAsField;
            boolean[] blArray = new boolean[]{false, true};
            int n = blArray.length;
            for (int i = 0; !(i >= n || (parametersAsField = blArray[i]) && table.getParameters().size() == 0); ++i) {
                String separator;
                ((JavaWriter)out.tab(1)).javadoc("Call this table-valued function", new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).print("def call(");
                    this.printParameterDeclarations(out, table, parametersAsField);
                    out.println(") : %s = {", className);
                    ((JavaWriter)out.tab(2)).print("return new %s(getName(), null, %s(", className, out.ref("scala.Array"));
                    separator = "";
                    for (ParameterDefinition parameter : table.getParameters()) {
                        out.print(separator);
                        if (parametersAsField) {
                            out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
                        } else {
                            out.print("%s.value(%s)", DSL.class, this.getStrategy().getJavaMemberName((Definition)parameter));
                        }
                        separator = ", ";
                    }
                    out.println("));");
                    ((JavaWriter)out.tab(1)).println("}");
                    continue;
                }
                ((JavaWriter)out.tab(1)).print("public %s call(", className);
                this.printParameterDeclarations(out, table, parametersAsField);
                out.println(") {");
                ((JavaWriter)out.tab(2)).print("return new %s(getName(), null, new %s[] { ", className, Field.class);
                separator = "";
                for (ParameterDefinition parameter : table.getParameters()) {
                    out.print(separator);
                    if (parametersAsField) {
                        out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
                    } else {
                        out.print("%s.val(%s)", DSL.class, this.getStrategy().getJavaMemberName((Definition)parameter));
                    }
                    separator = ", ";
                }
                out.println(" });");
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        this.generateTableClassFooter(table, out);
        out.println("}");
        this.closeJavaWriter(out);
    }

    private String escapeString(String comment) {
        return comment.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    protected void generateTableClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateTableClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generateSequences(SchemaDefinition schema) {
        log.info((Object)"Generating sequences");
        JavaWriter out = this.newJavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Sequences.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all sequences in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Sequences {");
        } else {
            out.println("public class Sequences {");
        }
        for (SequenceDefinition sequence : this.database.getSequences(schema)) {
            String seqType = out.ref(this.getJavaType(sequence.getType()));
            String seqId = this.getStrategy().getJavaIdentifier((Definition)sequence);
            String seqName = sequence.getOutputName();
            String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
            String typeRef = this.getJavaTypeReference(sequence.getDatabase(), sequence.getType());
            ((JavaWriter)out.tab(1)).javadoc("The sequence <code>%s</code>", sequence.getQualifiedOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("val %s : %s[%s] = new %s[%s](\"%s\", %s, %s)", seqId, Sequence.class, seqType, SequenceImpl.class, seqType, seqName, schemaId, typeRef);
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = new %s<%s>(\"%s\", %s, %s);", Sequence.class, seqType, seqId, SequenceImpl.class, seqType, seqName, schemaId, typeRef);
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Sequences generated");
    }

    protected void generateCatalog(CatalogDefinition catalog) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)catalog));
        log.info((Object)"");
        log.info((Object)"Generating catalog", (Object)out.file().getName());
        log.info((Object)"==========================================================");
        this.generateCatalog(catalog, out);
        this.closeJavaWriter(out);
    }

    protected void generateCatalog(CatalogDefinition catalog, JavaWriter out) {
        String catalogName = catalog.getQualifiedOutputName();
        String catalogId = this.getStrategy().getJavaIdentifier((Definition)catalog);
        String className = this.getStrategy().getJavaClassName((Definition)catalog);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)catalog, GeneratorStrategy.Mode.DEFAULT));
        this.printPackage(out, (Definition)catalog);
        if (this.scala) {
            out.println("object %s {", className);
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", catalogName);
            ((JavaWriter)out.tab(1)).println("val %s = new %s", catalogId, className);
            out.println("}");
            out.println();
        }
        this.generateCatalogClassJavadoc(catalog, out);
        this.printClassAnnotations(out, null, catalog);
        if (this.scala) {
            out.println("class %s extends %s(\"%s\")[[before= with ][separator= with ][%s]] {", className, CatalogImpl.class, catalog.getOutputName(), interfaces);
        } else {
            out.println("public class %s extends %s[[before= implements ][%s]] {", className, CatalogImpl.class, interfaces);
            out.printSerial();
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", catalogName);
            ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, catalogId, className);
        }
        if (this.generateGlobalObjectReferences() && this.generateGlobalSchemaReferences()) {
            for (SchemaDefinition schema : catalog.getSchemata()) {
                String schemaClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)schema));
                String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
                String schemaFullId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
                String schemaComment = !StringUtils.isBlank((String)schema.getComment()) ? schema.getComment() : "The schema <code>" + schema.getQualifiedOutputName() + "</code>.";
                ((JavaWriter)out.tab(1)).javadoc(schemaComment, new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("val %s = %s", schemaId, schemaFullId);
                    continue;
                }
                ((JavaWriter)out.tab(1)).println("public final %s %s = %s;", schemaClassName, schemaId, schemaFullId);
            }
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\");", catalog.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.printReferences(out, this.database.getSchemata(catalog), Schema.class, false);
        this.generateCatalogClassFooter(catalog, out);
        out.println("}");
    }

    protected void generateCatalogClassFooter(CatalogDefinition schema, JavaWriter out) {
    }

    protected void generateCatalogClassJavadoc(CatalogDefinition schema, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)schema);
    }

    protected void generateSchema(SchemaDefinition schema) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)schema));
        log.info((Object)"Generating schema", (Object)out.file().getName());
        log.info((Object)"----------------------------------------------------------");
        this.generateSchema(schema, out);
        this.closeJavaWriter(out);
    }

    protected void generateSchema(SchemaDefinition schema, JavaWriter out) {
        String catalogId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema.getCatalog()), 2);
        String schemaName = schema.getQualifiedOutputName();
        String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
        String className = this.getStrategy().getJavaClassName((Definition)schema);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)schema, GeneratorStrategy.Mode.DEFAULT));
        this.printPackage(out, (Definition)schema);
        if (this.scala) {
            out.println("object %s {", className);
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", schemaName);
            ((JavaWriter)out.tab(1)).println("val %s = new %s", schemaId, className);
            out.println("}");
            out.println();
        }
        this.generateSchemaClassJavadoc(schema, out);
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("class %s extends %s(\"%s\", %s)[[before= with ][separator= with ][%s]] {", className, SchemaImpl.class, schema.getOutputName(), catalogId, interfaces);
        } else {
            out.println("public class %s extends %s[[before= implements ][%s]] {", className, SchemaImpl.class, interfaces);
            out.printSerial();
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", schemaName);
            ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, schemaId, className);
            if (this.generateGlobalObjectReferences() && this.generateGlobalTableReferences()) {
                for (TableDefinition table : schema.getTables()) {
                    String tableClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)table));
                    String tableId = this.getStrategy().getJavaIdentifier((Definition)table);
                    String tableFullId = this.getStrategy().getFullJavaIdentifier((Definition)table);
                    String tableComment = !StringUtils.isBlank((String)table.getComment()) ? table.getComment() : "The table <code>" + table.getQualifiedOutputName() + "</code>.";
                    ((JavaWriter)out.tab(1)).javadoc(tableComment, new Object[0]);
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = %s", tableId, tableFullId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public final %s %s = %s;", tableClassName, tableId, tableFullId);
                    }
                    if (!table.isTableValuedFunction()) continue;
                    this.printTableValuedFunction(out, table, this.getStrategy().getJavaIdentifier((Definition)table));
                }
            }
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\", null);", schema.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def getCatalog : %s = %s", Catalog.class, catalogId);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getCatalog() {", Catalog.class);
            ((JavaWriter)out.tab(2)).println("return %s;", catalogId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateGlobalObjectReferences() && this.generateGlobalSequenceReferences()) {
            this.printReferences(out, this.database.getSequences(schema), Sequence.class, true);
        }
        this.printReferences(out, this.database.getTables(schema), Table.class, true);
        this.printReferences(out, this.database.getUDTs(schema), UDT.class, true);
        this.generateSchemaClassFooter(schema, out);
        out.println("}");
    }

    protected void generateSchemaClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void generateSchemaClassJavadoc(SchemaDefinition schema, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)schema);
    }

    protected void printFromAndInto(JavaWriter out, TableDefinition table) {
        this.printFromAndInto(out, (Definition)table);
    }

    private void printFromAndInto(JavaWriter out, Definition tableOrUDT) {
        String qualified = out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
        ((JavaWriter)out.tab(1)).header("FROM and INTO", new Object[0]);
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("public void from(%s from) {", qualified);
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            String setter = this.getStrategy().getJavaSetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            String getter = this.getStrategy().getJavaGetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s(from.%s)", setter, getter);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s(from.%s());", setter, getter);
        }
        ((JavaWriter)out.tab(1)).println("}");
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into) {", qualified);
            ((JavaWriter)out.tab(2)).println("into.from(this)");
            ((JavaWriter)out.tab(2)).println("return into");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into) {", qualified);
            ((JavaWriter)out.tab(2)).println("into.from(this);");
            ((JavaWriter)out.tab(2)).println("return into;");
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    protected void printReferences(JavaWriter out, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (out != null && !definitions.isEmpty()) {
            int i;
            String generic = isGeneric ? (this.scala ? "[_]" : "<?>") : "";
            List<String> references = out.ref(this.getStrategy().getFullJavaIdentifiers(definitions), 2);
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("override def get%ss : %s[%s%s] = {", type.getSimpleName(), List.class, type, generic);
                ((JavaWriter)out.tab(2)).println("val result = new %s[%s%s]", ArrayList.class, type, generic);
                for (i = 0; i < definitions.size(); i += 500) {
                    ((JavaWriter)out.tab(2)).println("result.addAll(get%ss%s)", type.getSimpleName(), i / 500);
                }
                ((JavaWriter)out.tab(2)).println("result");
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).override();
                ((JavaWriter)out.tab(1)).println("public final %s<%s%s> get%ss() {", List.class, type, generic, type.getSimpleName());
                ((JavaWriter)out.tab(2)).println("%s result = new %s();", List.class, ArrayList.class);
                for (i = 0; i < definitions.size(); i += 500) {
                    ((JavaWriter)out.tab(2)).println("result.addAll(get%ss%s());", type.getSimpleName(), i / 500);
                }
                ((JavaWriter)out.tab(2)).println("return result;");
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 0; i < definitions.size(); i += 500) {
                out.println();
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("private def get%ss%s() : %s[%s%s] = {", type.getSimpleName(), i / 500, List.class, type, generic);
                    ((JavaWriter)out.tab(2)).println("return %s.asList[%s%s]([[before=\n\t\t\t][separator=,\n\t\t\t][%s]])", Arrays.class, type, generic, references.subList(i, Math.min(i + 500, references.size())));
                    ((JavaWriter)out.tab(1)).println("}");
                    continue;
                }
                ((JavaWriter)out.tab(1)).println("private final %s<%s%s> get%ss%s() {", List.class, type, generic, type.getSimpleName(), i / 500);
                ((JavaWriter)out.tab(2)).println("return %s.<%s%s>asList([[before=\n\t\t\t][separator=,\n\t\t\t][%s]]);", Arrays.class, type, generic, references.subList(i, Math.min(i + 500, references.size())));
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
    }

    protected void printTableJPAAnnotation(JavaWriter out, TableDefinition table) {
        SchemaDefinition schema = table.getSchema();
        if (this.generateJPAAnnotations()) {
            out.println("@%s", out.ref("javax.persistence.Entity"));
            out.print("@%s(name = \"", out.ref("javax.persistence.Table"));
            out.print(table.getName().replace("\"", "\\\""));
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.print(", schema = \"");
                out.print(schema.getOutputName().replace("\"", "\\\""));
                out.print("\"");
            }
            StringBuilder sb = new StringBuilder();
            String glue1 = "\n";
            for (UniqueKeyDefinition uk : table.getUniqueKeys()) {
                if (uk.getKeyColumns().size() <= 1) continue;
                sb.append(glue1);
                sb.append("\t").append(this.scala ? "new " : "@").append(out.ref("javax.persistence.UniqueConstraint")).append("(columnNames = ").append(this.scala ? "Array(" : "{");
                String glue2 = "";
                for (ColumnDefinition column : uk.getKeyColumns()) {
                    sb.append(glue2);
                    sb.append("\"");
                    sb.append(column.getName().replace("\"", "\\\""));
                    sb.append("\"");
                    glue2 = ", ";
                }
                sb.append(this.scala ? ")" : "}").append(")");
                glue1 = ",\n";
            }
            if (sb.length() > 0) {
                ((JavaWriter)out.print(", uniqueConstraints = ")).print(this.scala ? "Array(" : "{");
                out.println(sb.toString());
                out.print(this.scala ? ")" : "}");
            }
            out.println(")");
        }
    }

    protected void printColumnJPAAnnotation(JavaWriter out, ColumnDefinition column) {
        if (this.generateJPAAnnotations()) {
            UniqueKeyDefinition pk = column.getPrimaryKey();
            List uks = column.getUniqueKeys();
            if (pk != null && pk.getKeyColumns().size() == 1) {
                ((JavaWriter)out.tab(1)).println("@%s", out.ref("javax.persistence.Id"));
                if (((ColumnDefinition)pk.getKeyColumns().get(0)).isIdentity()) {
                    ((JavaWriter)out.tab(1)).println("@%s(strategy = %s.IDENTITY)", out.ref("javax.persistence.GeneratedValue"), out.ref("javax.persistence.GenerationType"));
                }
            }
            String unique = "";
            for (UniqueKeyDefinition uk : uks) {
                if (uk.getKeyColumns().size() != 1) continue;
                unique = ", unique = true";
                break;
            }
            String nullable = "";
            if (!column.getType().isNullable()) {
                nullable = ", nullable = false";
            }
            String length = "";
            String precision = "";
            String scale = "";
            if (column.getType().getLength() > 0) {
                length = ", length = " + column.getType().getLength();
            } else if (column.getType().getPrecision() > 0) {
                precision = ", precision = " + column.getType().getPrecision();
                if (column.getType().getScale() > 0) {
                    scale = ", scale = " + column.getType().getScale();
                }
            }
            out.print("\t@%s(name = \"", out.ref("javax.persistence.Column"));
            out.print(column.getName().replace("\"", "\\\""));
            out.print("\"");
            out.print(unique);
            out.print(nullable);
            out.print(length);
            out.print(precision);
            out.print(scale);
            out.println(")");
        }
    }

    @Deprecated
    protected void printColumnValidationAnnotation(JavaWriter out, ColumnDefinition column) {
        this.printValidationAnnotation(out, (TypedElementDefinition<?>)column);
    }

    private void printValidationAnnotation(JavaWriter out, TypedElementDefinition<?> column) {
        if (this.generateValidationAnnotations()) {
            int length;
            DataTypeDefinition type = column.getType();
            if (!column.getType().isNullable() && !column.getType().isDefaulted()) {
                ((JavaWriter)out.tab(1)).println("@%s", out.ref("javax.validation.constraints.NotNull"));
            }
            if ("java.lang.String".equals(this.getJavaType(type)) && (length = type.getLength()) > 0) {
                ((JavaWriter)out.tab(1)).println("@%s(max = %s)", out.ref("javax.validation.constraints.Size"), length);
            }
        }
    }

    protected void generateRoutine(SchemaDefinition schema, RoutineDefinition routine) {
        JavaWriter out = this.newJavaWriter(this.getStrategy().getFile((Definition)routine));
        log.info((Object)"Generating routine", (Object)out.file().getName());
        this.generateRoutine(routine, out);
        this.closeJavaWriter(out);
    }

    protected void generateRoutine(RoutineDefinition routine, JavaWriter out) {
        List<String> converters;
        String isUnnamed;
        String isDefaulted;
        String paramComment;
        String paramName;
        String paramId;
        String paramTypeRef;
        String paramType;
        SchemaDefinition schema = routine.getSchema();
        String className = this.getStrategy().getJavaClassName((Definition)routine);
        String returnType = routine.getReturnValue() == null ? Void.class.getName() : out.ref(this.getJavaType(routine.getReturnType()));
        List<String> returnTypeRef = JavaGenerator.list(routine.getReturnValue() != null ? this.getJavaTypeReference(this.database, routine.getReturnType()) : null);
        List<String> returnConverterType = out.ref(JavaGenerator.list(routine.getReturnValue() != null ? routine.getReturnType().getConverter() : null, routine.getReturnValue() != null ? routine.getReturnType().getBinding() : null));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)routine, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        List<String> packageId = out.ref(this.getStrategy().getFullJavaIdentifiers(new Definition[]{routine.getPackage()}), 2);
        this.printPackage(out, (Definition)routine);
        if (this.scala) {
            out.println("object %s {", className);
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                paramType = out.ref(this.getJavaType(parameter.getType()));
                paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
                paramId = out.ref(this.getStrategy().getJavaIdentifier((Definition)parameter), 2);
                paramName = parameter.getName();
                paramComment = StringUtils.defaultString((String)parameter.getComment());
                isDefaulted = parameter.isDefaulted() ? "true" : "false";
                isUnnamed = parameter.isUnnamed() ? "true" : "false";
                converters = out.ref(JavaGenerator.list(parameter.getType().getConverter(), parameter.getType().getBinding()));
                ((JavaWriter)out.tab(1)).javadoc("The parameter <code>%s</code>.%s", parameter.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + paramComment), (String)""));
                ((JavaWriter)out.tab(1)).println("val %s : %s[%s] = %s.createParameter(\"%s\", %s, %s, %s[[before=, ][new %s]])", paramId, Parameter.class, paramType, AbstractRoutine.class, paramName, paramTypeRef, isDefaulted, isUnnamed, converters);
            }
            out.println("}");
            out.println();
        }
        this.generateRoutineClassJavadoc(routine, out);
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("class %s extends %s[%s](\"%s\", %s[[before=, ][%s]][[before=, ][%s]][[before=, ][new %s()]])[[before= with ][separator= with ][%s]] {", className, AbstractRoutine.class, returnType, routine.getName(), schemaId, packageId, returnTypeRef, returnConverterType, interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, AbstractRoutine.class, returnType, interfaces);
            out.printSerial();
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                paramType = out.ref(this.getJavaType(parameter.getType()));
                paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
                paramId = out.ref(this.getStrategy().getJavaIdentifier((Definition)parameter), 2);
                paramName = parameter.getName();
                paramComment = StringUtils.defaultString((String)parameter.getComment());
                isDefaulted = parameter.isDefaulted() ? "true" : "false";
                isUnnamed = parameter.isUnnamed() ? "true" : "false";
                converters = out.ref(JavaGenerator.list(parameter.getType().getConverter(), parameter.getType().getBinding()));
                ((JavaWriter)out.tab(1)).javadoc("The parameter <code>%s</code>.%s", parameter.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + paramComment), (String)""));
                ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = createParameter(\"%s\", %s, %s, %s[[before=, ][new %s()]]);", Parameter.class, paramType, paramId, paramName, paramTypeRef, isDefaulted, isUnnamed, converters);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("{");
        } else {
            ((JavaWriter)out.tab(1)).javadoc("Create a new routine call instance", new Object[0]);
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\", %s[[before=, ][%s]][[before=, ][%s]][[before=, ][new %s()]]);", routine.getName(), schemaId, packageId, returnTypeRef, returnConverterType);
            if (routine.getAllParameters().size() > 0) {
                out.println();
            }
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            String paramId2 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            if (parameter.equals(routine.getReturnValue())) {
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("setReturnParameter(%s.%s)", className, paramId2);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("setReturnParameter(%s);", paramId2);
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    if (this.scala) {
                        ((JavaWriter)out.tab(2)).println("addInOutParameter(%s.%s)", className, paramId2);
                        continue;
                    }
                    ((JavaWriter)out.tab(2)).println("addInOutParameter(%s);", paramId2);
                    continue;
                }
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("addInParameter(%s.%s)", className, paramId2);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("addInParameter(%s);", paramId2);
                continue;
            }
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("addOutParameter(%s.%s)", className, paramId2);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("addOutParameter(%s);", paramId2);
        }
        if (routine.getOverload() != null) {
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("setOverloaded(true)");
            } else {
                ((JavaWriter)out.tab(2)).println("setOverloaded(true);");
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            String setterReturnType = this.fluentSetters() ? className : (this.scala ? "Unit" : "void");
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String numberValue = parameter.getType().isGenericNumberType() ? "Number" : "Value";
            String numberField = parameter.getType().isGenericNumberType() ? "Number" : "Field";
            String paramId3 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            String paramName2 = "value".equals(paramId3) ? "value_" : "value";
            ((JavaWriter)out.tab(1)).javadoc("Set the <code>%s</code> parameter IN value to the routine", parameter.getOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(%s : %s) : Unit = {", setter, paramName2, this.refNumberType(out, parameter.getType()));
                ((JavaWriter)out.tab(2)).println("set%s(%s.%s, %s)", numberValue, className, paramId3, paramName2);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).println("public void %s(%s %s) {", setter, this.refNumberType(out, parameter.getType()), paramName2);
                ((JavaWriter)out.tab(2)).println("set%s(%s, %s);", numberValue, paramId3, paramName2);
                ((JavaWriter)out.tab(1)).println("}");
            }
            if (!routine.isSQLUsable()) continue;
            ((JavaWriter)out.tab(1)).javadoc("Set the <code>%s</code> parameter to the function to be used with a {@link org.jooq.Select} statement", parameter.getOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(field : %s[%s]) : %s = {", setter, Field.class, this.refExtendsNumberType(out, parameter.getType()), setterReturnType);
                ((JavaWriter)out.tab(2)).println("set%s(%s.%s, field)", numberField, className, paramId3);
                if (this.fluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public %s %s(%s<%s> field) {", setterReturnType, setter, Field.class, this.refExtendsNumberType(out, parameter.getType()));
            ((JavaWriter)out.tab(2)).println("set%s(%s, field);", numberField, paramId3);
            if (this.fluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            String paramName3 = parameter.getOutputName();
            String paramType2 = out.ref(this.getJavaType(parameter.getType()));
            String paramGetter = this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramId4 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            ((JavaWriter)out.tab(1)).javadoc("Get the <code>%s</code> parameter OUT value from the routine", paramName3);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s : %s = {", paramGetter, paramType2);
                ((JavaWriter)out.tab(2)).println("get(%s.%s)", className, paramId4);
                ((JavaWriter)out.tab(1)).println("}");
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public %s %s() {", paramType2, paramGetter);
            ((JavaWriter)out.tab(2)).println("return get(%s);", paramId4);
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.generateRoutineClassFooter(routine, out);
        out.println("}");
    }

    protected void generateRoutineClassFooter(RoutineDefinition routine, JavaWriter out) {
    }

    protected void generateRoutineClassJavadoc(RoutineDefinition routine, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)routine);
    }

    protected void printConvenienceMethodFunctionAsField(JavaWriter out, RoutineDefinition function, boolean parametersAsField) {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String localVar = this.disambiguateJavaMemberName(function.getInParameters(), "f");
        ((JavaWriter)out.tab(1)).javadoc("Get <code>%s</code> as a field.", function.getQualifiedOutputName());
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(", this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        } else {
            ((JavaWriter)out.tab(1)).print("public static %s<%s> %s(", function.isAggregate() ? AggregateFunction.class : Field.class, out.ref(this.getJavaType(function.getReturnType())), this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        }
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (this.scala) {
                out.print("%s : ", this.getStrategy().getJavaMemberName((Definition)parameter));
                if (parametersAsField) {
                    out.print("%s[%s]", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
            } else {
                if (parametersAsField) {
                    out.print("%s<%s>", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
                out.print(" %s", this.getStrategy().getJavaMemberName((Definition)parameter));
            }
            separator = ", ";
        }
        if (this.scala) {
            out.println(") : %s[%s] = {", function.isAggregate() ? AggregateFunction.class : Field.class, out.ref(this.getJavaType(function.getReturnType())));
            ((JavaWriter)out.tab(2)).println("val %s = new %s", localVar, className);
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s.%s(%s)", localVar, paramSetter, paramMember);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s.%s(%s);", localVar, paramSetter, paramMember);
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("return %s.as%s", localVar, function.isAggregate() ? "AggregateFunction" : "Field");
        } else {
            ((JavaWriter)out.tab(2)).println("return %s.as%s();", localVar, function.isAggregate() ? "AggregateFunction" : "Field");
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodTableValuedFunctionAsField(JavaWriter out, TableDefinition function, boolean parametersAsField, String javaMethodName) {
        if (function.getParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getParameters().isEmpty()) {
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        ((JavaWriter)out.tab(1)).javadoc("Get <code>%s</code> as a table.", function.getQualifiedOutputName());
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(", javaMethodName);
        } else {
            ((JavaWriter)out.tab(1)).print("public static %s %s(", className, javaMethodName);
        }
        this.printParameterDeclarations(out, function, parametersAsField);
        if (this.scala) {
            out.println(") : %s = {", className);
            ((JavaWriter)out.tab(2)).print("%s.call(", out.ref(this.getStrategy().getFullJavaIdentifier((Definition)function), 2));
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).print("return %s.call(", out.ref(this.getStrategy().getFullJavaIdentifier((Definition)function), 2));
        }
        String separator = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(separator);
            out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        if (this.scala) {
            out.println(")");
        } else {
            out.println(");");
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    private void printParameterDeclarations(JavaWriter out, TableDefinition function, boolean parametersAsField) {
        String sep1 = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(sep1);
            if (this.scala) {
                out.print("%s : ", this.getStrategy().getJavaMemberName((Definition)parameter));
                if (parametersAsField) {
                    out.print("%s[%s]", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
            } else {
                if (parametersAsField) {
                    out.print("%s<%s>", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
                out.print(" %s", this.getStrategy().getJavaMemberName((Definition)parameter));
            }
            sep1 = ", ";
        }
    }

    private String disambiguateJavaMemberName(Collection<? extends Definition> definitions, String defaultName) {
        HashSet<String> names = new HashSet<String>();
        for (Definition definition : definitions) {
            names.add(this.getStrategy().getJavaMemberName(definition));
        }
        String name = defaultName;
        while (names.contains(name)) {
            name = name + "_";
        }
        return name;
    }

    protected void printConvenienceMethodFunction(JavaWriter out, RoutineDefinition function, boolean instance) {
        String paramMember;
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String functionName = function.getQualifiedOutputName();
        String functionType = out.ref(this.getJavaType(function.getReturnType()));
        String methodName = this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT);
        String configurationArgument = this.disambiguateJavaMemberName(function.getInParameters(), "configuration");
        String localVar = this.disambiguateJavaMemberName(function.getInParameters(), "f");
        ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>", functionName);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(", methodName);
        } else {
            ((JavaWriter)out.tab(1)).print("public %s%s %s(", !instance ? "static " : "", functionType, methodName);
        }
        String glue = "";
        if (!instance) {
            if (this.scala) {
                out.print("%s : %s", configurationArgument, Configuration.class);
            } else {
                out.print("%s %s", Configuration.class, configurationArgument);
            }
            glue = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            String paramType = this.refNumberType(out, parameter.getType());
            paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                out.print("%s%s : %s", glue, paramMember, paramType);
            } else {
                out.print("%s%s %s", glue, paramType, paramMember);
            }
            glue = ", ";
        }
        if (this.scala) {
            out.println(") : %s = {", functionType);
            ((JavaWriter)out.tab(2)).println("val %s = new %s()", localVar, className);
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String string = paramMember = instance && parameter.equals(function.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s.%s(%s)", localVar, paramSetter, paramMember);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s.%s(%s);", localVar, paramSetter, paramMember);
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s)", localVar, instance ? "configuration()" : configurationArgument);
        } else {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s);", localVar, instance ? "configuration()" : configurationArgument);
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("%s.getReturnValue", localVar);
        } else {
            ((JavaWriter)out.tab(2)).println("return %s.getReturnValue();", localVar);
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodProcedure(JavaWriter out, RoutineDefinition procedure, boolean instance) {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)procedure));
        String configurationArgument = this.disambiguateJavaMemberName(procedure.getInParameters(), "configuration");
        String localVar = this.disambiguateJavaMemberName(procedure.getInParameters(), "p");
        List<ParameterDefinition> outParams = JavaGenerator.list(procedure.getReturnValue(), procedure.getOutParameters());
        ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>", procedure.getQualifiedOutputName());
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def ");
        } else {
            ((JavaWriter)out.tab(1)).print("public ");
            if (!instance) {
                out.print("static ");
            }
            if (outParams.size() == 0) {
                out.print("void ");
            } else if (outParams.size() == 1) {
                out.print(out.ref(this.getJavaType(outParams.get(0).getType())));
                out.print(" ");
            } else {
                out.print(className + " ");
            }
        }
        out.print(this.getStrategy().getJavaMethodName((Definition)procedure, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            if (this.scala) {
                out.print("%s : %s", configurationArgument, Configuration.class);
            } else {
                out.print("%s %s", Configuration.class, configurationArgument);
            }
            glue = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            out.print(glue);
            if (this.scala) {
                out.print("%s : %s", this.getStrategy().getJavaMemberName((Definition)parameter), this.refNumberType(out, parameter.getType()));
            } else {
                out.print("%s %s", this.refNumberType(out, parameter.getType()), this.getStrategy().getJavaMemberName((Definition)parameter));
            }
            glue = ", ";
        }
        if (this.scala) {
            out.print(") : ");
            if (outParams.size() == 0) {
                out.print("Unit");
            } else if (outParams.size() == 1) {
                out.print(out.ref(this.getJavaType(outParams.get(0).getType())));
            } else {
                out.print(className);
            }
            out.println(" = {");
            ((JavaWriter)out.tab(2)).println("val %s = new %s", localVar, className);
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            String arg;
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String string = arg = instance && parameter.equals(procedure.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s.%s(%s)", localVar, setter, arg);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s.%s(%s);", localVar, setter, arg);
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s)", localVar, instance ? "configuration()" : configurationArgument);
        } else {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s);", localVar, instance ? "configuration()" : configurationArgument);
        }
        if (outParams.size() > 0) {
            ParameterDefinition parameter = outParams.get(0);
            String getter = parameter == procedure.getReturnValue() ? "getReturnValue" : this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            boolean isUDT = parameter.getType().isUDT();
            if (instance) {
                if (this.generateInterfaces() && isUDT) {
                    String columnTypeInterface = out.ref(this.getJavaType(parameter.getType(), GeneratorStrategy.Mode.INTERFACE));
                    if (this.scala) {
                        ((JavaWriter)out.tab(2)).println("from(%s.%s.asInstanceOf[%s])", localVar, getter, columnTypeInterface);
                    } else {
                        ((JavaWriter)out.tab(2)).println("from((%s) %s.%s());", columnTypeInterface, localVar, getter);
                    }
                } else if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("from(%s.%s)", localVar, getter);
                } else {
                    ((JavaWriter)out.tab(2)).println("from(%s.%s());", localVar, getter);
                }
            }
            if (outParams.size() == 1) {
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("return %s.%s", localVar, getter);
                } else {
                    ((JavaWriter)out.tab(2)).println("return %s.%s();", localVar, getter);
                }
            } else if (outParams.size() > 1) {
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("return %s", localVar);
                } else {
                    ((JavaWriter)out.tab(2)).println("return %s;", localVar);
                }
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodTableValuedFunction(JavaWriter out, TableDefinition function, String javaMethodName) {
        if (function.getParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String recordClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)function, GeneratorStrategy.Mode.RECORD));
        String configurationArgument = this.disambiguateJavaMemberName(function.getParameters(), "configuration");
        ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>.", function.getQualifiedOutputName());
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(%s : %s", javaMethodName, configurationArgument, Configuration.class);
        } else {
            ((JavaWriter)out.tab(1)).print("public static %s<%s> %s(%s %s", Result.class, recordClassName, javaMethodName, Configuration.class, configurationArgument);
        }
        if (!function.getParameters().isEmpty()) {
            out.print(", ");
        }
        this.printParameterDeclarations(out, function, false);
        if (this.scala) {
            out.println(") : %s[%s] = {", Result.class, recordClassName);
            ((JavaWriter)out.tab(2)).print("%s.using(%s).selectFrom(%s.call(", DSL.class, configurationArgument, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)function), 2));
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).print("return %s.using(%s).selectFrom(%s.call(", DSL.class, configurationArgument, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)function), 2));
        }
        String separator = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(separator);
            out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        out.print(")).fetch()");
        if (this.scala) {
            out.println();
        } else {
            out.println(";");
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printRecordTypeMethod(JavaWriter out, Definition definition) {
        String className = out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        ((JavaWriter)out.tab(1)).javadoc("The class holding records for this type", new Object[0]);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def getRecordType : %s[%s] = {", Class.class, className);
            ((JavaWriter)out.tab(2)).println("classOf[%s]", className);
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).override();
            ((JavaWriter)out.tab(1)).println("public %s<%s> getRecordType() {", Class.class, className);
            ((JavaWriter)out.tab(2)).println("return %s.class;", className);
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    protected void printSingletonInstance(JavaWriter out, Definition definition) {
        String className = this.getStrategy().getJavaClassName(definition);
        String identifier = this.getStrategy().getJavaIdentifier(definition);
        ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", definition.getQualifiedOutputName());
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("val %s = new %s", identifier, className);
        } else {
            ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, identifier, className);
        }
    }

    protected void printClassJavadoc(JavaWriter out, Definition definition) {
        this.printClassJavadoc(out, definition.getComment());
    }

    protected void printClassJavadoc(JavaWriter out, String comment) {
        out.println("/**");
        if (comment != null && comment.length() > 0) {
            this.printJavadocParagraph(out, comment, "");
        } else {
            out.println(" * This class is generated by jOOQ.");
        }
        out.println(" */");
    }

    protected void printClassAnnotations(JavaWriter out, SchemaDefinition schema) {
        this.printClassAnnotations(out, schema, schema.getCatalog());
    }

    protected void printClassAnnotations(JavaWriter out, SchemaDefinition schema, CatalogDefinition catalog) {
        if (this.generateGeneratedAnnotation()) {
            out.println("@%s(", out.ref("javax.annotation.Generated"));
            if (this.useSchemaVersionProvider() || this.useCatalogVersionProvider()) {
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("value = %s(", out.ref("scala.Array"));
                } else {
                    ((JavaWriter)out.tab(1)).println("value = {");
                }
                ((JavaWriter)out.tab(2)).println("\"http://www.jooq.org\",");
                ((JavaWriter)out.tab(2)).println("\"jOOQ version:%s\",", "3.8.2");
                if (!StringUtils.isBlank((String)this.catalogVersions.get(catalog))) {
                    ((JavaWriter)out.tab(2)).println("\"catalog version:%s\",", this.catalogVersions.get(catalog).replace("\"", "\\\""));
                }
                if (!StringUtils.isBlank((String)this.schemaVersions.get(schema))) {
                    ((JavaWriter)out.tab(2)).println("\"schema version:%s\",", this.schemaVersions.get(schema).replace("\"", "\\\""));
                }
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("),");
                } else {
                    ((JavaWriter)out.tab(1)).println("},");
                }
                ((JavaWriter)out.tab(1)).println("date = \"" + this.isoDate + "\",");
                ((JavaWriter)out.tab(1)).println("comments = \"This class is generated by jOOQ\"");
            } else {
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("value = %s(", out.ref("scala.Array"));
                } else {
                    ((JavaWriter)out.tab(1)).println("value = {");
                }
                ((JavaWriter)out.tab(2)).println("\"http://www.jooq.org\",");
                ((JavaWriter)out.tab(2)).println("\"jOOQ version:%s\"", "3.8.2");
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("),");
                } else {
                    ((JavaWriter)out.tab(1)).println("},");
                }
                ((JavaWriter)out.tab(1)).println("comments = \"This class is generated by jOOQ\"");
            }
            out.println(")");
        }
        if (!this.scala) {
            out.println("@%s({ \"all\", \"unchecked\", \"rawtypes\" })", out.ref("java.lang.SuppressWarnings"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readVersion(File file, String type) {
        String result = null;
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            String string = new String(bytes);
            Matcher matcher = Pattern.compile("@(?:javax\\.annotation\\.)?Generated\\(\\s*?value\\s*?=\\s*?\\{[^}]*?\"" + type + " version:([^\"]*?)\"").matcher(string);
            if (matcher.find()) {
                result = matcher.group(1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected void printJavadocParagraph(JavaWriter out, String comment, String indent) {
        String escaped = comment.replace("/*", "/ *").replace("*/", "* /");
        this.printParagraph(out, escaped, indent + " * ");
    }

    protected void printParagraph(GeneratorWriter<?> out, String comment, String indent) {
        boolean newLine = true;
        int lineLength = 0;
        for (int i = 0; i < comment.length(); ++i) {
            if (newLine) {
                out.print(indent);
                newLine = false;
            }
            out.print(comment.charAt(i));
            ++lineLength;
            if (comment.charAt(i) == '\n') {
                lineLength = 0;
                newLine = true;
                continue;
            }
            if (lineLength <= 70 || !Character.isWhitespace(comment.charAt(i))) continue;
            out.println();
            lineLength = 0;
            newLine = true;
        }
        if (!newLine) {
            out.println();
        }
    }

    protected void printPackage(JavaWriter out, Definition definition) {
        this.printPackage(out, definition, GeneratorStrategy.Mode.DEFAULT);
    }

    protected void printPackage(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ");
        out.println(" */");
        if (this.scala) {
            out.println("package %s", this.getStrategy().getJavaPackageName(definition, mode));
        } else {
            out.println("package %s;", this.getStrategy().getJavaPackageName(definition, mode));
        }
        out.println();
        out.printImports();
        out.println();
    }

    @Deprecated
    protected String getExtendsNumberType(DataTypeDefinition type) {
        return this.getNumberType(type, this.scala ? "_ <: " : "? extends ");
    }

    protected String refExtendsNumberType(JavaWriter out, DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return (this.scala ? "_ <: " : "? extends ") + out.ref(Number.class);
        }
        return out.ref(this.getJavaType(type));
    }

    @Deprecated
    protected String getNumberType(DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return Number.class.getName();
        }
        return this.getJavaType(type);
    }

    protected String refNumberType(JavaWriter out, DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return out.ref(Number.class);
        }
        return out.ref(this.getJavaType(type));
    }

    @Deprecated
    protected String getNumberType(DataTypeDefinition type, String prefix) {
        if (type.isGenericNumberType()) {
            return prefix + Number.class.getName();
        }
        return this.getJavaType(type);
    }

    protected String getSimpleJavaType(DataTypeDefinition type) {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    protected String getJavaTypeReference(Database db, DataTypeDefinition type) {
        if (this.database.isArrayType(type.getType())) {
            String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getUserType());
            return this.getTypeReference(db, type.getSchema(), baseType, 0, 0, 0, true, null, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getLength(), type.isNullable(), type.getDefaultValue(), type.getUserType());
    }

    protected String getJavaType(DataTypeDefinition type) {
        return this.getJavaType(type, GeneratorStrategy.Mode.RECORD);
    }

    protected String getJavaType(DataTypeDefinition type, GeneratorStrategy.Mode udtMode) {
        return this.getType(type.getDatabase(), type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType(), type.getJavaType(), Object.class.getName(), udtMode);
    }

    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String javaType, String defaultType) {
        return this.getType(db, schema, t, p, s, u, javaType, defaultType, GeneratorStrategy.Mode.RECORD);
    }

    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String javaType, String defaultType, GeneratorStrategy.Mode udtMode) {
        String type;
        block18: {
            type = defaultType;
            if (javaType != null) {
                type = javaType;
            } else if (db.isArrayType(t)) {
                String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.scala ? "scala.Array[" + this.getType(db, schema, baseType, p, s, baseType, javaType, defaultType, udtMode) + "]" : this.getType(db, schema, baseType, p, s, baseType, javaType, defaultType, udtMode) + "[]";
            } else if (db.getArray(schema, u) != null) {
                boolean udtArray = db.getArray(schema, u).getElementType().isUDT();
                type = udtMode == GeneratorStrategy.Mode.POJO || udtMode == GeneratorStrategy.Mode.INTERFACE && !udtArray ? (this.scala ? "java.util.List[" + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + "]" : "java.util.List<" + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + ">") : (udtMode == GeneratorStrategy.Mode.INTERFACE ? (this.scala ? "java.util.List[_ <:" + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + "]" : "java.util.List<? extends " + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + ">") : this.getStrategy().getFullJavaClassName((Definition)db.getArray(schema, u), GeneratorStrategy.Mode.RECORD));
            } else if (db.getEnum(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u));
            } else if (db.getUDT(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getUDT(schema, u), udtMode);
            } else if (db.getTable(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getTable(schema, u), udtMode);
            } else if (db.getConfiguredCustomType(u) != null) {
                type = u;
            } else {
                try {
                    Class clazz = DefaultDataType.getType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                    type = this.scala && clazz == byte[].class ? "scala.Array[scala.Byte]" : clazz.getCanonicalName();
                    if (clazz.getTypeParameters().length > 0) {
                        type = type + (this.scala ? "[" : "<");
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = type + separator;
                            type = type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = type + (this.scala ? "]" : ">");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block18;
                    throw e;
                }
            }
        }
        return type;
    }

    protected String getTypeReference(Database db, SchemaDefinition schema, String t, int p, int s, int l, boolean n, String d, String u) {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(schema, u) != null) {
            ArrayDefinition array = this.database.getArray(schema, u);
            sb.append(this.getJavaTypeReference(db, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.classOf(this.getStrategy().getFullJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD)));
            sb.append(")");
        } else if (db.getUDT(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getUDT(schema, u)));
            sb.append(".getDataType()");
        } else if (db.getTable(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getTable(schema, u)));
            sb.append(".getDataType()");
        } else if (db.getEnum(schema, u) != null) {
            sb.append("org.jooq.util.");
            sb.append(db.getDialect().getName().toLowerCase());
            sb.append(".");
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(DefaultDataType.normalise((String)DefaultDataType.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.classOf(this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u))));
            sb.append(")");
        } else {
            DataType dataType = null;
            try {
                dataType = DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s).nullable(n);
                if (d != null) {
                    dataType = dataType.defaultValue(DSL.field((String)d, (DataType)dataType));
                }
            }
            catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLDataType() != null) {
                DataType sqlDataType = dataType.getSQLDataType();
                String sqlDataTypeRef = SQLDataType.class.getCanonicalName() + '.' + DefaultDataType.normalise((String)sqlDataType.getTypeName());
                sb.append(sqlDataTypeRef);
                if (dataType.hasPrecision() && p > 0) {
                    sb.append(".precision(").append(p);
                    if (dataType.hasScale() && s > 0) {
                        sb.append(", ").append(s);
                    }
                    sb.append(")");
                }
                if (dataType.hasLength() && l > 0) {
                    sb.append(".length(").append(l).append(")");
                }
                if (!dataType.nullable()) {
                    sb.append(".nullable(false)");
                }
                if (dataType.defaulted()) {
                    sb.append(".defaultValue(");
                    if (Arrays.asList(SQLDialect.MYSQL).contains(db.getDialect().family())) {
                        sb.append("org.jooq.impl.DSL.inline(\"").append(this.escapeString(d)).append("\"");
                    } else {
                        sb.append("org.jooq.impl.DSL.field(\"").append(this.escapeString(d)).append("\"");
                    }
                    sb.append(", ").append(sqlDataTypeRef).append("))");
                }
            } else {
                try {
                    String typeClass = db.getDialect().getName() == null ? SQLDataType.class.getName() : "org.jooq.util." + db.getDialect().getName().toLowerCase() + "." + db.getDialect().getName() + "DataType";
                    sb.append(typeClass);
                    sb.append(".");
                    String type1 = this.getType(db, schema, t, p, s, u, null, null);
                    String type2 = this.getType(db, schema, t, 0, 0, u, null, null);
                    String typeName = DefaultDataType.normalise((String)t);
                    Reflect.on((String)typeClass).field(typeName);
                    sb.append(typeName);
                    if (!type1.equals(type2)) {
                        Class clazz = DefaultDataType.getType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                        sb.append(".asNumberDataType(");
                        sb.append(this.classOf(clazz.getCanonicalName()));
                        sb.append(")");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    sb = new StringBuilder();
                    sb.append(DefaultDataType.class.getName());
                    sb.append(".getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
                catch (ReflectException e) {
                    sb = new StringBuilder();
                    sb.append(DefaultDataType.class.getName());
                    sb.append(".getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
            }
        }
        return sb.toString();
    }

    protected boolean match(DataTypeDefinition type1, DataTypeDefinition type2) {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }

    @SafeVarargs
    private static final <T> List<T> list(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        if (objects != null) {
            for (T object : objects) {
                if (object == null || "".equals(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    private static final <T> List<T> list(T first, List<T> remaining) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(JavaGenerator.list(first));
        result.addAll(remaining);
        return result;
    }

    private static final <T> List<T> first(Collection<T> objects) {
        ArrayList<T> result;
        block0: {
            Iterator<T> iterator;
            result = new ArrayList<T>();
            if (objects == null || !(iterator = objects.iterator()).hasNext()) break block0;
            T object = iterator.next();
            result.add(object);
        }
        return result;
    }

    private static final <T> List<T> remaining(Collection<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        if (objects != null) {
            result.addAll(objects);
            if (result.size() > 0) {
                result.remove(0);
            }
        }
        return result;
    }

    private final String classOf(String string) {
        if (this.scala) {
            return "classOf[" + string + "]";
        }
        return string + ".class";
    }

    protected JavaWriter newJavaWriter(File file) {
        if (this.scala) {
            file = new File(file.getParentFile(), file.getName().replace(".java", ".scala"));
        }
        return new JavaWriter(file, this.generateFullyQualifiedTypes(), this.targetEncoding);
    }

    protected void closeJavaWriter(JavaWriter out) {
        if (out.close()) {
            this.files.add(out.file());
        }
    }

    private class AvoidAmbiguousClassesFilter
    implements Database.Filter {
        private Map<String, String> included = new HashMap<String, String>();

        private AvoidAmbiguousClassesFilter() {
        }

        public boolean exclude(Definition definition) {
            if (definition instanceof ColumnDefinition || definition instanceof AttributeDefinition || definition instanceof ParameterDefinition) {
                return false;
            }
            String name = JavaGenerator.this.getStrategy().getFullJavaClassName(definition);
            String nameLC = name.toLowerCase();
            String existing = this.included.put(nameLC, name);
            if (existing == null) {
                return false;
            }
            log.warn((Object)"Ambiguous type name", (Object)("The object " + definition.getQualifiedOutputName() + " generates a type " + name + " which conflicts with the existing type " + existing + " on some operating systems. Use a custom generator strategy to disambiguate the types."));
            return true;
        }
    }
}

