/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import org.h2.Driver;
import org.jooq.DSLContext;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.h2.H2Database;

public class DDLDatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(DDLDatabase.class);
    private Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DSLContext create0() {
        if (this.connection == null) {
            String scripts = this.getProperties().getProperty("scripts");
            String encoding = this.getProperties().getProperty("encoding", "UTF-8");
            if (StringUtils.isBlank((String)scripts)) {
                scripts = "";
                log.warn((Object)"No scripts defined", (Object)"It is recommended that you provide an explicit script directory to scan");
            }
            try {
                Properties info = new Properties();
                info.put("user", "sa");
                info.put("password", "");
                this.connection = new Driver().connect("jdbc:h2:mem:jooq-meta-extensions", info);
                InputStream in = null;
                try {
                    in = DDLDatabase.class.getResourceAsStream(scripts);
                    if (in != null) {
                        log.info((Object)("Reading from classpath: " + scripts));
                    } else {
                        File file = new File(scripts);
                        if (file.exists()) {
                            if (file.isFile()) {
                                log.info((Object)("Reading from file: " + scripts));
                                in = new FileInputStream(file);
                            } else if (file.isDirectory()) {
                                log.warn((Object)("Reading from directory not yet supported: " + scripts));
                            }
                        }
                    }
                    if (in != null) {
                        Scanner s = new Scanner(in, encoding).useDelimiter("\\A");
                        Queries queries = DSL.using((Connection)this.connection).parser().parse(s.hasNext() ? s.next() : "");
                        for (Query query : queries) {
                            log.info((Object)query);
                            query.execute();
                        }
                    } else {
                        log.error((Object)("Could not find script source : " + scripts));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return DSL.using((Connection)this.connection);
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!"INFORMATION_SCHEMA".equals(((SchemaDefinition)it.next()).getName())) continue;
            it.remove();
        }
        return result;
    }
}

