/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.Driver;
import org.jooq.CreateSchemaFinalStep;
import org.jooq.DSLContext;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.h2.H2Database;

public class DDLDatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(DDLDatabase.class);
    private static final Pattern P_NAME = Pattern.compile("(?s:.*?\"([^\"]*)\".*)");
    private Connection connection;
    private DSLContext ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DSLContext create0() {
        if (this.connection == null) {
            String scripts = this.getProperties().getProperty("scripts");
            String encoding = this.getProperties().getProperty("encoding", "UTF-8");
            if (StringUtils.isBlank((String)scripts)) {
                scripts = "";
                log.warn((Object)"No scripts defined", (Object)"It is recommended that you provide an explicit script directory to scan");
            }
            try {
                Properties info = new Properties();
                info.put("user", "sa");
                info.put("password", "");
                this.connection = new Driver().connect("jdbc:h2:mem:jooq-meta-extensions-" + UUID.randomUUID(), info);
                this.ctx = DSL.using((Connection)this.connection);
                InputStream in = null;
                try {
                    in = DDLDatabase.class.getResourceAsStream(scripts);
                    if (in != null) {
                        log.info((Object)("Reading from classpath: " + scripts));
                    } else {
                        File file = new File(scripts);
                        if (file.exists()) {
                            if (file.isFile()) {
                                log.info((Object)("Reading from file: " + scripts));
                                in = new FileInputStream(file);
                            } else if (file.isDirectory()) {
                                log.warn((Object)("Reading from directory not yet supported: " + scripts));
                            }
                        }
                    }
                    if (in != null) {
                        Scanner s = new Scanner(in, encoding).useDelimiter("\\A");
                        Queries queries = this.ctx.parser().parse(s.hasNext() ? s.next() : "");
                        block12: for (Query query : queries) {
                            while (true) {
                                try {
                                    query.execute();
                                    log.info((Object)query);
                                    continue block12;
                                }
                                catch (DataAccessException e) {
                                    Matcher m;
                                    SQLException cause;
                                    if (Integer.toString(90079).equals(e.sqlState()) && (cause = (SQLException)e.getCause(SQLException.class)) != null && (m = P_NAME.matcher(cause.getMessage())).find()) {
                                        CreateSchemaFinalStep createSchema = this.ctx.createSchemaIfNotExists(DSL.name((String)m.group(1)));
                                        createSchema.execute();
                                        log.info((Object)createSchema);
                                        continue;
                                    }
                                    throw e;
                                }
                                break;
                            }
                        }
                    } else {
                        log.error((Object)("Could not find script source : " + scripts));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (ParserException e) {
                log.error((Object)("An exception occurred while parsing script source : " + scripts + ". Please report this error to https://github.com/jOOQ/jOOQ/issues/new"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return this.ctx;
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!"INFORMATION_SCHEMA".equals(((SchemaDefinition)it.next()).getName())) continue;
            it.remove();
        }
        return result;
    }
}

