/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.AttributeConverter;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.jooq.meta.extensions.jpa.JPADatabase;
import org.jooq.meta.extensions.jpa.PersistenceUnitInfoImpl;
import org.jooq.tools.JooqLogger;

final class AttributeConverterExtractor
implements Integrator {
    static final JooqLogger log = JooqLogger.getLogger(JPADatabase.class);
    private Metadata meta;
    private JPADatabase database;
    private Collection<? extends Class<?>> classes;

    AttributeConverterExtractor(JPADatabase database, Collection<? extends Class<?>> classes) {
        this.database = database;
        this.classes = classes;
    }

    public final void integrate(Metadata m, SessionFactoryImplementor f, SessionFactoryServiceRegistry r) {
        this.meta = m;
    }

    public final void disintegrate(SessionFactoryImplementor f, SessionFactoryServiceRegistry r) {
    }

    final Map<Name, AttributeConverter<?, ?>> extract() {
        LinkedHashMap result = new LinkedHashMap();
        this.initEntityManagerFactory();
        for (PersistentClass persistentClass : this.meta.getEntityBindings()) {
            Table table = persistentClass.getTable();
            Iterator propertyIterator = persistentClass.getPropertyIterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                Type type = property.getValue().getType();
                if (!(type instanceof AttributeConverterTypeAdapter)) continue;
                AttributeConverter converter = (AttributeConverter)((AttributeConverterTypeAdapter)type).getAttributeConverter().getConverterBean().getBeanInstance();
                Iterator columnIterator = property.getColumnIterator();
                if (!columnIterator.hasNext()) continue;
                Column column = (Column)columnIterator.next();
                if (columnIterator.hasNext()) {
                    log.info((Object)"AttributeConverter", (Object)("Cannot apply AttributeConverter of property " + property + " on several columns."));
                    continue;
                }
                result.put(DSL.name((String[])new String[]{table.getCatalog(), table.getSchema(), table.getName(), column.getName()}), converter);
            }
        }
        return result;
    }

    private final EntityManagerFactory initEntityManagerFactory() {
        PersistenceUnitInfoImpl persistenceUnitInfo = this.persistenceUnitInfo(this.getClass().getSimpleName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("hibernate.integrator_provider", this.integratorProvider());
        configuration.put("hibernate.connection.provider_class", this.database.connectionProvider());
        PersistenceUnitInfoDescriptor descriptor = new PersistenceUnitInfoDescriptor((PersistenceUnitInfo)persistenceUnitInfo);
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)descriptor, configuration).build();
    }

    private IntegratorProvider integratorProvider() {
        return new IntegratorProvider(){

            public List<Integrator> getIntegrators() {
                return Collections.singletonList(AttributeConverterExtractor.this);
            }
        };
    }

    private final PersistenceUnitInfoImpl persistenceUnitInfo(String name) {
        return new PersistenceUnitInfoImpl(name, this.entityClassNames(), this.properties());
    }

    private final Properties properties() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", JPADatabase.HIBERNATE_DIALECT);
        properties.put("hibernate.hbm2ddl.auto", "create-drop");
        properties.putAll(this.database.userSettings);
        return properties;
    }

    private final List<String> entityClassNames() {
        ArrayList<String> result = new ArrayList<String>(this.classes.size());
        for (Class<?> klass : this.classes) {
            result.add(klass.getName());
        }
        return result;
    }
}

