/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.liquibase;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.extensions.AbstractInterpretingDatabase;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class LiquibaseDatabase
extends AbstractInterpretingDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(LiquibaseDatabase.class);
    private static final Map<String, Method> SETTERS = new HashMap<String, Method>();
    private boolean includeLiquibaseTables;
    private String databaseChangeLogTableName;
    private String databaseChangeLogLockTableName;

    @Override
    protected void export() throws Exception {
        String scripts = this.getProperties().getProperty("scripts");
        this.includeLiquibaseTables = Boolean.valueOf(this.getProperties().getProperty("includeLiquibaseTables", "false"));
        if (StringUtils.isBlank((String)scripts)) {
            scripts = "";
            log.warn((Object)"No scripts defined", (Object)"It is recommended that you provide an explicit script directory to scan");
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.connection()));
        String contexts = "";
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            String property;
            String key = "" + entry.getKey();
            if (key.startsWith("database.")) {
                property = key.substring("database.".length());
                Method setter = SETTERS.get("set" + Character.toUpperCase(property.charAt(0)) + property.substring(1));
                try {
                    if (setter == null) continue;
                    setter.invoke((Object)database, Convert.convert((Object)entry.getValue(), setter.getParameterTypes()[0]));
                }
                catch (Exception e) {
                    log.warn((Object)"Configuration error", (Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (!key.startsWith("changeLogParameters.") || !"contexts".equals(property = key.substring("changeLogParameters.".length()))) continue;
            contexts = "" + entry.getValue();
        }
        this.databaseChangeLogTableName = database.getDatabaseChangeLogTableName();
        this.databaseChangeLogLockTableName = database.getDatabaseChangeLogLockTableName();
        Liquibase liquibase = new Liquibase(scripts, (ResourceAccessor)new CompositeResourceAccessor(new ResourceAccessor[]{new FileSystemResourceAccessor(), new ClassLoaderResourceAccessor(), new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader())}), database);
        liquibase.update(contexts);
    }

    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>(super.getTables0());
        if (!this.includeLiquibaseTables) {
            List<String> liquibaseTables = Arrays.asList(this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (!liquibaseTables.contains(((TableDefinition)it.next()).getName())) continue;
                it.remove();
            }
        }
        return result;
    }

    static {
        try {
            for (Method method : Database.class.getMethods()) {
                String name = method.getName();
                if (!name.startsWith("set") || method.getParameterTypes().length != 1) continue;
                SETTERS.put(name, method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

