/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.vertabelo;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXB;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.vertabelo.VertabeloXMLDatabase;
import org.jooq.util.vertabelo.jaxb.DatabaseModel;

public class VertabeloAPIDatabase
extends VertabeloXMLDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(VertabeloAPIDatabase.class);
    protected static final String API_URL_PREFIX = "https://my.vertabelo.com/api/xml/";
    protected static final String API_TOKEN_PARAM = "api-token";
    protected static final String MODEL_ID_PARAM = "model-id";
    protected static final String TAG_NAME_PARAM = "tag-name";
    protected String apiToken;
    protected String modelId;
    protected String tagName;

    @Override
    protected DatabaseModel databaseModel() {
        if (this.databaseModel == null) {
            ByteArrayInputStream stream;
            this.readSettings();
            String xml = this.getXMLFromAPI();
            try {
                stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.databaseModel = (DatabaseModel)JAXB.unmarshal((InputStream)stream, DatabaseModel.class);
        }
        return this.databaseModel;
    }

    protected void readSettings() {
        this.apiToken = this.getProperties().getProperty(API_TOKEN_PARAM);
        if (StringUtils.isEmpty((String)this.apiToken)) {
            throw new IllegalStateException("Lack of \"api-token\" parameter.");
        }
        this.modelId = this.getProperties().getProperty(MODEL_ID_PARAM);
        if (StringUtils.isEmpty((String)this.modelId)) {
            throw new IllegalStateException("Lack of \"model-id\" parameter.");
        }
        this.tagName = this.getProperties().getProperty(TAG_NAME_PARAM);
    }

    protected String getXMLFromAPI() {
        String xml = null;
        String apiUrl = this.getApiUrl();
        try {
            String line;
            log.info((Object)"Creating connection to Vertabelo server...");
            URL url = new URL(apiUrl);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            String encodedAuthData = DatatypeConverter.printBase64Binary((byte[])(this.apiToken + ":").getBytes());
            connection.addRequestProperty("Authorization", "Basic " + encodedAuthData);
            int responseCode = connection.getResponseCode();
            log.info((Object)("Response code: " + responseCode));
            if (responseCode != 200) {
                throw new RuntimeException("Request failed with status code: " + responseCode);
            }
            String response = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = br.readLine()) != null) {
                response = response + line;
            }
            xml = response;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return xml;
    }

    protected String getApiUrl() {
        String apiUrl = API_URL_PREFIX + this.modelId;
        if (!StringUtils.isEmpty((String)this.tagName)) {
            apiUrl = apiUrl + "/" + this.tagName;
        }
        return apiUrl;
    }
}

