/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.vertabelo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DataType;
import org.jooq.SQLDialect;
import org.jooq.impl.DefaultDataType;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.vertabelo.VertabeloXMLDatabase;
import org.jooq.util.vertabelo.jaxb.Column;
import org.jooq.util.vertabelo.jaxb.Property;
import org.jooq.util.vertabelo.jaxb.Table;
import org.jooq.util.vertabelo.jaxb.View;
import org.jooq.util.vertabelo.jaxb.ViewColumn;

public class VertabeloXMLTableDefinition
extends AbstractTableDefinition {
    protected Table table;
    protected View view;

    public VertabeloXMLTableDefinition(SchemaDefinition schema, Table table) {
        super(schema, table.getName(), "");
        this.table = table;
    }

    public VertabeloXMLTableDefinition(SchemaDefinition schema, View view) {
        super(schema, view.getName(), "");
        this.view = view;
    }

    protected List<ColumnDefinition> getElements0() throws SQLException {
        if (this.table != null) {
            return this.getTableElements();
        }
        return this.getViewElements();
    }

    protected List<ColumnDefinition> getTableElements() {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        String schemaName = this.getSchemaName();
        SchemaDefinition schema = this.getDatabase().getSchema(schemaName);
        int position = 0;
        for (Column column : this.table.getColumns()) {
            DataType dataType = DefaultDataType.getDataType((SQLDialect)this.getDialect(), (String)column.getType());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, dataType.getTypeName(), (Number)(dataType.hasLength() ? Integer.valueOf(dataType.length()) : null), (Number)(dataType.hasPrecision() ? Integer.valueOf(dataType.precision()) : null), (Number)(dataType.hasScale() ? Integer.valueOf(dataType.scale()) : null), Boolean.valueOf(column.isNullable()), Boolean.valueOf(!StringUtils.isEmpty((String)column.getDefaultValue())));
            DefaultColumnDefinition columnDefinition = new DefaultColumnDefinition((TableDefinition)this, column.getName(), ++position, (DataTypeDefinition)type, false, column.getDescription());
            result.add((ColumnDefinition)columnDefinition);
        }
        return result;
    }

    protected List<ColumnDefinition> getViewElements() {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        String schemaName = this.getSchemaName();
        SchemaDefinition schema = this.getDatabase().getSchema(schemaName);
        int position = 0;
        for (ViewColumn column : this.view.getViewColumns()) {
            DataType dataType = DefaultDataType.getDataType((SQLDialect)this.getDialect(), (String)column.getType());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, dataType.getTypeName(), (Number)(dataType.hasLength() ? Integer.valueOf(dataType.length()) : null), (Number)(dataType.hasPrecision() ? Integer.valueOf(dataType.precision()) : null), (Number)(dataType.hasScale() ? Integer.valueOf(dataType.scale()) : null), Boolean.valueOf(true), Boolean.valueOf(false));
            DefaultColumnDefinition columnDefinition = new DefaultColumnDefinition((TableDefinition)this, column.getName(), ++position, (DataTypeDefinition)type, false, column.getDescription());
            result.add((ColumnDefinition)columnDefinition);
        }
        return result;
    }

    protected String getSchemaName() {
        Property additionalProperty = this.table != null ? VertabeloXMLDatabase.findAdditionalProperty("Schema", this.table.getProperties()) : VertabeloXMLDatabase.findAdditionalProperty("Schema", this.view.getProperties());
        return VertabeloXMLDatabase.getAdditionalPropertyValueOrEmpty(additionalProperty);
    }
}

