/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.jpa;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.persistence.Entity;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jooq.DSLContext;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.h2.H2Database;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class JPADatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(JPADatabase.class);
    private Connection connection;

    protected DSLContext create0() {
        if (this.connection == null) {
            String packages = this.getProperties().getProperty("packages");
            if (StringUtils.isBlank((String)packages)) {
                packages = "";
                log.warn((Object)"No packages defined", (Object)"It is highly recommended that you provide explicit packages to scan");
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:h2:mem:jooq-meta-extensions", "sa", "");
                MetadataSources metadata = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)"org.hibernate.dialect.H2Dialect").build());
                ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
                for (String pkg : packages.split(",")) {
                    for (BeanDefinition def : scanner.findCandidateComponents(StringUtils.defaultIfBlank((String)pkg, (String)"").trim())) {
                        metadata.addAnnotatedClass(Class.forName(def.getBeanClassName()));
                    }
                }
                SchemaExport export = new SchemaExport((MetadataImplementor)metadata.buildMetadata(), this.connection);
                export.create(true, true);
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return DSL.using((Connection)this.connection);
    }
}

