/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.jpa;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Entity;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.jooq.DSLContext;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.h2.H2Database;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class JPADatabase
extends H2Database {
    private static final JooqLogger log = JooqLogger.getLogger(JPADatabase.class);
    private Connection connection;

    protected DSLContext create0() {
        if (this.connection == null) {
            String packages = this.getProperties().getProperty("packages");
            if (StringUtils.isBlank((String)packages)) {
                packages = "";
                log.warn((Object)"No packages defined", (Object)"It is highly recommended that you provide explicit packages to scan");
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:h2:mem:jooq-meta-extensions", "sa", "");
                MetadataSources metadata = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)"org.hibernate.dialect.H2Dialect").applySetting("javax.persistence.schema-generation-connection", (Object)this.connection).applySetting("javax.persistence.create-database-schemas", (Object)true).applySetting("hibernate.connection.provider_class", (Object)new ConnectionProvider(){

                    public boolean isUnwrappableAs(Class unwrapType) {
                        return false;
                    }

                    public <T> T unwrap(Class<T> unwrapType) {
                        return null;
                    }

                    public Connection getConnection() {
                        return JPADatabase.this.connection;
                    }

                    public void closeConnection(Connection conn) throws SQLException {
                    }

                    public boolean supportsAggressiveRelease() {
                        return true;
                    }
                }).build());
                ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                for (String pkg : packages.split(",")) {
                    for (BeanDefinition def : scanner.findCandidateComponents(StringUtils.defaultIfBlank((String)pkg, (String)"").trim())) {
                        metadata.addAnnotatedClass(Class.forName(def.getBeanClassName(), true, cl));
                    }
                }
                SchemaExport export = new SchemaExport();
                export.create(EnumSet.of(TargetType.DATABASE), metadata.buildMetadata());
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return DSL.using((Connection)this.connection);
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!"INFORMATION_SCHEMA".equals(((SchemaDefinition)it.next()).getName())) continue;
            it.remove();
        }
        return result;
    }
}

