/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.JAXB;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.SortOrder;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.xml.XMLPackageDefinition;
import org.jooq.meta.xml.XMLRoutineDefinition;
import org.jooq.meta.xml.XMLTableDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.xml.jaxb.Index;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Routine;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;

public class XMLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(XMLDatabase.class);
    public static final String P_XML_FILE = "xml-file";
    public static final String P_XSL_FILE = "xsl-file";
    public static final String P_DIALECT = "dialect";
    InformationSchema info;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private InformationSchema info() {
        if (this.info == null) {
            xml = this.getProperties().getProperty("xml-file");
            xsl = this.getProperties().getProperty("xsl-file");
            XMLDatabase.log.info((Object)"Using XML file", (Object)xml);
            try {
                if (StringUtils.isBlank((String)xsl)) {
                    f = null;
                    try {
                        url = XMLDatabase.class.getResource(xml);
                        file = url != null ? new File(url.toURI()) : new File(xml);
                        f = new RandomAccessFile(file, "r");
                        bytes = new byte[(int)f.length()];
                        f.readFully(bytes);
                        content = new String(bytes, "UTF-8");
                        try {
                            reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
                            encoding = reader.getCharacterEncodingScheme();
                            if (encoding == null || "UTF-8".equals(encoding)) ** GOTO lbl63
                            content = new String(bytes, encoding);
                        }
                        catch (XMLStreamException e) {
                            XMLDatabase.log.warn((Object)("Could not open XML Stream: " + e.getMessage()));
                        }
                        catch (UnsupportedEncodingException e) {
                            XMLDatabase.log.warn((Object)("Unsupported encoding: " + e.getMessage()));
                        }
                    }
                    finally {
                        if (f != null) {
                            try {
                                f.close();
                            }
                            catch (Exception url) {}
                        }
                    }
                } else {
                    xmlIs = null;
                    xslIs = null;
                    try {
                        XMLDatabase.log.info((Object)"Using XSL file", (Object)xsl);
                        xmlIs = XMLDatabase.class.getResourceAsStream(xml);
                        if (xmlIs == null) {
                            xmlIs = new FileInputStream(xml);
                        }
                        if ((xslIs = XMLDatabase.class.getResourceAsStream(xsl)) == null) {
                            xslIs = new FileInputStream(xsl);
                        }
                        writer = new StringWriter();
                        factory = TransformerFactory.newInstance();
                        transformer = factory.newTransformer(new StreamSource(xslIs));
                        transformer.transform(new StreamSource(xmlIs), new StreamResult(writer));
                        content = writer.getBuffer().toString();
                    }
                    catch (TransformerException e) {
                        throw new RuntimeException("Error while transforming XML file " + xml + " with XSL file " + xsl, e);
                    }
                    finally {
                        if (xmlIs != null) {
                            try {
                                xmlIs.close();
                            }
                            catch (Exception var13_24) {}
                        }
                        if (xslIs != null) {
                            try {
                                xslIs.close();
                            }
                            catch (Exception var13_25) {}
                        }
                    }
                }
                content = content.replaceAll("<(\\w+:)?information_schema xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-meta-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1information_schema xmlns$2=\"http://www.jooq.org/xsd/jooq-meta-3.11.0.xsd\">");
                content = content.replace("<information_schema>", "<information_schema xmlns=\"http://www.jooq.org/xsd/jooq-meta-3.11.0.xsd\">");
                test = new StringWriter();
                JAXB.marshal((Object)new InformationSchema(), (Writer)test);
                if (!test.toString().contains("xmlns")) {
                    content = content.replaceAll("xmlns=\"[^\"]*\"", "");
                }
                this.info = (InformationSchema)JAXB.unmarshal((Reader)new StringReader(content), InformationSchema.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while opening files " + xml + " or " + xsl, e);
            }
        }
        return this.info;
    }

    @Override
    protected DSLContext create0() {
        SQLDialect dialect = SQLDialect.DEFAULT;
        try {
            dialect = SQLDialect.valueOf((String)this.getProperties().getProperty(P_DIALECT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DSL.using((SQLDialect)dialect.family());
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        final HashMap<Name, TreeSet<IndexColumnUsage>> indexColumnUsage = new HashMap<Name, TreeSet<IndexColumnUsage>>();
        for (IndexColumnUsage ic : this.info().getIndexColumnUsages()) {
            Name name = DSL.name((String[])new String[]{ic.getIndexCatalog(), ic.getIndexSchema(), ic.getTableName(), ic.getIndexName()});
            TreeSet<IndexColumnUsage> list = (TreeSet<IndexColumnUsage>)indexColumnUsage.get(name);
            if (list == null) {
                list = new TreeSet<IndexColumnUsage>(new Comparator<IndexColumnUsage>(){

                    @Override
                    public int compare(IndexColumnUsage o1, IndexColumnUsage o2) {
                        int r = 0;
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getIndexCatalog(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getIndexCatalog(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getIndexSchema(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getIndexSchema(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getTableName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getTableName(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getIndexName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getIndexName(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        return Integer.valueOf(o1.getOrdinalPosition()).compareTo(o2.getOrdinalPosition());
                    }
                });
                indexColumnUsage.put(name, list);
            }
            list.add(ic);
        }
        for (Index i : this.info().getIndexes()) {
            SchemaDefinition schema;
            TableDefinition table;
            if (!this.getInputSchemata().contains(i.getTableSchema()) || (table = this.getTable(schema = this.getSchema(i.getTableSchema()), i.getTableName())) == null) continue;
            final Name name = DSL.name((String[])new String[]{i.getIndexCatalog(), i.getIndexSchema(), i.getTableName(), i.getIndexName()});
            AbstractIndexDefinition index = new AbstractIndexDefinition(schema, i.getIndexName(), table, Boolean.TRUE.equals(i.isIsUnique()), i.getComment()){
                private final List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name3, table2, unique, comment);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    SortedSet list = (SortedSet)indexColumnUsage.get(name);
                    if (list != null) {
                        for (IndexColumnUsage ic : list) {
                            ColumnDefinition column = table.getColumn(ic.getColumnName());
                            if (column != null) {
                                this.indexColumns.add(new DefaultIndexColumnDefinition(this, column, Boolean.TRUE.equals(ic.isIsDescending()) ? SortOrder.DESC : SortOrder.ASC, ic.getOrdinalPosition()));
                                continue;
                            }
                            log.error((Object)String.format("Column %s not found in table %s.", ic.getColumnName(), table));
                        }
                    } else {
                        log.error((Object)String.format("No columns found for index %s.", name));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            };
            result.add(index);
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.PRIMARY_KEY)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.UNIQUE)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<KeyColumnUsage> keyColumnUsage(TableConstraintType constraintType) {
        ArrayList<KeyColumnUsage> result = new ArrayList<KeyColumnUsage>();
        for (TableConstraint constraint : this.info().getTableConstraints()) {
            if (constraintType != constraint.getConstraintType() || !this.getInputSchemata().contains(constraint.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals((String)constraint.getConstraintCatalog(), (String)usage.getConstraintCatalog()) || !StringUtils.equals((String)constraint.getConstraintSchema(), (String)usage.getConstraintSchema()) || !StringUtils.equals((String)constraint.getConstraintName(), (String)usage.getConstraintName())) continue;
                result.add(usage);
            }
        }
        Collections.sort(result, new Comparator<KeyColumnUsage>(){

            @Override
            public int compare(KeyColumnUsage o1, KeyColumnUsage o2) {
                int r = 0;
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintCatalog(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintCatalog(), (Object)""));
                if (r != 0) {
                    return r;
                }
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintSchema(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintSchema(), (Object)""));
                if (r != 0) {
                    return r;
                }
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintName(), (Object)""));
                if (r != 0) {
                    return r;
                }
                return Integer.valueOf(o1.getOrdinalPosition()).compareTo(o2.getOrdinalPosition());
            }
        });
        return result;
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) {
        for (ReferentialConstraint constraint : this.info().getReferentialConstraints()) {
            if (!this.getInputSchemata().contains(constraint.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals((String)constraint.getConstraintCatalog(), (String)usage.getConstraintCatalog()) || !StringUtils.equals((String)constraint.getConstraintSchema(), (String)usage.getConstraintSchema()) || !StringUtils.equals((String)constraint.getConstraintName(), (String)usage.getConstraintName())) continue;
                SchemaDefinition foreignKeySchema = this.getSchema(constraint.getConstraintSchema());
                SchemaDefinition uniqueKeySchema = this.getSchema(constraint.getUniqueConstraintSchema());
                String foreignKey = usage.getConstraintName();
                String foreignKeyTable = usage.getTableName();
                String foreignKeyColumn = usage.getColumnName();
                String uniqueKey = constraint.getUniqueConstraintName();
                TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
                if (referencingTable == null) continue;
                ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
                relations2.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Schema schema : this.info().getSchemata()) {
            result.add(new SchemaDefinition((Database)this, schema.getSchemaName(), schema.getComment()));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Sequence sequence : this.info().getSequences()) {
            if (!this.getInputSchemata().contains(sequence.getSequenceSchema())) continue;
            SchemaDefinition schema = this.getSchema(sequence.getSequenceSchema());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, sequence.getDataType(), (Number)sequence.getCharacterMaximumLength(), (Number)sequence.getNumericPrecision(), (Number)sequence.getNumericScale(), (Boolean)false, (String)null);
            result.add(new DefaultSequenceDefinition(schema, sequence.getSequenceName(), type, sequence.getComment()));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Table table : this.info().getTables()) {
            if (!this.getInputSchemata().contains(table.getTableSchema())) continue;
            SchemaDefinition schema = this.getSchema(table.getTableSchema());
            result.add(new XMLTableDefinition(schema, this.info(), table, table.getComment()));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Routine routine : this.info().getRoutines()) {
            if (!StringUtils.isBlank((String)routine.getSpecificPackage()) || !StringUtils.isBlank((String)routine.getRoutinePackage())) continue;
            String schemaName = StringUtils.defaultIfBlank((String)routine.getSpecificSchema(), (String)routine.getRoutineSchema());
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            result.add(new XMLRoutineDefinition(schema, null, this.info(), routine, routine.getComment()));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        HashSet<String> packages = new HashSet<String>();
        for (Routine routine : this.info().getRoutines()) {
            String schemaName = StringUtils.defaultIfBlank((String)routine.getSpecificSchema(), (String)routine.getRoutineSchema());
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            String packageName = StringUtils.defaultIfBlank((String)routine.getSpecificPackage(), (String)routine.getRoutinePackage());
            if (StringUtils.isBlank((String)packageName) || !packages.add(packageName)) continue;
            result.add(new XMLPackageDefinition(schema, this.info(), packageName));
        }
        return result;
    }

    static int unbox(Integer i) {
        return i == null ? 0 : i;
    }

    static long unbox(Long l) {
        return l == null ? 0L : l;
    }
}

