/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.jooq.Internal;
import org.jooq.meta.tools.FileComparator;
import org.jooq.meta.tools.FlywayFileComparator;
import org.jooq.tools.JooqLogger;

@Internal
public final class FilePattern {
    private static final JooqLogger log = JooqLogger.getLogger(FilePattern.class);

    public static final Comparator<File> fileComparator(String sort) {
        if ("alphanumeric".equals(sort)) {
            return new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.compareTo(o2);
                }
            };
        }
        if ("none".equals(sort)) {
            return null;
        }
        if ("flyway".equals(sort)) {
            return FlywayFileComparator.INSTANCE;
        }
        return FileComparator.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void load(String encoding, String pattern, Comparator<File> fileComparator, Loader loader) throws Exception {
        InputStream in = null;
        boolean loaded = false;
        try {
            in = FilePattern.class.getResourceAsStream(pattern);
            if (in != null) {
                log.info((Object)("Reading from classpath: " + pattern));
                loader.load(encoding, in);
                loaded = true;
            } else {
                File file = new File(pattern);
                if (file.exists()) {
                    FilePattern.load(encoding, file, fileComparator, null, loader);
                    loaded = true;
                } else {
                    file = pattern.contains("*") || pattern.contains("?") ? new File(pattern.replaceAll("[*?].*", "")).getCanonicalFile() : new File(".").getCanonicalFile();
                    Pattern regex = Pattern.compile("^.*?" + pattern.replace("\\", "/").replace(".", "\\.").replace("?", ".").replace("**", ".+?").replace("*", "[^/]*") + "$");
                    FilePattern.load(encoding, file, fileComparator, regex, loader);
                    loaded = true;
                }
            }
            if (!loaded) {
                log.error((Object)("Could not find source(s) : " + pattern));
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static final void load(String encoding, File file, Comparator<File> fileComparator, Pattern pattern, Loader loader) throws Exception {
        if (file.isFile()) {
            if (pattern == null || pattern.matcher(file.getCanonicalPath().replace("\\", "/")).matches()) {
                log.info((Object)("Reading from: " + file + " [*]"));
                loader.load(encoding, new FileInputStream(file));
            }
        } else if (file.isDirectory()) {
            log.info((Object)("Reading from: " + file));
            File[] files = file.listFiles();
            if (files != null) {
                if (fileComparator != null) {
                    Arrays.sort(files, fileComparator);
                }
                for (File f : files) {
                    FilePattern.load(encoding, f, fileComparator, pattern, loader);
                }
            }
        } else if (!file.exists() && file.getParentFile() != null) {
            FilePattern.load(encoding, file.getParentFile(), fileComparator, pattern, loader);
        }
    }

    public static interface Loader {
        public void load(String var1, InputStream var2) throws Exception;
    }
}

