/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.Log;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractTypedElementDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.CatalogVersionProvider;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultEmbeddableDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultOrderProvider;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultUniqueKeyDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IdentityDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.Patterns;
import org.jooq.meta.Relations;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SchemaVersionProvider;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.Statements;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TableElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.meta.jaxb.CatalogMappingType;
import org.jooq.meta.jaxb.CustomType;
import org.jooq.meta.jaxb.Embeddable;
import org.jooq.meta.jaxb.EmbeddableField;
import org.jooq.meta.jaxb.EnumType;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.meta.jaxb.ForcedTypeObjectType;
import org.jooq.meta.jaxb.Nullability;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.RegexFlag;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.csv.CSVReader;

public abstract class AbstractDatabase
implements Database {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractDatabase.class);
    private static final Set<SQLDialect> NO_SUPPORT_SCHEMATA = SQLDialect.supportedBy((SQLDialect[])new SQLDialect[]{SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.SQLITE});
    private Properties properties;
    private String basedir;
    private SQLDialect dialect;
    private Connection connection;
    private boolean regexMatchesPartialQualification;
    private boolean sqlMatchesPartialQualification;
    private OnError onError = OnError.FAIL;
    private List<Database.Filter> filters;
    private String[] excludes;
    private String[] includes = new String[]{".*"};
    private boolean includeExcludeColumns;
    private boolean includeInvisibleColumns = true;
    private boolean includeTables = true;
    private boolean includeEmbeddables = true;
    private boolean includeRoutines = true;
    private boolean includeTriggerRoutines = false;
    private boolean includePackages = true;
    private boolean includePackageRoutines = true;
    private boolean includePackageUDTs = true;
    private boolean includePackageConstants = true;
    private boolean includeUDTs = true;
    private boolean includeSequences = true;
    private boolean includeIndexes = true;
    private boolean includeCheckConstraints = true;
    private boolean includeSystemIndexes = false;
    private boolean includeSystemCheckConstraints = false;
    private boolean includePrimaryKeys = true;
    private boolean includeUniqueKeys = true;
    private boolean includeForeignKeys = true;
    private boolean forceIntegerTypesOnZeroScaleDecimals = true;
    private String[] recordVersionFields;
    private String[] recordTimestampFields;
    private String[] syntheticPrimaryKeys;
    private String[] overridePrimaryKeys;
    private String[] syntheticIdentities;
    private boolean supportsUnsignedTypes;
    private boolean integerDisplayWidths;
    private boolean ignoreProcedureReturnValues;
    private boolean dateAsTimestamp;
    private boolean javaTimeTypes = true;
    private List<CatalogMappingType> configuredCatalogs = new ArrayList<CatalogMappingType>();
    private List<SchemaMappingType> configuredSchemata = new ArrayList<SchemaMappingType>();
    private List<CustomType> configuredCustomTypes;
    private List<EnumType> configuredEnumTypes;
    private List<ForcedType> configuredForcedTypes;
    private Set<ForcedType> unusedForcedTypes;
    private List<Embeddable> configuredEmbeddables;
    private SchemaVersionProvider schemaVersionProvider;
    private CatalogVersionProvider catalogVersionProvider;
    private Comparator<Definition> orderProvider;
    private boolean includeRelations = true;
    private boolean tableValuedFunctions = true;
    private int logSlowQueriesAfterSeconds;
    private int logSlowResultsAfterSeconds;
    private List<String> inputCatalogs;
    private List<String> inputSchemata;
    private Map<String, List<String>> inputSchemataPerCatalog;
    private List<CatalogDefinition> catalogs;
    private List<SchemaDefinition> schemata;
    private List<SequenceDefinition> sequences;
    private List<IdentityDefinition> identities;
    private List<IndexDefinition> indexes;
    private List<UniqueKeyDefinition> uniqueKeys;
    private List<ForeignKeyDefinition> foreignKeys;
    private List<CheckConstraintDefinition> checkConstraints;
    private List<TableDefinition> tables;
    private List<EmbeddableDefinition> embeddables;
    private List<EnumDefinition> enums;
    private List<DomainDefinition> domains;
    private List<UDTDefinition> udts;
    private List<ArrayDefinition> arrays;
    private List<RoutineDefinition> routines;
    private List<PackageDefinition> packages;
    private Relations relations;
    private transient Map<SchemaDefinition, List<SequenceDefinition>> sequencesBySchema;
    private transient Map<SchemaDefinition, List<IdentityDefinition>> identitiesBySchema;
    private transient Map<SchemaDefinition, List<IndexDefinition>> indexesBySchema;
    private transient Map<TableDefinition, List<IndexDefinition>> indexesByTable;
    private transient Map<SchemaDefinition, List<UniqueKeyDefinition>> uniqueKeysBySchema;
    private transient Map<SchemaDefinition, List<ForeignKeyDefinition>> foreignKeysBySchema;
    private transient Map<SchemaDefinition, List<CheckConstraintDefinition>> checkConstraintsBySchema;
    private transient Map<SchemaDefinition, List<TableDefinition>> tablesBySchema;
    private transient Map<SchemaDefinition, List<EmbeddableDefinition>> embeddablesBySchema;
    private transient Map<TableDefinition, List<EmbeddableDefinition>> embeddablesByTable;
    private transient Map<SchemaDefinition, List<EnumDefinition>> enumsBySchema;
    private transient Map<SchemaDefinition, List<UDTDefinition>> udtsBySchema;
    private transient Map<SchemaDefinition, List<ArrayDefinition>> arraysBySchema;
    private transient Map<SchemaDefinition, List<RoutineDefinition>> routinesBySchema;
    private transient Map<SchemaDefinition, List<PackageDefinition>> packagesBySchema;
    private transient boolean initialised;
    private final List<Definition> all;
    private final List<Definition> included;
    private final List<Definition> excluded;
    private final Map<Table<?>, Boolean> existTables = new HashMap();
    private final Map<TableField<?, ?>, Boolean> existFields = new HashMap();
    private final Patterns patterns = new Patterns();
    private final Statements statements = new Statements();

    protected AbstractDatabase() {
        this.filters = new ArrayList<Database.Filter>();
        this.all = new ArrayList<Definition>();
        this.included = new ArrayList<Definition>();
        this.excluded = new ArrayList<Definition>();
        this.unusedForcedTypes = new HashSet<ForcedType>();
        this.orderProvider = new DefaultOrderProvider();
    }

    @Override
    public final SQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.create().configuration().dialect();
        }
        return this.dialect;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.connection = connection;
        this.statements.dslContext(this.create());
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final DSLContext create() {
        return this.create(false);
    }

    protected final DSLContext create(boolean muteExceptions) {
        Configuration configuration;
        try {
            configuration = this.create0().configuration();
        }
        catch (NoSuchFieldError e) {
            log.error((Object)"NoSuchFieldError may happen when the jOOQ Open Source Edition (Maven groupId 'org.jooq') is used with a commercial SQLDialect. Use an appropriate groupId instead: 'org.jooq.trial', 'org.jooq.pro', 'org.jooq.pro-java-6', or 'org.jooq.pro-java-8'. See also: https://www.jooq.org/doc/latest/manual/getting-started/tutorials/jooq-in-7-steps/jooq-in-7-steps-step1/");
            throw e;
        }
        configuration.settings().setRenderQuotedNames(RenderQuotedNames.NEVER);
        if (muteExceptions) {
            return DSL.using((Configuration)configuration);
        }
        final Settings newSettings = SettingsTools.clone((Settings)configuration.settings()).withRenderFormatted(Boolean.valueOf(true));
        ExecuteListenerProvider[] oldProviders = configuration.executeListenerProviders();
        ExecuteListenerProvider[] newProviders = new ExecuteListenerProvider[oldProviders.length + 1];
        System.arraycopy(oldProviders, 0, newProviders, 0, oldProviders.length);
        newProviders[oldProviders.length] = new DefaultExecuteListenerProvider((ExecuteListener)new DefaultExecuteListener(){

            public void start(ExecuteContext ctx) {
                if (!AbstractDatabase.this.initialised) {
                    try {
                        DSL.using((Configuration)configuration).selectOne().fetch();
                    }
                    catch (DataAccessException ignore) {
                        log.debug((Object)"Error while running init query", (Throwable)ignore);
                    }
                    AbstractDatabase.this.initialised = true;
                }
            }

            public void executeStart(ExecuteContext ctx) {
                ctx.data((Object)"org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.execute", (Object)new StopWatch());
            }

            public void executeEnd(ExecuteContext ctx) {
                int s = AbstractDatabase.this.getLogSlowQueriesAfterSeconds();
                if (s <= 0) {
                    return;
                }
                StopWatch watch = (StopWatch)ctx.data((Object)"org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.execute");
                if (watch.split() > TimeUnit.SECONDS.toNanos(s)) {
                    watch.splitWarn("Slow SQL");
                    log.warn((Object)"Slow SQL", (Object)("jOOQ Meta executed a slow query (slower than " + s + " seconds, configured by configuration/generator/database/logSlowQueriesAfterSeconds)\n\nIf you think this is a bug in jOOQ, please report it here: https://github.com/jOOQ/jOOQ/issues/new\n\n```sql\n" + this.formatted(ctx.query()) + "```\n"), (Throwable)new SQLPerformanceWarning());
                }
            }

            public void fetchStart(ExecuteContext ctx) {
                ctx.data((Object)"org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.fetch", (Object)new StopWatch());
            }

            public void fetchEnd(ExecuteContext ctx) {
                int s = AbstractDatabase.this.getLogSlowResultsAfterSeconds();
                if (s <= 0) {
                    return;
                }
                StopWatch watch = (StopWatch)ctx.data((Object)"org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.fetch");
                if (watch.split() > TimeUnit.SECONDS.toNanos(s)) {
                    watch.splitWarn("Slow Result Fetching");
                    log.warn((Object)"Slow Result Fetching", (Object)("jOOQ Meta fetched a slow result (slower than " + s + " seconds, configured by configuration/generator/database/logSlowResultsAfterSeconds)\n\nIf you think this is a bug in jOOQ, please report it here: https://github.com/jOOQ/jOOQ/issues/new\n\n```sql\n" + this.formatted(ctx.query()) + "```\n"), (Throwable)new SQLPerformanceWarning());
                }
            }

            public void exception(ExecuteContext ctx) {
                log.warn((Object)"SQL exception", (Object)("Exception while executing meta query: " + (ctx.sqlException() != null ? ctx.sqlException().getMessage() : (ctx.exception() != null ? ctx.exception().getMessage() : "No exception available")) + "\n\nIf you think this is a bug in jOOQ, please report it here: https://github.com/jOOQ/jOOQ/issues/new\n\nNote you can mute some exceptions using the configuration/onError flag\n\n```sql\n" + this.formatted(ctx.query()) + "```\n"));
            }

            private String formatted(Query query) {
                return DSL.using((Configuration)configuration.derive(newSettings)).renderInlined((QueryPart)query);
            }

            class SQLPerformanceWarning
            extends Exception {
                SQLPerformanceWarning() {
                }
            }
        });
        return DSL.using((Configuration)configuration.derive(newProviders));
    }

    @Override
    public final boolean exists(TableField<?, ?> field) {
        Boolean result = this.existFields.get(field);
        if (result == null) {
            result = this.exists0(field);
            this.existFields.put(field, result);
        }
        return result;
    }

    protected boolean exists0(TableField<?, ?> field) {
        try {
            this.create(true).select(field).from((TableLike)field.getTable()).where((Condition)DSL.falseCondition()).fetch();
            return true;
        }
        catch (DataAccessException e) {
            return false;
        }
    }

    protected final <R extends Record> boolean exists1(TableField<?, ?> find, Table<R> in, TableField<R, String> schemaQualifier, TableField<R, String> tableQualifier, TableField<R, String> columnQualifier) {
        Condition condition = columnQualifier.eq((Object)find.getName());
        Table table = find.getTable();
        condition = condition.and(tableQualifier.eq((Object)table.getName()));
        Schema schema = table.getSchema();
        if (schema != null) {
            condition = condition.and(schemaQualifier.eq((Object)schema.getName()));
        }
        return this.create().fetchExists(in, condition);
    }

    @Override
    public final boolean existAll(TableField<?, ?> ... f) {
        for (TableField<?, ?> field : f) {
            if (this.exists(field)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean exists(Table<?> table) {
        Boolean result = this.existTables.get(table);
        if (result == null) {
            result = this.exists0(table);
            this.existTables.put(table, result);
        }
        return result;
    }

    protected boolean exists0(Table<?> table) {
        try {
            this.create(true).selectOne().from(table).where((Condition)DSL.falseCondition()).fetch();
            return true;
        }
        catch (DataAccessException e) {
            return false;
        }
    }

    protected final <R extends Record> boolean exists1(Table<?> find, Table<R> in, TableField<R, String> schemaQualifier, TableField<R, String> tableQualifier) {
        Condition condition = tableQualifier.eq((Object)find.getName());
        Schema schema = find.getSchema();
        if (schema != null) {
            condition = condition.and(schemaQualifier.eq((Object)schema.getName()));
        }
        return this.create().fetchExists(in, condition);
    }

    @Override
    public final boolean existAll(Table<?> ... t) {
        for (Table<?> table : t) {
            if (this.exists(table)) continue;
            return false;
        }
        return true;
    }

    final boolean matches(Pattern pattern, Definition definition) {
        if (pattern == null) {
            return false;
        }
        if (!this.getRegexMatchesPartialQualification()) {
            return pattern.matcher(definition.getName()).matches() || pattern.matcher(definition.getQualifiedName()).matches();
        }
        List<Name> parts = Arrays.asList(definition.getQualifiedNamePart().parts());
        for (int i = parts.size() - 1; i >= 0; --i) {
            if (!pattern.matcher(DSL.name((Name[])parts.subList(i, parts.size()).toArray(new Name[0])).unquotedName().toString()).matches()) continue;
            return true;
        }
        return false;
    }

    final boolean matches(Set<?> set, Definition definition) {
        if (set == null) {
            return false;
        }
        if (!this.getSqlMatchesPartialQualification()) {
            return set.contains(definition.getName()) || set.contains(definition.getQualifiedName());
        }
        List<Name> parts = Arrays.asList(definition.getQualifiedNamePart().parts());
        for (int i = parts.size() - 1; i >= 0; --i) {
            if (!set.contains(DSL.name((Name[])parts.subList(i, parts.size()).toArray(new Name[0])).unquotedName().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final List<CatalogDefinition> getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<CatalogDefinition>();
            this.onError(Log.Level.ERROR, "Could not load catalogs", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.catalogs = AbstractDatabase.this.getCatalogs0();
                }
            });
            boolean onlyDefaultCatalog = true;
            Iterator<CatalogDefinition> it = this.catalogs.iterator();
            while (it.hasNext()) {
                CatalogDefinition catalog = it.next();
                if (!StringUtils.isBlank((String)catalog.getName())) {
                    onlyDefaultCatalog = false;
                }
                if (this.getInputCatalogs().contains(catalog.getName())) continue;
                it.remove();
            }
            if (this.catalogs.isEmpty()) {
                if (onlyDefaultCatalog) {
                    log.warn((Object)"No catalogs were loaded", (Object)"Your database reported only a default catalog, which was filtered by your <inputCatalog/> configurations. jOOQ does not support catalogs for all databases, in case of which <inputCatalog/> configurations will not work.");
                } else {
                    log.warn((Object)"No catalogs were loaded", (Object)"Please check your connection settings, and whether your database (and your database version!) is really supported by jOOQ. Also, check the case-sensitivity in your configured <inputCatalog/> elements.");
                }
            }
        }
        return this.catalogs;
    }

    @Override
    public final CatalogDefinition getCatalog(String inputName) {
        for (CatalogDefinition catalog : this.getCatalogs()) {
            if (!catalog.getName().equals(inputName)) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public final List<SchemaDefinition> getSchemata() {
        if (this.schemata == null) {
            this.schemata = new ArrayList<SchemaDefinition>();
            this.onError(Log.Level.ERROR, "Could not load schemata", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.schemata = AbstractDatabase.this.getSchemata0();
                }
            });
            Iterator<SchemaDefinition> it = this.schemata.iterator();
            while (it.hasNext()) {
                SchemaDefinition schema = it.next();
                if (this.getInputSchemata().contains(schema.getName())) continue;
                it.remove();
            }
            if (this.schemata.isEmpty()) {
                log.warn((Object)"No schemata were loaded", (Object)("Please check your connection settings, and whether your database (and your database version!) is really supported by jOOQ. Also, check the case-sensitivity in your configured <inputSchema/> elements : " + this.inputSchemataPerCatalog));
                if (NO_SUPPORT_SCHEMATA.contains(this.getDialect().family())) {
                    log.warn((Object)"No schemata were loaded", (Object)("The database you're using (" + this.getClass().getName() + ") does not support schemata. Consider removing all <inputSchema/> and related configuration : " + this.inputSchemataPerCatalog));
                }
            }
        }
        return this.schemata;
    }

    @Override
    public final List<SchemaDefinition> getSchemata(CatalogDefinition catalog) {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!catalog.equals(schema.getCatalog())) continue;
            result.add(schema);
        }
        return result;
    }

    @Override
    public final SchemaDefinition getSchema(String inputName) {
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!schema.getName().equals(inputName)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public final List<String> getInputCatalogs() {
        if (this.inputCatalogs == null) {
            this.inputCatalogs = new ArrayList<String>();
            if (this.configuredCatalogs.size() == 1 && StringUtils.isBlank((String)this.configuredCatalogs.get(0).getInputCatalog())) {
                this.onError(Log.Level.ERROR, "Could not load catalogs", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        for (CatalogDefinition catalog : AbstractDatabase.this.getCatalogs0()) {
                            AbstractDatabase.this.inputCatalogs.add(catalog.getName());
                        }
                    }
                });
            } else {
                for (CatalogMappingType catalog : this.configuredCatalogs) {
                    this.inputCatalogs.add(catalog.getInputCatalog());
                }
            }
        }
        return this.inputCatalogs;
    }

    @Override
    public final List<String> getInputSchemata() {
        block11: {
            if (this.inputSchemataPerCatalog != null) break block11;
            this.inputSchemata = new ArrayList<String>();
            this.inputSchemataPerCatalog = new LinkedHashMap<String, List<String>>();
            if (this.configuredSchemata.size() == 1 && StringUtils.isBlank((String)this.configuredSchemata.get(0).getInputSchema())) {
                this.initAllSchemata();
            } else if (this.configuredCatalogs.size() == 1 && StringUtils.isBlank((String)this.configuredCatalogs.get(0).getInputCatalog()) && this.configuredCatalogs.get(0).getSchemata().size() == 1 && StringUtils.isBlank((String)this.configuredCatalogs.get(0).getSchemata().get(0).getInputSchema())) {
                this.initAllSchemata();
            } else if (this.configuredCatalogs.isEmpty()) {
                this.inputSchemataPerCatalog.put("", this.inputSchemata);
                for (SchemaMappingType schema : this.configuredSchemata) {
                    this.inputSchemata.add(schema.getInputSchema());
                }
            } else {
                for (CatalogMappingType catalog : this.configuredCatalogs) {
                    for (SchemaMappingType schema : catalog.getSchemata()) {
                        String inputSchema = schema.getInputSchema();
                        this.inputSchemata.add(inputSchema);
                        for (String inputCatalog : this.configuredCatalogs.size() == 1 && StringUtils.isBlank((String)this.configuredCatalogs.get(0).getInputCatalog()) ? this.getInputCatalogs() : Collections.singletonList(catalog.getInputCatalog())) {
                            List<String> list = this.inputSchemataPerCatalog.get(inputCatalog);
                            if (list == null) {
                                list = new ArrayList<String>();
                                this.inputSchemataPerCatalog.put(inputCatalog, list);
                            }
                            list.add(inputSchema);
                        }
                    }
                }
            }
        }
        return this.inputSchemata;
    }

    private void initAllSchemata() {
        this.onError(Log.Level.ERROR, "Could not load schemata", new ExceptionRunnable(){

            @Override
            public void run() throws Exception {
                for (SchemaDefinition schema : AbstractDatabase.this.getSchemata0()) {
                    AbstractDatabase.this.inputSchemata.add(schema.getName());
                    ArrayList<String> list = (ArrayList<String>)AbstractDatabase.this.inputSchemataPerCatalog.get(schema.getCatalog().getName());
                    if (list == null) {
                        list = new ArrayList<String>();
                        AbstractDatabase.this.inputSchemataPerCatalog.put(schema.getCatalog().getName(), list);
                    }
                    list.add(schema.getName());
                }
            }
        });
    }

    @Override
    public final List<String> getInputSchemata(CatalogDefinition catalog) {
        return this.getInputSchemata(catalog.getInputName());
    }

    @Override
    public final List<String> getInputSchemata(String catalog) {
        this.getInputSchemata();
        return this.inputSchemataPerCatalog.containsKey(catalog) ? this.inputSchemataPerCatalog.get(catalog) : Collections.emptyList();
    }

    @Override
    @Deprecated
    public String getOutputCatalog(String inputCatalog) {
        for (CatalogMappingType catalog : this.configuredCatalogs) {
            if (!inputCatalog.equals(catalog.getInputCatalog())) continue;
            return catalog.getOutputCatalog();
        }
        return inputCatalog;
    }

    @Override
    @Deprecated
    public String getOutputSchema(String inputSchema) {
        for (SchemaMappingType schema : this.configuredSchemata) {
            if (!inputSchema.equals(schema.getInputSchema())) continue;
            return schema.getOutputSchema();
        }
        return inputSchema;
    }

    @Override
    public String getOutputSchema(String inputCatalog, String inputSchema) {
        for (CatalogMappingType catalog : this.configuredCatalogs) {
            if (!inputCatalog.equals(catalog.getInputCatalog())) continue;
            for (SchemaMappingType schema : catalog.getSchemata()) {
                if (!inputSchema.equals(schema.getInputSchema())) continue;
                return schema.getOutputSchema();
            }
        }
        return inputSchema;
    }

    @Override
    public final void setConfiguredCatalogs(List<CatalogMappingType> catalogs) {
        this.configuredCatalogs = catalogs;
    }

    @Override
    public final void setConfiguredSchemata(List<SchemaMappingType> schemata) {
        this.configuredSchemata = schemata;
    }

    @Override
    public final void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public final Properties getProperties() {
        return this.properties;
    }

    @Override
    public final void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    @Override
    public final String getBasedir() {
        return this.basedir == null ? new File(".").getAbsolutePath() : this.basedir;
    }

    @Override
    public final void setOnError(OnError onError) {
        this.onError = onError;
    }

    @Override
    public final OnError onError() {
        return this.onError == null ? OnError.FAIL : this.onError;
    }

    @Override
    public final List<Database.Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Database.Filter>();
        }
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public final void addFilter(Database.Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public final void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public final String[] getExcludes() {
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        return this.excludes;
    }

    @Override
    public final void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public final String[] getIncludes() {
        if (this.includes == null) {
            this.includes = new String[0];
        }
        return this.includes;
    }

    @Override
    public final void setIncludeExcludeColumns(boolean includeExcludeColumns) {
        this.includeExcludeColumns = includeExcludeColumns;
    }

    @Override
    public final boolean getIncludeExcludeColumns() {
        return this.includeExcludeColumns;
    }

    @Override
    public final void setIncludeInvisibleColumns(boolean includeInvisibleColumns) {
        this.includeInvisibleColumns = includeInvisibleColumns;
    }

    @Override
    public final boolean getIncludeInvisibleColumns() {
        return this.includeInvisibleColumns;
    }

    @Override
    public final boolean getIncludeTables() {
        return this.includeTables;
    }

    @Override
    public final void setIncludeTables(boolean includeTables) {
        this.includeTables = includeTables;
    }

    @Override
    public final boolean getIncludeEmbeddables() {
        return this.includeEmbeddables;
    }

    @Override
    public final void setIncludeEmbeddables(boolean includeEmbeddables) {
        this.includeEmbeddables = includeEmbeddables;
    }

    @Override
    public final boolean getIncludeRoutines() {
        return this.includeRoutines;
    }

    @Override
    public final void setIncludeRoutines(boolean includeRoutines) {
        this.includeRoutines = includeRoutines;
    }

    @Override
    public void setIncludeTriggerRoutines(boolean includeTriggerRoutines) {
        this.includeTriggerRoutines = includeTriggerRoutines;
    }

    @Override
    public boolean getIncludeTriggerRoutines() {
        return this.includeTriggerRoutines;
    }

    @Override
    public final boolean getIncludePackages() {
        return this.includePackages;
    }

    @Override
    public final void setIncludePackages(boolean includePackages) {
        this.includePackages = includePackages;
    }

    @Override
    public final boolean getIncludePackageRoutines() {
        return this.includePackageRoutines;
    }

    @Override
    public final void setIncludePackageRoutines(boolean includePackageRoutines) {
        this.includePackageRoutines = includePackageRoutines;
    }

    @Override
    public final boolean getIncludePackageUDTs() {
        return this.includePackageUDTs;
    }

    @Override
    public final void setIncludePackageUDTs(boolean includePackageUDTs) {
        this.includePackageUDTs = includePackageUDTs;
    }

    @Override
    public final boolean getIncludePackageConstants() {
        return this.includePackageConstants;
    }

    @Override
    public final void setIncludePackageConstants(boolean includePackageConstants) {
        this.includePackageConstants = includePackageConstants;
    }

    @Override
    public final boolean getIncludeUDTs() {
        return this.includeUDTs;
    }

    @Override
    public final void setIncludeUDTs(boolean includeUDTs) {
        this.includeUDTs = includeUDTs;
    }

    @Override
    public final boolean getIncludeSequences() {
        return this.includeSequences;
    }

    @Override
    public final void setIncludeSequences(boolean includeSequences) {
        this.includeSequences = includeSequences;
    }

    @Override
    public final void setIncludeCheckConstraints(boolean includeCheckConstraints) {
        this.includeCheckConstraints = includeCheckConstraints;
    }

    @Override
    public final boolean getIncludeCheckConstraints() {
        return this.includeCheckConstraints;
    }

    @Override
    public final void setIncludeSystemIndexes(boolean includeSystemIndexes) {
        this.includeSystemIndexes = includeSystemIndexes;
    }

    @Override
    public final boolean getIncludeSystemIndexes() {
        return this.includeSystemIndexes;
    }

    @Override
    public final void setIncludeSystemCheckConstraints(boolean includeSystemCheckConstraints) {
        this.includeSystemCheckConstraints = includeSystemCheckConstraints;
    }

    @Override
    public final boolean getIncludeSystemCheckConstraints() {
        return this.includeSystemCheckConstraints;
    }

    @Override
    public final void setIncludeIndexes(boolean includeIndexes) {
        this.includeIndexes = includeIndexes;
    }

    @Override
    public final boolean getIncludeIndexes() {
        return this.includeIndexes;
    }

    @Override
    public final boolean getIncludePrimaryKeys() {
        return this.includePrimaryKeys;
    }

    @Override
    public final void setIncludePrimaryKeys(boolean includePrimaryKeys) {
        this.includePrimaryKeys = includePrimaryKeys;
    }

    @Override
    public final boolean getIncludeUniqueKeys() {
        return this.includeUniqueKeys;
    }

    @Override
    public final void setIncludeUniqueKeys(boolean includeUniqueKeys) {
        this.includeUniqueKeys = includeUniqueKeys;
    }

    @Override
    public final boolean getIncludeForeignKeys() {
        return this.includeForeignKeys;
    }

    @Override
    public final void setIncludeForeignKeys(boolean includeForeignKeys) {
        this.includeForeignKeys = includeForeignKeys;
    }

    @Override
    public final void setRegexFlags(List<RegexFlag> regexFlags) {
        this.patterns.setRegexFlags(regexFlags);
    }

    @Override
    public final List<RegexFlag> getRegexFlags() {
        return this.patterns.getRegexFlags();
    }

    @Override
    public final void setRegexMatchesPartialQualification(boolean regexMatchesPartialQualification) {
        this.regexMatchesPartialQualification = regexMatchesPartialQualification;
    }

    @Override
    public final boolean getRegexMatchesPartialQualification() {
        return this.regexMatchesPartialQualification;
    }

    @Override
    public final void setSqlMatchesPartialQualification(boolean sqlMatchesPartialQualification) {
        this.sqlMatchesPartialQualification = sqlMatchesPartialQualification;
    }

    @Override
    public final boolean getSqlMatchesPartialQualification() {
        return this.sqlMatchesPartialQualification;
    }

    @Override
    public void setRecordVersionFields(String[] recordVersionFields) {
        this.recordVersionFields = recordVersionFields;
    }

    @Override
    public String[] getRecordVersionFields() {
        if (this.recordVersionFields == null) {
            this.recordVersionFields = new String[0];
        }
        return this.recordVersionFields;
    }

    @Override
    public void setRecordTimestampFields(String[] recordTimestampFields) {
        this.recordTimestampFields = recordTimestampFields;
    }

    @Override
    public String[] getRecordTimestampFields() {
        if (this.recordTimestampFields == null) {
            this.recordTimestampFields = new String[0];
        }
        return this.recordTimestampFields;
    }

    @Override
    public void setSyntheticPrimaryKeys(String[] syntheticPrimaryKeys) {
        this.syntheticPrimaryKeys = syntheticPrimaryKeys;
    }

    @Override
    public String[] getSyntheticPrimaryKeys() {
        if (this.syntheticPrimaryKeys == null) {
            this.syntheticPrimaryKeys = new String[0];
        }
        return this.syntheticPrimaryKeys;
    }

    @Override
    public void setOverridePrimaryKeys(String[] overridePrimaryKeys) {
        this.overridePrimaryKeys = overridePrimaryKeys;
    }

    @Override
    public String[] getOverridePrimaryKeys() {
        if (this.overridePrimaryKeys == null) {
            this.overridePrimaryKeys = new String[0];
        }
        return this.overridePrimaryKeys;
    }

    @Override
    public void setSyntheticIdentities(String[] syntheticIdentities) {
        this.syntheticIdentities = syntheticIdentities;
    }

    @Override
    public final String[] getSyntheticIdentities() {
        if (this.syntheticIdentities == null) {
            this.syntheticIdentities = new String[0];
        }
        return this.syntheticIdentities;
    }

    @Override
    public final void setConfiguredEnumTypes(List<EnumType> configuredEnumTypes) {
        this.configuredEnumTypes = configuredEnumTypes;
    }

    @Override
    public final List<EnumType> getConfiguredEnumTypes() {
        return this.configuredEnumTypes;
    }

    @Override
    @Deprecated
    public final void setConfiguredCustomTypes(List<CustomType> configuredCustomTypes) {
        if (!configuredCustomTypes.isEmpty()) {
            log.warn((Object)"DEPRECATION", (Object)"The <customTypes/> configuration element has been deprecated in jOOQ 3.10. Use <forcedTypes/> only, instead.");
        }
        this.configuredCustomTypes = configuredCustomTypes;
    }

    @Override
    @Deprecated
    public final List<CustomType> getConfiguredCustomTypes() {
        if (this.configuredCustomTypes == null) {
            this.configuredCustomTypes = new ArrayList<CustomType>();
        }
        return this.configuredCustomTypes;
    }

    @Override
    @Deprecated
    public final CustomType getConfiguredCustomType(String typeName) {
        if (typeName == null) {
            return null;
        }
        Iterator<CustomType> it1 = this.configuredCustomTypes.iterator();
        while (it1.hasNext()) {
            CustomType type = it1.next();
            if (type == null || type.getName() == null && type.getType() == null) {
                log.warn((Object)("Invalid custom type encountered: " + type));
                it1.remove();
                continue;
            }
            if (!StringUtils.equals((String)(type.getType() != null ? type.getType() : type.getName()), (String)typeName)) continue;
            return type;
        }
        Iterator<ForcedType> it2 = this.configuredForcedTypes.iterator();
        while (it2.hasNext()) {
            ForcedType type = it2.next();
            if (type.getExpressions() != null) {
                type.setIncludeExpression(type.getExpressions());
                type.setExpressions(null);
                log.warn((Object)"DEPRECATED", (Object)("The <expressions/> element in <forcedType/> is deprecated. Use <includeExpression/> instead: " + type));
            }
            if (type.getExpression() != null) {
                type.setIncludeExpression(type.getExpression());
                type.setExpression(null);
                log.warn((Object)"DEPRECATED", (Object)("The <expression/> element in <forcedType/> is deprecated. Use <includeExpression/> instead: " + type));
            }
            if (type.getTypes() != null) {
                type.setIncludeTypes(type.getTypes());
                type.setTypes(null);
                log.warn((Object)"DEPRECATED", (Object)("The <types/> element in <forcedType/> is deprecated. Use <includeTypes/> instead: " + type));
            }
            if (StringUtils.isBlank((String)type.getName())) {
                if (StringUtils.isBlank((String)type.getUserType())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. Either <name/> or <userType/> is required: " + type));
                    it2.remove();
                    continue;
                }
                if (StringUtils.isBlank((String)type.getBinding()) && StringUtils.isBlank((String)type.getConverter()) && !Boolean.TRUE.equals(type.isEnumConverter())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. Either <binding/> or <converter/> or <enumConverter/> is required: " + type));
                    it2.remove();
                    continue;
                }
            } else {
                if (!StringUtils.isBlank((String)type.getUserType())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <userType/> is not allowed when <name/> is provided: " + type));
                    type.setUserType(null);
                }
                if (!StringUtils.isBlank((String)type.getBinding())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <binding/> is not allowed when <name/> is provided: " + type));
                    type.setBinding(null);
                }
                if (!StringUtils.isBlank((String)type.getConverter())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <converter/> is not allowed when <name/> is provided: " + type));
                    type.setConverter(null);
                }
                if (Boolean.TRUE.equals(type.isEnumConverter())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <enumConverter/> is not allowed when <name/> is provided: " + type));
                    type.setEnumConverter(null);
                }
            }
            if (type.getUserType() == null || !StringUtils.equals((String)type.getUserType(), (String)typeName)) continue;
            return AbstractTypedElementDefinition.customType(this, type);
        }
        return null;
    }

    @Override
    public void markUsed(ForcedType forcedType) {
        this.unusedForcedTypes.remove(forcedType);
    }

    @Override
    public List<ForcedType> getUnusedForcedTypes() {
        return new ArrayList<ForcedType>(this.unusedForcedTypes);
    }

    @Override
    public final void setConfiguredForcedTypes(List<ForcedType> configuredForcedTypes) {
        this.getConfiguredForcedTypes().addAll(configuredForcedTypes);
        this.unusedForcedTypes.addAll(configuredForcedTypes);
    }

    @Override
    public final List<ForcedType> getConfiguredForcedTypes() {
        if (this.configuredForcedTypes == null) {
            this.configuredForcedTypes = new ArrayList<ForcedType>();
        }
        return this.configuredForcedTypes;
    }

    @Override
    public final int getLogSlowQueriesAfterSeconds() {
        return this.logSlowQueriesAfterSeconds;
    }

    @Override
    public final void setLogSlowQueriesAfterSeconds(int logSlowQueriesAfterSeconds) {
        this.logSlowQueriesAfterSeconds = logSlowQueriesAfterSeconds;
    }

    @Override
    public final int getLogSlowResultsAfterSeconds() {
        return this.logSlowResultsAfterSeconds;
    }

    @Override
    public final void setLogSlowResultsAfterSeconds(int logSlowResultsAfterSeconds) {
        this.logSlowResultsAfterSeconds = logSlowResultsAfterSeconds;
    }

    @Override
    public final SchemaVersionProvider getSchemaVersionProvider() {
        return this.schemaVersionProvider;
    }

    @Override
    public final void setSchemaVersionProvider(SchemaVersionProvider schemaVersionProvider) {
        this.schemaVersionProvider = schemaVersionProvider;
    }

    @Override
    public final CatalogVersionProvider getCatalogVersionProvider() {
        return this.catalogVersionProvider;
    }

    @Override
    public final void setCatalogVersionProvider(CatalogVersionProvider catalogVersionProvider) {
        this.catalogVersionProvider = catalogVersionProvider;
    }

    @Override
    public final Comparator<Definition> getOrderProvider() {
        return this.orderProvider;
    }

    @Override
    public final void setOrderProvider(Comparator<Definition> provider) {
        this.orderProvider = provider;
    }

    @Override
    public final void setSupportsUnsignedTypes(boolean supportsUnsignedTypes) {
        this.supportsUnsignedTypes = supportsUnsignedTypes;
    }

    @Override
    public final boolean supportsUnsignedTypes() {
        return this.supportsUnsignedTypes;
    }

    @Override
    public final void setIntegerDisplayWidths(boolean integerDisplayWidths) {
        this.integerDisplayWidths = integerDisplayWidths;
    }

    @Override
    public final boolean integerDisplayWidths() {
        return this.integerDisplayWidths;
    }

    @Override
    public final void setIgnoreProcedureReturnValues(boolean ignoreProcedureReturnValues) {
        this.ignoreProcedureReturnValues = ignoreProcedureReturnValues;
    }

    @Override
    public final boolean ignoreProcedureReturnValues() {
        return this.ignoreProcedureReturnValues;
    }

    @Override
    public final void setDateAsTimestamp(boolean dateAsTimestamp) {
        this.dateAsTimestamp = dateAsTimestamp;
    }

    @Override
    public final boolean dateAsTimestamp() {
        return this.dateAsTimestamp;
    }

    @Override
    public final void setJavaTimeTypes(boolean javaTimeTypes) {
        this.javaTimeTypes = javaTimeTypes;
    }

    @Override
    public final boolean javaTimeTypes() {
        return this.javaTimeTypes;
    }

    @Override
    public final void setIncludeRelations(boolean includeRelations) {
        this.includeRelations = includeRelations;
    }

    @Override
    public final boolean includeRelations() {
        return this.includeRelations;
    }

    @Override
    public void setForceIntegerTypesOnZeroScaleDecimals(boolean forceIntegerTypesOnZeroScaleDecimals) {
        this.forceIntegerTypesOnZeroScaleDecimals = forceIntegerTypesOnZeroScaleDecimals;
    }

    @Override
    public boolean getForceIntegerTypesOnZeroScaleDecimals() {
        return this.forceIntegerTypesOnZeroScaleDecimals;
    }

    @Override
    public final void setTableValuedFunctions(boolean tableValuedFunctions) {
        this.tableValuedFunctions = tableValuedFunctions;
    }

    @Override
    public final boolean tableValuedFunctions() {
        return this.tableValuedFunctions;
    }

    @Override
    public final List<SequenceDefinition> getSequences(SchemaDefinition schema) {
        if (this.sequences == null) {
            this.sequences = new ArrayList<SequenceDefinition>();
            if (this.getIncludeSequences()) {
                this.onError(Log.Level.ERROR, "Error while fetching sequences", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<SequenceDefinition> s = AbstractDatabase.this.getSequences0();
                        AbstractDatabase.this.sequences = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(s));
                        log.info((Object)"Sequences fetched", (Object)AbstractDatabase.fetchedSize(s, AbstractDatabase.this.sequences));
                    }
                });
            } else {
                log.info((Object)"Sequences excluded");
            }
        }
        if (this.sequencesBySchema == null) {
            this.sequencesBySchema = new LinkedHashMap<SchemaDefinition, List<SequenceDefinition>>();
        }
        return this.filterSchema(this.sequences, schema, this.sequencesBySchema);
    }

    @Override
    public final List<IdentityDefinition> getIdentities(SchemaDefinition schema) {
        if (this.identities == null) {
            this.identities = new ArrayList<IdentityDefinition>();
            for (SchemaDefinition s : this.getSchemata()) {
                for (TableDefinition table : this.getTables(s)) {
                    IdentityDefinition identity = table.getIdentity();
                    if (identity == null) continue;
                    this.identities.add(identity);
                }
            }
        }
        if (this.identitiesBySchema == null) {
            this.identitiesBySchema = new LinkedHashMap<SchemaDefinition, List<IdentityDefinition>>();
        }
        return this.filterSchema(this.identities, schema, this.identitiesBySchema);
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys(SchemaDefinition schema) {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new ArrayList<UniqueKeyDefinition>();
            if (this.getIncludeUniqueKeys() || this.getIncludePrimaryKeys()) {
                for (SchemaDefinition s : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s)) {
                        for (UniqueKeyDefinition uniqueKey : table.getUniqueKeys()) {
                            this.uniqueKeys.add(uniqueKey);
                        }
                    }
                }
            }
        }
        if (this.uniqueKeysBySchema == null) {
            this.uniqueKeysBySchema = new LinkedHashMap<SchemaDefinition, List<UniqueKeyDefinition>>();
        }
        return this.filterSchema(this.uniqueKeys, schema, this.uniqueKeysBySchema);
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys(SchemaDefinition schema) {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKeyDefinition>();
            if (this.getIncludeForeignKeys()) {
                for (SchemaDefinition s : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s)) {
                        for (ForeignKeyDefinition foreignKey : table.getForeignKeys()) {
                            this.foreignKeys.add(foreignKey);
                        }
                    }
                }
            }
        }
        if (this.foreignKeysBySchema == null) {
            this.foreignKeysBySchema = new LinkedHashMap<SchemaDefinition, List<ForeignKeyDefinition>>();
        }
        return this.filterSchema(this.foreignKeys, schema, this.foreignKeysBySchema);
    }

    @Override
    public final List<CheckConstraintDefinition> getCheckConstraints(SchemaDefinition schema) {
        if (this.checkConstraints == null) {
            this.checkConstraints = new ArrayList<CheckConstraintDefinition>();
            if (this.getIncludeCheckConstraints()) {
                for (SchemaDefinition s : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s)) {
                        for (CheckConstraintDefinition checkConstraint : table.getCheckConstraints()) {
                            this.checkConstraints.add(checkConstraint);
                        }
                    }
                }
            }
        }
        if (this.checkConstraintsBySchema == null) {
            this.checkConstraintsBySchema = new LinkedHashMap<SchemaDefinition, List<CheckConstraintDefinition>>();
        }
        return this.filterSchema(this.checkConstraints, schema, this.checkConstraintsBySchema);
    }

    @Override
    public final List<TableDefinition> getTables(SchemaDefinition schema) {
        if (this.tables == null) {
            this.tables = new ArrayList<TableDefinition>();
            if (this.getIncludeTables()) {
                this.onError(Log.Level.ERROR, "Error while fetching tables", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<TableDefinition> t = AbstractDatabase.this.getTables0();
                        AbstractDatabase.this.tables = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(t));
                        log.info((Object)"Tables fetched", (Object)AbstractDatabase.fetchedSize(t, AbstractDatabase.this.tables));
                    }
                });
            } else {
                log.info((Object)"Tables excluded");
            }
        }
        if (this.tablesBySchema == null) {
            this.tablesBySchema = new LinkedHashMap<SchemaDefinition, List<TableDefinition>>();
        }
        return this.filterSchema(this.tables, schema, this.tablesBySchema);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name) {
        return this.getTable(schema, name, false);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getTables(schema), name, ignoreCase);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, Name name) {
        return this.getTable(schema, name, false);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getTables(schema), name, ignoreCase);
    }

    @Override
    public final List<EnumDefinition> getEnums(SchemaDefinition schema) {
        if (this.enums == null) {
            this.enums = new ArrayList<EnumDefinition>();
            this.onError(Log.Level.ERROR, "Error while fetching enums", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    List<EnumDefinition> e = AbstractDatabase.this.getEnums0();
                    AbstractDatabase.this.enums = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(e));
                    AbstractDatabase.this.enums.addAll(AbstractDatabase.this.getConfiguredEnums());
                    log.info((Object)"Enums fetched", (Object)AbstractDatabase.fetchedSize(e, AbstractDatabase.this.enums));
                }
            });
        }
        if (this.enumsBySchema == null) {
            this.enumsBySchema = new LinkedHashMap<SchemaDefinition, List<EnumDefinition>>();
        }
        return this.filterSchema(this.enums, schema, this.enumsBySchema);
    }

    private final List<EnumDefinition> getConfiguredEnums() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>(this.configuredCustomTypes.size());
        for (EnumType enumType : this.configuredEnumTypes) {
            String name = enumType.getName();
            DefaultEnumDefinition e = new DefaultEnumDefinition(this.getSchemata().get(0), name, null, true);
            String literals = enumType.getLiterals();
            try {
                CSVReader reader = new CSVReader((Reader)new StringReader(literals));
                e.addLiterals(reader.readNext());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(e);
        }
        return result;
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition) {
        return this.getConfiguredForcedType(definition, null);
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition, DataTypeDefinition definedType) {
        for (ForcedType forcedType : this.getConfiguredForcedTypes()) {
            String excludeExpression = forcedType.getExcludeExpression();
            String includeExpression = (String)StringUtils.firstNonNull((Object[])new String[]{forcedType.getIncludeExpression(), forcedType.getExpression(), forcedType.getExpressions()});
            String excludeTypes = forcedType.getExcludeTypes();
            String includeTypes = (String)StringUtils.firstNonNull((Object[])new String[]{forcedType.getIncludeTypes(), forcedType.getTypes()});
            Nullability nullability = forcedType.getNullability();
            ForcedTypeObjectType objectType = forcedType.getObjectType();
            String sql = forcedType.getSql();
            if (objectType != null && objectType != ForcedTypeObjectType.ALL && (objectType == ForcedTypeObjectType.ATTRIBUTE && !(definition instanceof AttributeDefinition) || objectType == ForcedTypeObjectType.COLUMN && !(definition instanceof ColumnDefinition) || objectType == ForcedTypeObjectType.ELEMENT && !(definition instanceof ArrayDefinition) || objectType == ForcedTypeObjectType.PARAMETER && !(definition instanceof ParameterDefinition) || objectType == ForcedTypeObjectType.SEQUENCE && !(definition instanceof SequenceDefinition)) || nullability != null && nullability != Nullability.ALL && definedType != null && (nullability == Nullability.NOT_NULL && definedType.isNullable() || nullability == Nullability.NULL && !definedType.isNullable()) || excludeExpression != null && this.matches(this.patterns.pattern(excludeExpression), definition) || includeExpression != null && !this.matches(this.patterns.pattern(includeExpression), definition) || definedType != null && (excludeTypes != null || includeTypes != null) && !this.typeMatchesExcludeInclude(definedType, excludeTypes, includeTypes) || sql != null && !this.matches(this.statements.fetchSet(sql), definition)) continue;
            return forcedType;
        }
        return null;
    }

    private boolean typeMatchesExcludeInclude(DataTypeDefinition type, String exclude, String include) {
        if (exclude != null && this.matches(type, this.patterns.pattern(exclude))) {
            return false;
        }
        return include == null || this.matches(type, this.patterns.pattern(include));
    }

    private boolean matches(DataTypeDefinition type, Pattern pattern) {
        return pattern.matcher(type.getType()).matches() || type.getLength() != 0 && pattern.matcher(type.getType() + "(" + type.getLength() + ")").matches() || type.getScale() == 0 && pattern.matcher(type.getType() + "(" + type.getPrecision() + ")").matches() || pattern.matcher(type.getType() + "(" + type.getPrecision() + "," + type.getScale() + ")").matches() || pattern.matcher(type.getType() + "(" + type.getPrecision() + ", " + type.getScale() + ")").matches() || !StringUtils.isBlank((String)type.getUserType()) && (pattern.matcher(type.getUserType()).matches() || pattern.matcher(type.getQualifiedUserType().unquotedName().toString()).matches());
    }

    @Override
    public final void setConfiguredEmbeddables(List<Embeddable> configuredEmbeddables) {
        this.configuredEmbeddables = configuredEmbeddables;
    }

    @Override
    public final List<Embeddable> getConfiguredEmbeddables() {
        if (this.configuredEmbeddables == null) {
            this.configuredEmbeddables = new ArrayList<Embeddable>();
        }
        return this.configuredEmbeddables;
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables() {
        ArrayList<EmbeddableDefinition> result = new ArrayList<EmbeddableDefinition>();
        for (SchemaDefinition schema : this.getSchemata()) {
            for (TableDefinition table : this.getTables(schema)) {
                for (Embeddable embeddable : this.getConfiguredEmbeddables()) {
                    ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
                    ArrayList<String> names = new ArrayList<String>();
                    for (EmbeddableField embeddableField : embeddable.getFields()) {
                        boolean matched = false;
                        for (ColumnDefinition column : table.getColumns()) {
                            if (!this.matches(this.patterns.pattern(embeddableField.getExpression()), (Definition)column)) continue;
                            if (matched) {
                                log.warn((Object)("EmbeddableField configuration matched several columns in table " + table + ": " + embeddableField));
                                continue;
                            }
                            matched = columns.add(column) && names.add(StringUtils.defaultIfEmpty((String)embeddableField.getName(), (String)column.getName()));
                        }
                    }
                    if (columns.size() != embeddable.getFields().size()) continue;
                    result.add(new DefaultEmbeddableDefinition(embeddable.getName(), names, table, columns));
                }
            }
        }
        return result;
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables(SchemaDefinition schema) {
        if (this.embeddables == null) {
            this.embeddables = new ArrayList<EmbeddableDefinition>();
            if (this.getIncludeEmbeddables()) {
                this.onError(Log.Level.ERROR, "Error while fetching embeddables", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<EmbeddableDefinition> r = AbstractDatabase.this.getEmbeddables();
                        AbstractDatabase.this.embeddables = AbstractDatabase.this.sort(r);
                        log.info((Object)"Embeddables fetched", (Object)AbstractDatabase.fetchedSize(r, AbstractDatabase.this.embeddables));
                    }
                });
            } else {
                log.info((Object)"Embeddables excluded");
            }
        }
        if (this.embeddablesBySchema == null) {
            this.embeddablesBySchema = new LinkedHashMap<SchemaDefinition, List<EmbeddableDefinition>>();
        }
        return this.filterSchema(this.embeddables, schema, this.embeddablesBySchema);
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables(TableDefinition table) {
        if (this.embeddablesByTable == null) {
            this.embeddablesByTable = new LinkedHashMap<TableDefinition, List<EmbeddableDefinition>>();
        }
        return this.filterTable(this.getEmbeddables(table.getSchema()), table, this.embeddablesByTable);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name) {
        return this.getEnum(schema, name, false);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getEnums(schema), name, ignoreCase);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, Name name) {
        return this.getEnum(schema, name, false);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getEnums(schema), name, ignoreCase);
    }

    @Override
    public final List<DomainDefinition> getDomains(SchemaDefinition schema) {
        if (this.domains == null) {
            this.domains = new ArrayList<DomainDefinition>();
            this.onError(Log.Level.ERROR, "Error while fetching domains", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    List<DomainDefinition> e = AbstractDatabase.this.getDomains0();
                    AbstractDatabase.this.domains = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(e));
                    log.info((Object)"Domains fetched", (Object)AbstractDatabase.fetchedSize(e, AbstractDatabase.this.domains));
                }
            });
        }
        return this.domains;
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, String name) {
        return this.getDomain(schema, name, false);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getDomains(schema), name, ignoreCase);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, Name name) {
        return this.getDomain(schema, name, false);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getDomains(schema), name, ignoreCase);
    }

    @Override
    public final List<ArrayDefinition> getArrays(SchemaDefinition schema) {
        if (this.arrays == null) {
            this.arrays = new ArrayList<ArrayDefinition>();
            if (this.getIncludeUDTs()) {
                this.onError(Log.Level.ERROR, "Error while fetching ARRAYs", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<ArrayDefinition> a = AbstractDatabase.this.getArrays0();
                        AbstractDatabase.this.arrays = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(a));
                        log.info((Object)"ARRAYs fetched", (Object)AbstractDatabase.fetchedSize(a, AbstractDatabase.this.arrays));
                    }
                });
            } else {
                log.info((Object)"ARRAYs excluded");
            }
        }
        if (this.arraysBySchema == null) {
            this.arraysBySchema = new LinkedHashMap<SchemaDefinition, List<ArrayDefinition>>();
        }
        return this.filterSchema(this.arrays, schema, this.arraysBySchema);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name) {
        return this.getArray(schema, name, false);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getArrays(schema), name, ignoreCase);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, Name name) {
        return this.getArray(schema, name, false);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getArrays(schema), name, ignoreCase);
    }

    private final List<UDTDefinition> getAllUDTs(SchemaDefinition schema) {
        if (this.udts == null) {
            this.udts = new ArrayList<UDTDefinition>();
            if (this.getIncludeUDTs()) {
                this.onError(Log.Level.ERROR, "Error while fetching UDTs", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<UDTDefinition> u = AbstractDatabase.this.getUDTs0();
                        AbstractDatabase.this.udts = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(u));
                        log.info((Object)"UDTs fetched", (Object)AbstractDatabase.fetchedSize(u, AbstractDatabase.this.udts));
                    }
                });
            } else {
                log.info((Object)"UDTs excluded");
            }
        }
        if (this.udtsBySchema == null) {
            this.udtsBySchema = new LinkedHashMap<SchemaDefinition, List<UDTDefinition>>();
        }
        return this.filterSchema(this.udts, schema, this.udtsBySchema);
    }

    private final List<UDTDefinition> ifInPackage(List<UDTDefinition> allUDTs, boolean expected) {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (UDTDefinition u : allUDTs) {
            if (u.getPackage() != null != expected) continue;
            result.add(u);
        }
        return result;
    }

    @Override
    public final List<UDTDefinition> getUDTs(SchemaDefinition schema) {
        return this.getAllUDTs(schema);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name) {
        return this.getUDT(schema, name, false);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getUDTs(schema), name, ignoreCase);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, Name name) {
        return this.getUDT(schema, name, false);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getUDTs(schema), name, ignoreCase);
    }

    @Override
    public final List<UDTDefinition> getUDTs(PackageDefinition pkg) {
        return this.ifInPackage(this.getAllUDTs(pkg.getSchema()), true);
    }

    @Override
    public final Relations getRelations() {
        if (this.relations == null) {
            this.relations = new DefaultRelations();
            if (this.includeRelations) {
                this.onError(Log.Level.ERROR, "Error while fetching relations", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        AbstractDatabase.this.relations = AbstractDatabase.this.getRelations0();
                    }
                });
            }
        }
        return this.relations;
    }

    @Override
    public final List<IndexDefinition> getIndexes(SchemaDefinition schema) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<IndexDefinition>();
            if (this.getIncludeIndexes()) {
                this.onError(Log.Level.ERROR, "Error while fetching indexes", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<IndexDefinition> r = AbstractDatabase.this.getIndexes0();
                        AbstractDatabase.this.indexes = AbstractDatabase.this.sort(r);
                        log.info((Object)"Indexes fetched", (Object)AbstractDatabase.fetchedSize(r, AbstractDatabase.this.indexes));
                    }
                });
            } else {
                log.info((Object)"Indexes excluded");
            }
        }
        if (this.indexesBySchema == null) {
            this.indexesBySchema = new LinkedHashMap<SchemaDefinition, List<IndexDefinition>>();
        }
        return this.filterSchema(this.indexes, schema, this.indexesBySchema);
    }

    @Override
    public final List<IndexDefinition> getIndexes(TableDefinition table) {
        List<IndexDefinition> list;
        if (this.indexesByTable == null) {
            this.indexesByTable = new HashMap<TableDefinition, List<IndexDefinition>>();
        }
        if ((list = this.indexesByTable.get(table)) == null) {
            list = new ArrayList<IndexDefinition>();
            this.indexesByTable.put(table, list);
            for (TableDefinition otherTable : this.getTables(table.getSchema())) {
                if (this.indexesByTable.containsKey(otherTable)) continue;
                this.indexesByTable.put(otherTable, new ArrayList());
            }
            for (IndexDefinition index : this.getIndexes(table.getSchema())) {
                List<IndexDefinition> otherList = this.indexesByTable.get(index.getTable());
                if (otherList == null) {
                    otherList = new ArrayList<IndexDefinition>();
                    this.indexesByTable.put(index.getTable(), otherList);
                }
                otherList.add(index);
            }
        }
        return list;
    }

    @Override
    public final List<RoutineDefinition> getRoutines(SchemaDefinition schema) {
        if (this.routines == null) {
            this.routines = new ArrayList<RoutineDefinition>();
            if (this.getIncludeRoutines()) {
                this.onError(Log.Level.ERROR, "Error while fetching routines", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<RoutineDefinition> r = AbstractDatabase.this.getRoutines0();
                        AbstractDatabase.this.routines = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(r));
                        log.info((Object)"Routines fetched", (Object)AbstractDatabase.fetchedSize(r, AbstractDatabase.this.routines));
                    }
                });
            } else {
                log.info((Object)"Routines excluded");
            }
        }
        if (this.routinesBySchema == null) {
            this.routinesBySchema = new LinkedHashMap<SchemaDefinition, List<RoutineDefinition>>();
        }
        return this.filterSchema(this.routines, schema, this.routinesBySchema);
    }

    @Override
    public final List<PackageDefinition> getPackages(SchemaDefinition schema) {
        if (this.packages == null) {
            this.packages = new ArrayList<PackageDefinition>();
            if (this.getIncludePackages()) {
                this.onError(Log.Level.ERROR, "Error while fetching packages", new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        List<PackageDefinition> p = AbstractDatabase.this.getPackages0();
                        AbstractDatabase.this.packages = AbstractDatabase.this.sort(AbstractDatabase.this.filterExcludeInclude(p));
                        log.info((Object)"Packages fetched", (Object)AbstractDatabase.fetchedSize(p, AbstractDatabase.this.packages));
                    }
                });
            } else {
                log.info((Object)"Packages excluded");
            }
        }
        if (this.packagesBySchema == null) {
            this.packagesBySchema = new LinkedHashMap<SchemaDefinition, List<PackageDefinition>>();
        }
        return this.filterSchema(this.packages, schema, this.packagesBySchema);
    }

    @Override
    public PackageDefinition getPackage(SchemaDefinition schema, String inputName) {
        for (PackageDefinition pkg : this.getPackages(schema)) {
            if (!pkg.getName().equals(inputName)) continue;
            return pkg;
        }
        return null;
    }

    protected static final <D extends Definition> D getDefinition(List<D> definitions, String name, boolean ignoreCase) {
        if (name == null) {
            return null;
        }
        for (Definition definition : definitions) {
            if ((!ignoreCase || !definition.getName().equalsIgnoreCase(name)) && (ignoreCase || !definition.getName().equals(name))) continue;
            return (D)definition;
        }
        return null;
    }

    protected static final <D extends Definition> D getDefinition(List<D> definitions, Name name, boolean ignoreCase) {
        if (name == null) {
            return null;
        }
        for (Definition definition : definitions) {
            if ((!ignoreCase || !definition.getQualifiedNamePart().equalsIgnoreCase(name)) && (ignoreCase || !definition.getQualifiedNamePart().equals((Object)name))) continue;
            return (D)definition;
        }
        return null;
    }

    protected final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema, Map<SchemaDefinition, List<T>> cache) {
        List<T> result = cache.get(schema);
        if (result == null) {
            result = this.filterSchema(definitions, schema);
            cache.put(schema, result);
        }
        return result;
    }

    protected final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema) {
        if (schema == null) {
            return definitions;
        }
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (Definition definition : definitions) {
            if (!definition.getSchema().equals(schema)) continue;
            result.add(definition);
        }
        return result;
    }

    protected final <T extends TableElementDefinition> List<T> filterTable(List<T> definitions, TableDefinition table, Map<TableDefinition, List<T>> cache) {
        List<T> result = cache.get(table);
        if (result == null) {
            result = this.filterTable(definitions, table);
            cache.put(table, result);
        }
        return result;
    }

    protected final <T extends TableElementDefinition> List<T> filterTable(List<T> definitions, TableDefinition table) {
        if (table == null) {
            return definitions;
        }
        ArrayList<TableElementDefinition> result = new ArrayList<TableElementDefinition>();
        for (TableElementDefinition definition : definitions) {
            if (!definition.getTable().equals(table)) continue;
            result.add(definition);
        }
        return result;
    }

    public final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions) {
        List<T> result = this.filterExcludeInclude(definitions, this.excludes, this.includes, this.filters);
        this.all.addAll(definitions);
        this.included.addAll(result);
        this.excluded.addAll(definitions);
        this.excluded.removeAll(result);
        return result;
    }

    public final <T extends Definition> List<T> sort(List<T> definitions) {
        if (this.orderProvider != null) {
            Collections.sort(definitions, this.orderProvider);
        }
        return definitions;
    }

    @Override
    public final List<Definition> getIncluded() {
        return Collections.unmodifiableList(this.included);
    }

    @Override
    public final List<Definition> getExcluded() {
        return Collections.unmodifiableList(this.excluded);
    }

    @Override
    public final List<Definition> getAll() {
        return Collections.unmodifiableList(this.all);
    }

    protected final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions, String[] e, String[] i, List<Database.Filter> f) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        block0: for (Definition definition : definitions) {
            if (e != null) {
                for (String exclude : e) {
                    if (exclude == null || !this.matches(this.patterns.pattern(exclude), definition)) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)"Exclude", (Object)("Excluding " + definition.getQualifiedName() + " because of pattern " + exclude));
                    continue block0;
                }
            }
            if (i == null) continue;
            for (String include : i) {
                if (include == null || !this.matches(this.patterns.pattern(include), definition)) continue;
                for (Database.Filter filter : f) {
                    if (!filter.exclude(definition)) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)"Exclude", (Object)("Excluding " + definition.getQualifiedName() + " because of filter " + filter));
                    continue block0;
                }
                result.add(definition);
                if (!log.isDebugEnabled()) continue block0;
                log.debug((Object)"Include", (Object)("Including " + definition.getQualifiedName() + " because of pattern " + include));
                continue block0;
            }
        }
        return result;
    }

    protected final Relations getRelations0() {
        final DefaultRelations result = new DefaultRelations();
        if (this.getIncludePrimaryKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching primary keys", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.loadPrimaryKeys(result);
                }
            });
        }
        if (this.getIncludeUniqueKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching unique keys", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.loadUniqueKeys(result);
                }
            });
        }
        if (this.getIncludeForeignKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching foreign keys", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.loadForeignKeys(result);
                }
            });
        }
        if (this.getIncludeCheckConstraints()) {
            this.onError(Log.Level.ERROR, "Error while fetching check constraints", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.loadCheckConstraints(result);
                }
            });
        }
        if (this.getIncludePrimaryKeys()) {
            this.onError(Log.Level.ERROR, "Error while generating synthetic primary keys", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.syntheticPrimaryKeys(result);
                }
            });
        }
        if (this.getIncludePrimaryKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching domains", new ExceptionRunnable(){

                @Override
                public void run() throws Exception {
                    AbstractDatabase.this.overridePrimaryKeys(result);
                }
            });
        }
        return result;
    }

    @Override
    public final boolean isArrayType(String dataType) {
        switch (this.getDialect().family()) {
            case POSTGRES: 
            case H2: {
                return "ARRAY".equals(dataType);
            }
            case HSQLDB: {
                return dataType.endsWith(" ARRAY");
            }
        }
        return false;
    }

    protected static final String fetchedSize(List<?> fetched, List<?> included) {
        return fetched.size() + " (" + included.size() + " included, " + (fetched.size() - included.size()) + " excluded)";
    }

    private final void syntheticPrimaryKeys(DefaultRelations r) {
        ArrayList<DefaultUniqueKeyDefinition> syntheticKeys = new ArrayList<DefaultUniqueKeyDefinition>();
        for (SchemaDefinition schemaDefinition : this.getSchemata()) {
            for (TableDefinition table : schemaDefinition.getTables()) {
                List<ColumnDefinition> columns = this.filterExcludeInclude(table.getColumns(), null, this.getSyntheticPrimaryKeys(), this.filters);
                if (columns.isEmpty()) continue;
                DefaultUniqueKeyDefinition syntheticKey = new DefaultUniqueKeyDefinition(schemaDefinition, "SYNTHETIC_PK_" + table.getName(), table, true);
                syntheticKey.getKeyColumns().addAll(columns);
                syntheticKeys.add(syntheticKey);
            }
        }
        log.info((Object)"Synthetic primary keys", (Object)AbstractDatabase.fetchedSize(syntheticKeys, syntheticKeys));
        for (UniqueKeyDefinition uniqueKeyDefinition : syntheticKeys) {
            r.overridePrimaryKey(uniqueKeyDefinition);
        }
    }

    private final void overridePrimaryKeys(DefaultRelations r) {
        List<UniqueKeyDefinition> allKeys = r.getUniqueKeys();
        List<UniqueKeyDefinition> filteredKeys = this.filterExcludeInclude(allKeys, null, this.overridePrimaryKeys, this.filters);
        log.info((Object)"Overriding primary keys", (Object)AbstractDatabase.fetchedSize(allKeys, filteredKeys));
        for (UniqueKeyDefinition key : filteredKeys) {
            r.overridePrimaryKey(key);
        }
    }

    @Override
    public void close() {
    }

    protected abstract DSLContext create0();

    protected List<IndexDefinition> getIndexes0() throws SQLException {
        return Collections.emptyList();
    }

    protected abstract void loadPrimaryKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadUniqueKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadForeignKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadCheckConstraints(DefaultRelations var1) throws SQLException;

    protected abstract List<CatalogDefinition> getCatalogs0() throws SQLException;

    protected abstract List<SchemaDefinition> getSchemata0() throws SQLException;

    protected abstract List<SequenceDefinition> getSequences0() throws SQLException;

    protected abstract List<TableDefinition> getTables0() throws SQLException;

    protected abstract List<RoutineDefinition> getRoutines0() throws SQLException;

    protected abstract List<PackageDefinition> getPackages0() throws SQLException;

    protected abstract List<EnumDefinition> getEnums0() throws SQLException;

    protected abstract List<DomainDefinition> getDomains0() throws SQLException;

    protected abstract List<UDTDefinition> getUDTs0() throws SQLException;

    protected abstract List<ArrayDefinition> getArrays0() throws SQLException;

    protected final DataTypeDefinition getDataTypeForMAX_VAL(SchemaDefinition schema, BigInteger value) {
        DefaultDataTypeDefinition type = BigInteger.valueOf(127L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)2, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(32767L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)4, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)9, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(Long.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)18, (Number)0, (Boolean)false, (String)null) : new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)38, (Number)0, (Boolean)false, (String)null))));
        return type;
    }

    private void onError(Log.Level level, String message, ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            switch (this.onError) {
                case SILENT: {
                    break;
                }
                case LOG: {
                    log.log(level, (Object)message, (Throwable)e);
                    break;
                }
                case FAIL: {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

