/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.tools.StringUtils;
import org.jooq.util.postgres.PostgresDSL;

public class PostgresTableDefinition
extends AbstractTableDefinition {
    public PostgresTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public PostgresTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        PostgresDatabase database = (PostgresDatabase)this.getDatabase();
        TableField<Record, String> dataType = Tables.COLUMNS.DATA_TYPE;
        Name identityCount = DSL.name((String)"identity_count");
        for (Record record : this.create().select(Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.ORDINAL_POSITION, dataType, (SelectField)DSL.nvl(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH, (Field)DSL.when((Condition)Tables.COLUMNS.UDT_NAME.eq((Field)DSL.inline((String)"_varchar")), (Field)org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPMOD.sub((Field)DSL.inline((int)4)))).as(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), Tables.COLUMNS.NUMERIC_PRECISION, Tables.COLUMNS.NUMERIC_SCALE, (SelectField)(database.is10() ? Tables.COLUMNS.IS_IDENTITY : DSL.val(null, String.class)).as(Tables.COLUMNS.IS_IDENTITY), (SelectField)(database.is10() ? DSL.count().filterWhere(Tables.COLUMNS.IS_IDENTITY.eq((Field)DSL.inline((String)"YES"))).over() : DSL.zero()).as(identityCount), Tables.COLUMNS.IS_NULLABLE, Tables.COLUMNS.COLUMN_DEFAULT, Tables.COLUMNS.UDT_SCHEMA, Tables.COLUMNS.UDT_NAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION).from((TableLike)Tables.COLUMNS).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.COLUMNS.TABLE_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.eq(Tables.COLUMNS.TABLE_NAME)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTRELID.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTNAME.eq(Tables.COLUMNS.COLUMN_NAME)).leftOuterJoin((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq(Tables.COLUMNS.ORDINAL_POSITION)).where(Tables.COLUMNS.TABLE_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.COLUMNS.TABLE_NAME.equal((Object)this.getName())).orderBy(Tables.COLUMNS.ORDINAL_POSITION).fetch()) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(Tables.COLUMNS.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(dataType), (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION), (Number)record.get(Tables.COLUMNS.NUMERIC_SCALE), (Boolean)record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), DSL.name((String[])new String[]{(String)record.get(Tables.COLUMNS.UDT_SCHEMA), (String)record.get(Tables.COLUMNS.UDT_NAME)}));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), (int)((Integer)record.get(Tables.COLUMNS.ORDINAL_POSITION, Integer.TYPE)), (DataTypeDefinition)type, (Integer)record.get(identityCount, Integer.TYPE) > 0 ? ((Boolean)record.get(Tables.COLUMNS.IS_IDENTITY, Boolean.TYPE)).booleanValue() : StringUtils.defaultString((String)((String)record.get(Tables.COLUMNS.COLUMN_DEFAULT))).trim().toLowerCase().startsWith("nextval"), (String)record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION));
            result.add(column);
        }
        return result;
    }
}

