/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jooq.meta.AbstractConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public class DefaultForeignKeyDefinition
extends AbstractConstraintDefinition
implements ForeignKeyDefinition {
    private final List<ColumnDefinition> keyColumns = new ArrayList<ColumnDefinition>();
    private final UniqueKeyDefinition uniqueKey;

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uniqueKey) {
        this(schema, name, table, uniqueKey, true);
    }

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uniqueKey, boolean enforced) {
        super(schema, table, name, enforced);
        this.uniqueKey = uniqueKey;
    }

    @Override
    public TableDefinition getKeyTable() {
        return this.getTable();
    }

    @Override
    public List<ColumnDefinition> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public UniqueKeyDefinition getReferencedKey() {
        return this.uniqueKey;
    }

    @Override
    public TableDefinition getReferencedTable() {
        return this.uniqueKey.getTable();
    }

    @Override
    public List<ColumnDefinition> getReferencedColumns() {
        return this.uniqueKey.getKeyColumns();
    }

    @Override
    public int countSimilarReferences() {
        HashSet<String> keys = new HashSet<String>();
        for (ForeignKeyDefinition key : this.getDatabase().getRelations().getForeignKeys(this.getTable())) {
            if (!key.getReferencedTable().equals(this.getReferencedTable())) continue;
            keys.add(key.getName());
        }
        return keys.size();
    }
}

