/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.h2.information_schema.Tables;
import org.jooq.tools.StringUtils;

public class H2TableDefinition
extends AbstractTableDefinition {
    public H2TableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public H2TableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Param maxP = DSL.inline((int)65535);
        Param maxS = DSL.inline((int)Short.MAX_VALUE);
        for (Record record : this.create().select(Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.ORDINAL_POSITION, (SelectField)(((H2Database)this.getDatabase()).is1_4_198() ? DSL.when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any((Field[])new Field[]{DSL.inline((String)"%YEAR%"), DSL.inline((String)"%MONTH%")})), (Field)DSL.inline((String)"INTERVAL YEAR TO MONTH")).when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any((Field[])new Field[]{DSL.inline((String)"%DAY%"), DSL.inline((String)"%HOUR%"), DSL.inline((String)"%MINUTE%"), DSL.inline((String)"%SECOND%")})), (Field)DSL.inline((String)"INTERVAL DAY TO SECOND")).else_(Tables.COLUMNS.TYPE_NAME) : Tables.COLUMNS.TYPE_NAME).as(Tables.COLUMNS.TYPE_NAME), (SelectField)(((H2Database)this.getDatabase()).is1_4_197() ? Tables.COLUMNS.COLUMN_TYPE : Tables.COLUMNS.TYPE_NAME).as(Tables.COLUMNS.COLUMN_TYPE), (SelectField)DSL.choose().when(Tables.COLUMNS.NUMERIC_PRECISION.eq((Field)maxP).and(Tables.COLUMNS.NUMERIC_SCALE.eq((Field)maxS)), (Field)DSL.zero()).otherwise(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH).as(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (SelectField)Tables.COLUMNS.NUMERIC_PRECISION.decode((Field)maxP, (Field)DSL.zero(), new Field[]{Tables.COLUMNS.NUMERIC_PRECISION}).as(Tables.COLUMNS.NUMERIC_PRECISION), (SelectField)Tables.COLUMNS.NUMERIC_SCALE.decode((Field)maxS, (Field)DSL.zero(), new Field[]{Tables.COLUMNS.NUMERIC_SCALE}).as(Tables.COLUMNS.NUMERIC_SCALE), Tables.COLUMNS.IS_NULLABLE, Tables.COLUMNS.COLUMN_DEFAULT, Tables.COLUMNS.REMARKS, Tables.COLUMNS.SEQUENCE_NAME, Tables.COLUMNS.DOMAIN_SCHEMA, Tables.COLUMNS.DOMAIN_NAME).from((TableLike)Tables.COLUMNS).where(Tables.COLUMNS.TABLE_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.COLUMNS.TABLE_NAME.equal((Object)this.getName())).and((Condition)(!this.getDatabase().getIncludeInvisibleColumns() ? (((H2Database)this.getDatabase()).is1_4_198() ? Tables.COLUMNS.IS_VISIBLE.eq((Field)DSL.inline((String)"TRUE")) : Tables.COLUMNS.COLUMN_TYPE.notLike((Field)DSL.inline((String)"%INVISIBLE%"))) : DSL.noCondition())).orderBy(Tables.COLUMNS.ORDINAL_POSITION)) {
            boolean isIdentity = null != record.get(Tables.COLUMNS.SEQUENCE_NAME) || StringUtils.defaultString((String)((String)record.get(Tables.COLUMNS.COLUMN_DEFAULT))).trim().toLowerCase().startsWith("nextval");
            boolean isTimestamp = ((String)record.get(Tables.COLUMNS.TYPE_NAME)).trim().toLowerCase().startsWith("timestamp");
            Name userType = record.get(Tables.COLUMNS.DOMAIN_NAME) != null ? DSL.name((String[])new String[]{(String)record.get(Tables.COLUMNS.DOMAIN_SCHEMA), (String)record.get(Tables.COLUMNS.DOMAIN_NAME)}) : DSL.name((String[])new String[]{this.getSchema().getName(), this.getName() + "_" + (String)record.get(Tables.COLUMNS.COLUMN_NAME)});
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get(Tables.COLUMNS.TYPE_NAME), (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), isTimestamp ? (Number)((Number)record.get(Tables.COLUMNS.NUMERIC_SCALE)) : (Number)((Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION)), isTimestamp ? (Number)0 : (Number)((Number)record.get(Tables.COLUMNS.NUMERIC_SCALE)), (Boolean)record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), isIdentity ? null : (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), userType);
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), result.size() + 1, (DataTypeDefinition)type, isIdentity, (String)record.get(Tables.COLUMNS.REMARKS)));
        }
        return result;
    }
}

