/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.h2.information_schema.Tables;
import org.jooq.tools.StringUtils;

public class H2TableDefinition
extends AbstractTableDefinition {
    public H2TableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public H2TableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    final H2Database getH2Database() {
        return (H2Database)super.getDatabase();
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        if (this.getH2Database().is2_0_202()) {
            return this.getElements2_0();
        }
        return this.getElements1_4();
    }

    public List<ColumnDefinition> getElements2_0() {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        H2Database db = (H2Database)this.getDatabase();
        for (Record record : this.create().select(Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.ORDINAL_POSITION, (SelectField)DSL.nvl((Field)DSL.concat((Field[])new Field[]{org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.DATA_TYPE, DSL.inline((String)" ARRAY")}), (Field)DSL.when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any((Field[])new Field[]{DSL.inline((String)"%YEAR%"), DSL.inline((String)"%MONTH%")})), (Field)DSL.inline((String)"INTERVAL YEAR TO MONTH")).when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any((Field[])new Field[]{DSL.inline((String)"%DAY%"), DSL.inline((String)"%HOUR%"), DSL.inline((String)"%MINUTE%"), DSL.inline((String)"%SECOND%")})), (Field)DSL.inline((String)"INTERVAL DAY TO SECOND")).else_(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.DATA_TYPE)).as(Tables.COLUMNS.TYPE_NAME), (SelectField)DSL.nvl(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.CHARACTER_MAXIMUM_LENGTH, Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH).as(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (SelectField)DSL.coalesce(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.DATETIME_PRECISION, (Field[])new Field[]{org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.NUMERIC_PRECISION, Tables.COLUMNS.DATETIME_PRECISION, Tables.COLUMNS.NUMERIC_PRECISION}).as(Tables.COLUMNS.NUMERIC_PRECISION), (SelectField)DSL.nvl(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.NUMERIC_SCALE, Tables.COLUMNS.NUMERIC_SCALE).as(Tables.COLUMNS.NUMERIC_SCALE), Tables.COLUMNS.IS_NULLABLE, (SelectField)DSL.field((Condition)org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.IS_GENERATED.eq((Field)DSL.inline((String)"ALWAYS"))).as(Tables.COLUMNS.IS_COMPUTED), org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.GENERATION_EXPRESSION, Tables.COLUMNS.COLUMN_DEFAULT, Tables.COLUMNS.REMARKS, (SelectField)DSL.field((Condition)org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.IS_IDENTITY.eq((Field)DSL.inline((String)"YES"))).as(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.IS_IDENTITY), Tables.COLUMNS.DOMAIN_SCHEMA, Tables.COLUMNS.DOMAIN_NAME).from((TableLike)Tables.COLUMNS).leftJoin((TableLike)org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES).on(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.TABLE_SCHEMA.equal(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.TABLE_NAME.equal(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.OBJECT_NAME)).and(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.DTD_IDENTIFIER.equal(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(Tables.COLUMNS.TABLE_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.COLUMNS.TABLE_NAME.equal((Object)this.getName())).and(!this.getDatabase().getIncludeInvisibleColumns() ? DSL.condition((Field)Tables.COLUMNS.IS_VISIBLE.coerce(SQLDataType.BOOLEAN)) : DSL.noCondition()).orderBy(Tables.COLUMNS.ORDINAL_POSITION)) {
            boolean isIdentity = (Boolean)record.get(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.IS_IDENTITY, Boolean.TYPE) != false || StringUtils.defaultString((String)((String)record.get(Tables.COLUMNS.COLUMN_DEFAULT))).trim().toLowerCase().startsWith("nextval");
            boolean isComputed = (Boolean)record.get(Tables.COLUMNS.IS_COMPUTED, Boolean.TYPE);
            Name userType = record.get(Tables.COLUMNS.DOMAIN_NAME) != null ? DSL.name((String[])new String[]{(String)record.get(Tables.COLUMNS.DOMAIN_SCHEMA), (String)record.get(Tables.COLUMNS.DOMAIN_NAME)}) : DSL.name((String[])new String[]{this.getSchema().getName(), this.getName() + "_" + (String)record.get(Tables.COLUMNS.COLUMN_NAME)});
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get(Tables.COLUMNS.TYPE_NAME), (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION), (Number)record.get(Tables.COLUMNS.NUMERIC_SCALE), (Boolean)record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), isIdentity || isComputed ? null : (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), userType).generatedAlwaysAs(isComputed ? (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.COLUMNS.GENERATION_EXPRESSION) : null);
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), result.size() + 1, (DataTypeDefinition)type, isIdentity, (String)record.get(Tables.COLUMNS.REMARKS)));
        }
        return result;
    }

    public List<ColumnDefinition> getElements1_4() {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Param maxP = DSL.inline((long)65535L);
        Param maxS = DSL.inline((long)32767L);
        H2Database db = (H2Database)this.getDatabase();
        for (Record record : this.create().select(Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.ORDINAL_POSITION, (SelectField)(db.is1_4_198() ? DSL.when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any((Field[])new Field[]{DSL.inline((String)"%YEAR%"), DSL.inline((String)"%MONTH%")})), (Field)DSL.inline((String)"INTERVAL YEAR TO MONTH")).when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any((Field[])new Field[]{DSL.inline((String)"%DAY%"), DSL.inline((String)"%HOUR%"), DSL.inline((String)"%MINUTE%"), DSL.inline((String)"%SECOND%")})), (Field)DSL.inline((String)"INTERVAL DAY TO SECOND")).else_(Tables.COLUMNS.TYPE_NAME) : Tables.COLUMNS.TYPE_NAME).as(Tables.COLUMNS.TYPE_NAME), (SelectField)DSL.choose().when(Tables.COLUMNS.NUMERIC_PRECISION.eq((Field)maxP).and(Tables.COLUMNS.NUMERIC_SCALE.eq((Field)maxS)), (Field)DSL.inline((long)0L)).otherwise(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH).as(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (SelectField)Tables.COLUMNS.NUMERIC_PRECISION.decode((Field)maxP, (Field)DSL.inline((long)0L), new Field[]{Tables.COLUMNS.NUMERIC_PRECISION}).as(Tables.COLUMNS.NUMERIC_PRECISION), (SelectField)Tables.COLUMNS.NUMERIC_SCALE.decode((Field)maxS, (Field)DSL.inline((long)0L), new Field[]{Tables.COLUMNS.NUMERIC_SCALE}).as(Tables.COLUMNS.NUMERIC_SCALE), Tables.COLUMNS.IS_NULLABLE, (SelectField)Tables.COLUMNS.IS_COMPUTED.as(Tables.COLUMNS.IS_COMPUTED), (SelectField)Tables.COLUMNS.COLUMN_DEFAULT.as("GENERATION_EXPRESSION"), Tables.COLUMNS.COLUMN_DEFAULT, Tables.COLUMNS.REMARKS, (SelectField)DSL.field((Condition)Tables.COLUMNS.SEQUENCE_NAME.isNotNull()).as("IS_IDENTITY"), (SelectField)(db.is1_4_198() ? Tables.COLUMNS.DOMAIN_SCHEMA : DSL.inline((String)"").as(Tables.COLUMNS.DOMAIN_SCHEMA)), db.is1_4_198() ? Tables.COLUMNS.DOMAIN_NAME : DSL.inline((String)"").as(Tables.COLUMNS.DOMAIN_NAME)).from((TableLike)Tables.COLUMNS).where(Tables.COLUMNS.TABLE_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.COLUMNS.TABLE_NAME.equal((Object)this.getName())).and((Condition)(!this.getDatabase().getIncludeInvisibleColumns() ? (db.is1_4_198() ? Tables.COLUMNS.IS_VISIBLE.eq((Field)DSL.inline((String)"TRUE")) : Tables.COLUMNS.COLUMN_TYPE.notLike((Field)DSL.inline((String)"%INVISIBLE%"))) : DSL.noCondition())).orderBy(Tables.COLUMNS.ORDINAL_POSITION)) {
            boolean isIdentity = (Boolean)record.get("IS_IDENTITY", Boolean.TYPE) != false || StringUtils.defaultString((String)((String)record.get(Tables.COLUMNS.COLUMN_DEFAULT))).trim().toLowerCase().startsWith("nextval");
            boolean isComputed = (Boolean)record.get(Tables.COLUMNS.IS_COMPUTED, Boolean.TYPE);
            boolean isTimestamp = ((String)record.get(Tables.COLUMNS.TYPE_NAME)).trim().toLowerCase().startsWith("timestamp");
            Name userType = record.get(Tables.COLUMNS.DOMAIN_NAME) != null ? DSL.name((String[])new String[]{(String)record.get(Tables.COLUMNS.DOMAIN_SCHEMA), (String)record.get(Tables.COLUMNS.DOMAIN_NAME)}) : DSL.name((String[])new String[]{this.getSchema().getName(), this.getName() + "_" + (String)record.get(Tables.COLUMNS.COLUMN_NAME)});
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get(Tables.COLUMNS.TYPE_NAME), (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), isTimestamp ? (Number)((Number)record.get(Tables.COLUMNS.NUMERIC_SCALE)) : (Number)((Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION)), isTimestamp ? (Number)0 : (Number)((Number)record.get(Tables.COLUMNS.NUMERIC_SCALE)), (Boolean)record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), isIdentity || isComputed ? null : (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), userType).generatedAlwaysAs(isComputed ? (String)record.get("GENERATION_EXPRESSION", String.class) : null);
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), result.size() + 1, (DataTypeDefinition)type, isIdentity, (String)record.get(Tables.COLUMNS.REMARKS)));
        }
        return result;
    }
}

