/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.derby;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.XMLSchemaCollectionDefinition;
import org.jooq.meta.derby.DerbyTableDefinition;
import org.jooq.meta.derby.sys.Tables;

public class DerbyDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSSCHEMAS.SCHEMANAME));
            String key = (String)record.get(Tables.SYSCONSTRAINTS.CONSTRAINTNAME);
            String tableName = (String)record.get(Tables.SYSTABLES.TABLENAME);
            String descriptor = (String)record.get(Tables.SYSCONGLOMERATES.DESCRIPTOR, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations2.addPrimaryKey(key, table, table.getColumn(index));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSSCHEMAS.SCHEMANAME));
            String key = (String)record.get(Tables.SYSCONSTRAINTS.CONSTRAINTNAME);
            String tableName = (String)record.get(Tables.SYSTABLES.TABLENAME);
            String descriptor = (String)record.get(Tables.SYSCONGLOMERATES.DESCRIPTOR, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations2.addUniqueKey(key, table, table.getColumn(index));
            }
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return null;
    }

    private Result<Record5<String, String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Tables.SYSKEYS.sysconglomerates().systables().sysschemas().SCHEMANAME, Tables.SYSKEYS.sysconglomerates().systables().TABLENAME, Tables.SYSKEYS.sysconglomerates().systables().TABLEID, Tables.SYSKEYS.sysconstraints().CONSTRAINTNAME, Tables.SYSKEYS.sysconglomerates().DESCRIPTOR).from((TableLike)Tables.SYSKEYS).where(Tables.SYSKEYS.sysconglomerates().systables().sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).and(Tables.SYSKEYS.sysconstraints().TYPE.cast(SQLDataType.VARCHAR((int)32672)).equal((Object)constraintType)).orderBy(Tables.SYSKEYS.sysconglomerates().systables().sysschemas().SCHEMANAME, Tables.SYSKEYS.sysconglomerates().systables().TABLENAME, Tables.SYSKEYS.sysconstraints().CONSTRAINTNAME).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Field fkName = DSL.field((String)"fc.constraintname", String.class);
        Field fkTable = DSL.field((String)"ft.tablename", String.class);
        Field fkSchema = DSL.field((String)"fs.schemaname", String.class);
        Field fkDescriptor = DSL.field((String)"fg.descriptor");
        Field ukName = DSL.field((String)"pc.constraintname", String.class);
        Field ukTable = DSL.field((String)"pt.tablename", String.class);
        Field ukSchema = DSL.field((String)"ps.schemaname", String.class);
        for (Record record : this.create().select((SelectField)fkName, (SelectField)fkTable, (SelectField)fkSchema, (SelectField)fkDescriptor, (SelectField)ukName, (SelectField)ukTable, (SelectField)ukSchema).from("sys.sysconstraints   fc").join("sys.sysforeignkeys   f ").on("f.constraintid = fc.constraintid").join("sys.sysconglomerates fg").on("fg.conglomerateid = f.conglomerateid").join("sys.systables        ft").on("ft.tableid = fg.tableid").join("sys.sysschemas       fs").on("ft.schemaid = fs.schemaid").join("sys.sysconstraints   pc").on("pc.constraintid = f.keyconstraintid").join("sys.systables        pt").on("pt.tableid = pc.tableid").join("sys.sysschemas       ps").on("ps.schemaid = pt.schemaid").where("cast(fc.type as varchar(32672)) = 'F'").orderBy((OrderField)fkSchema, (OrderField)fkTable, (OrderField)fkName)) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(fkSchema));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(ukSchema));
            String foreignKeyName = (String)record.get(fkName);
            String foreignKeyTableName = (String)record.get(fkTable);
            List<Integer> foreignKeyIndexes = this.decode((String)record.get(fkDescriptor, String.class));
            String uniqueKeyName = (String)record.get(ukName);
            String uniqueKeyTableName = (String)record.get(ukTable);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            for (int i = 0; i < foreignKeyIndexes.size(); ++i) {
                relations2.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyIndexes.get(i)), uniqueKeyName, uniqueKeyTable);
            }
        }
    }

    private List<Integer> decode(String descriptor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern p = Pattern.compile(".*?\\((.*?)\\)");
        Matcher m = p.matcher(descriptor);
        while (m.find()) {
            String[] split = m.group(1).split(",");
            if (split == null) continue;
            for (String index : split) {
                result.add(Integer.parseInt(index.trim()) - 1);
            }
        }
        return result;
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Tables.SYSCHECKS.sysconstraints().systables().sysschemas().SCHEMANAME, Tables.SYSCHECKS.sysconstraints().systables().TABLENAME, Tables.SYSCHECKS.sysconstraints().CONSTRAINTNAME, Tables.SYSCHECKS.CHECKDEFINITION).from((TableLike)Tables.SYSCHECKS).where(Tables.SYSCHECKS.sysconstraints().systables().sysschemas().SCHEMANAME.in(this.getInputSchemata()))) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSCHECKS.sysconstraints().systables().sysschemas().SCHEMANAME));
            TableDefinition table = this.getTable(schema, (String)record.get(Tables.SYSCHECKS.sysconstraints().systables().TABLENAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(Tables.SYSCHECKS.sysconstraints().CONSTRAINTNAME), (String)record.get(Tables.SYSCHECKS.CHECKDEFINITION)));
        }
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        for (Record record : this.create().select(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME, Tables.SYSCONGLOMERATES.systables().TABLENAME, Tables.SYSCONGLOMERATES.CONGLOMERATENAME, Tables.SYSCONGLOMERATES.DESCRIPTOR).from((TableLike)Tables.SYSCONGLOMERATES).where(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).and(Tables.SYSCONGLOMERATES.ISINDEX).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.not((Condition)DSL.condition(Tables.SYSCONGLOMERATES.ISCONSTRAINT))).orderBy(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME, Tables.SYSCONGLOMERATES.systables().TABLENAME, Tables.SYSCONGLOMERATES.CONGLOMERATENAME)) {
            String descriptor;
            SchemaDefinition tableSchema = this.getSchema((String)record.get(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME));
            if (tableSchema == null) continue;
            String indexName = (String)record.get(Tables.SYSCONGLOMERATES.CONGLOMERATENAME);
            String tableName = (String)record.get(Tables.SYSCONGLOMERATES.systables().TABLENAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null || (descriptor = (String)record.get(Tables.SYSCONGLOMERATES.DESCRIPTOR)) == null) continue;
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, descriptor.toUpperCase().contains("UNIQUE")){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    List<Integer> columnIndexes = DerbyDatabase.this.decode(descriptor);
                    for (int i = 0; i < columnIndexes.size(); ++i) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn(columnIndexes.get(i)), SortOrder.ASC, i + 1));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return (List)this.create().select(Tables.SYSSCHEMAS.SCHEMANAME).from((TableLike)Tables.SYSSCHEMAS).collect(Collectors.mapping(r -> new SchemaDefinition((Database)this, (String)r.value1(), ""), Collectors.toList()));
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return this.create().select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).cast(SQLDataType.VARCHAR).as("catalog"), Tables.SYSSEQUENCES.sysschemas().SCHEMANAME, Tables.SYSSEQUENCES.SEQUENCENAME, Tables.SYSSEQUENCES.SEQUENCEDATATYPE, (SelectField)DSL.inline(null, (DataType)SQLDataType.INTEGER).cast(SQLDataType.INTEGER).as("numeric_precision"), (SelectField)DSL.inline(null, (DataType)SQLDataType.INTEGER).cast(SQLDataType.INTEGER).as("numeric_scale"), (SelectField)DSL.nullif(Tables.SYSSEQUENCES.STARTVALUE, (Field)DSL.inline((long)1L)).as(Tables.SYSSEQUENCES.STARTVALUE), (SelectField)DSL.nullif(Tables.SYSSEQUENCES.INCREMENT, (Field)DSL.inline((long)1L)).as(Tables.SYSSEQUENCES.INCREMENT), (SelectField)DSL.nullif(Tables.SYSSEQUENCES.MINIMUMVALUE, (Field)DSL.case_((Field)DSL.cast(Tables.SYSSEQUENCES.SEQUENCEDATATYPE, (DataType)SQLDataType.VARCHAR)).when((Field)DSL.inline((String)"SMALLINT"), (Field)DSL.inline((long)-32768L)).when((Field)DSL.inline((String)"INTEGER"), (Field)DSL.inline((long)Integer.MIN_VALUE)).when((Field)DSL.inline((String)"BIGINT"), (Field)DSL.inline((long)Long.MIN_VALUE))).coerce(SQLDataType.NUMERIC).as(Tables.SYSSEQUENCES.MINIMUMVALUE), (SelectField)DSL.nullif(Tables.SYSSEQUENCES.MAXIMUMVALUE, (Field)DSL.case_((Field)DSL.cast(Tables.SYSSEQUENCES.SEQUENCEDATATYPE, (DataType)SQLDataType.VARCHAR)).when((Field)DSL.inline((String)"SMALLINT"), (Field)DSL.inline((long)32767L)).when((Field)DSL.inline((String)"INTEGER"), (Field)DSL.inline((long)Integer.MAX_VALUE)).when((Field)DSL.inline((String)"BIGINT"), (Field)DSL.inline((long)Long.MAX_VALUE))).coerce(SQLDataType.NUMERIC).as(Tables.SYSSEQUENCES.MAXIMUMVALUE), (SelectField)Tables.SYSSEQUENCES.CYCLEOPTION.eq((Field)DSL.inline((String)"Y")).as(Tables.SYSSEQUENCES.CYCLEOPTION), (SelectField)DSL.inline(null, (DataType)SQLDataType.BIGINT).cast(SQLDataType.BIGINT).as("cache")).from((TableLike)Tables.SYSSEQUENCES).where(Tables.SYSSEQUENCES.sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(schemas)).orderBy(Tables.SYSSEQUENCES.sysschemas().SCHEMANAME, Tables.SYSSEQUENCES.SEQUENCENAME);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSSEQUENCES.sysschemas().SCHEMANAME));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.get(Tables.SYSSEQUENCES.SEQUENCEDATATYPE));
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SYSSEQUENCES.SEQUENCENAME), type, null, (Number)record.get(Tables.SYSSEQUENCES.STARTVALUE), (Number)record.get(Tables.SYSSEQUENCES.INCREMENT), (Number)record.get(Tables.SYSSEQUENCES.MINIMUMVALUE), (Number)record.get(Tables.SYSSEQUENCES.MAXIMUMVALUE), (Boolean)record.get(Tables.SYSSEQUENCES.CYCLEOPTION, Boolean.class), null));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.SYSTABLES.sysschemas().SCHEMANAME, Tables.SYSTABLES.TABLENAME, Tables.SYSTABLES.TABLEID, (SelectField)DSL.when((Condition)Tables.SYSTABLES.TABLETYPE.eq((Field)DSL.inline((String)"V")), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).as("table_type"), Tables.SYSVIEWS.VIEWDEFINITION).from((TableLike)Tables.SYSTABLES).leftJoin((TableLike)Tables.SYSVIEWS).on(Tables.SYSTABLES.TABLEID.eq(Tables.SYSVIEWS.TABLEID)).where(Tables.SYSTABLES.sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).orderBy(Tables.SYSTABLES.sysschemas().SCHEMANAME, Tables.SYSTABLES.TABLENAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSTABLES.sysschemas().SCHEMANAME));
            String name = (String)record.get(Tables.SYSTABLES.TABLENAME);
            String id = (String)record.get(Tables.SYSTABLES.TABLEID);
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(Tables.SYSVIEWS.VIEWDEFINITION);
            DerbyTableDefinition table = new DerbyTableDefinition(schema, name, id, tableType, source);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<XMLSchemaCollectionDefinition> getXMLSchemaCollections0() throws SQLException {
        ArrayList<XMLSchemaCollectionDefinition> result = new ArrayList<XMLSchemaCollectionDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.DERBY);
    }
}

